-- MySQL dump 10.13  Distrib 8.4.4, for macos15 (arm64)
--
-- Host: 127.0.0.1    Database: flex_home
-- ------------------------------------------------------
-- Server version	8.4.4

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `code` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'NAsA0Jw6VYjy2E3eKwfRFco4UIAJLUIW',1,'2025-04-29 17:14:51','2025-04-29 17:14:51','2025-04-29 17:14:51');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tablet_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','Explore Our Exciting New Property Listings Now Available in Prime Locations!',0,NULL,NULL,0,1,'2025-04-30 00:15:10',NULL,1,'2025-04-29 17:15:10','2025-04-29 17:15:10'),(2,'Announcement 2','Join Us for Exclusive Open House Events This Weekend and Find Your Perfect Home!',0,NULL,NULL,0,1,'2025-04-30 00:15:10',NULL,1,'2025-04-29 17:15:10','2025-04-29 17:15:10'),(3,'Announcement 3','Take Advantage of Limited-Time Offers on Luxury Homes with Stunning Features!',0,NULL,NULL,0,1,'2025-04-30 00:15:10',NULL,1,'2025-04-29 17:15:10','2025-04-29 17:15:10'),(4,'Announcement 4','Discover Your Dream Home with Our Latest Listings and Personalized Services!',0,NULL,NULL,0,1,'2025-04-30 00:15:10',NULL,1,'2025-04-29 17:15:10','2025-04-29 17:15:10');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `action_label` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `user_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` int unsigned NOT NULL,
  `actor_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` int unsigned NOT NULL,
  `reference_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
INSERT INTO `audit_histories` VALUES (2,1,'Botble\\ACL\\Models\\User','language','{\"lang_id\":\"0\",\"lang_name\":\"Ti\\u1ebfng Vi\\u1ec7t\",\"lang_locale\":\"vi\",\"lang_code\":\"vi\",\"lang_flag\":\"vn\",\"lang_order\":\"0\",\"lang_is_rtl\":\"0\"}','created','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36','127.0.0.1',1,'Botble\\ACL\\Models\\User',2,'','info','2023-06-23 02:53:00','2023-06-23 02:53:00'),(3,1,'Botble\\ACL\\Models\\User','language','{\"_method\":\"DELETE\"}','deleted','Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36','127.0.0.1',1,'Botble\\ACL\\Models\\User',2,'','danger','2023-06-23 02:53:15','2023-06-23 02:53:15');
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `careers`
--

DROP TABLE IF EXISTS `careers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `careers` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salary` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `careers`
--

LOCK TABLES `careers` WRITE;
/*!40000 ALTER TABLE `careers` DISABLE KEYS */;
INSERT INTO `careers` VALUES (1,'Sales Manager (Up to 2600$)','Ho Chi Minh, Viet Nam','1300$ - 2600$','<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>BENEFITS FOR YOU</strong></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Applicants receive a salary from 1300 USD to 2600 USD<br />\r\n- Fully enjoy the regimes according to Vietnam&#39;s Labor Law: Social insurance, health insurance, unemployment insurance<br />\r\n- Trained to improve expertise and capacity in suitable positions.</span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>JOB DESCRIPTION</strong></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Coordinate with the Investment Department in organizing the collection, analysis, evaluation of market information and submitting proposals for planning the project&#39;s products and investment cooperation plans (if any);<br />\r\n- Acting as a focal point of exploitation and trading with customers, managing trading floors and distributors;<br />\r\n- Checking and approving the selection of sales units, management units for exploitation, operation and investment cooperation;<br />\r\n- Leading the negotiation and management of contracts with customers, sales units, management of exploitation, operation and investment cooperation;<br />\r\n- Prepare and submit a price approval for the sale, lease, and cooperation prices of all real estate projects;<br />\r\n- Develop sales plans, sales policies, support and promotions;<br />\r\n- Coordinate with member companies (Project Management Board) to collect and hand over product records (technical documents, red books, sales contracts ...) to hand over customers;<br />\r\n- Deploy customer support activities;</span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>JOB REQUIREMENTS</strong></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Preferred age: 30-35<br />\r\n- University degree in Business Administration, Economics, or related industries.<br />\r\n- Over 03 years of experience in assuming the position of Real Estate Business City<br />\r\n- Priority with a certificate of real estate broker, certificate of real estate trading floor management<br />\r\n- Good planning, operating, and control skills<br />\r\n- Good communication, negotiation and problem-solving skills</span></span></p>','published','2019-11-30 19:43:10','2019-11-30 19:46:53',NULL),(3,'Senior Real Estate Consultant Demo','Ho Chi Minh, Viet Nam','From 1500$','<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>BENEFITS FOR YOU</strong></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Basic salary 500$&nbsp;/ month.<br />\r\n- Access to diverse sources of goods and opportunities from reputable investors.<br />\r\n- Retrospective salary policy up to 2400$-7000$&nbsp;/ year.<br />\r\n- Commission of 22-50% and a commission 1000$ / successful transaction in the month.<br />\r\n- Effective bonus 0.6-3% of annual revenue.<br />\r\n- A place to build your personal brand in a standard and different way.<br />\r\n- Attend seminars on real estate every 6 months.<br />\r\n- Participate in the course on negotiation skills (Win - Win), language of sales (Language of Sales), customer mind marketing (SOI), customer conversion from social networks (Go Social)<br />\r\n- Unlimited promotion opportunities.<br />\r\n- Working with professional space and modern open office design.<br />\r\n- Welfare policy, domestic and foreign tourism ...<br />\r\n- Decentralized, democratic, financial transparency, considering brokerage is a business partner.<br />\r\n- Environmentally friendly, is the place where brokers are connected with regular activities</span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>JOB DESCRIPTION</strong></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Quantity: 30 employees<br />\r\n- Find and exploit potential customers for real estate products valued from 2000 USD / m2 in the high-end and luxury segment;<br />\r\n- Deploying activities to find customers, coordinate with teams to realize sales targets<br />\r\n- Advise customers on information related to products and projects of the Company;</span></span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>JOB REQUIREMENTS</strong></span></span></p>\r\n\r\n<p><span style=\"font-size:14px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Graduating from college or higher<br />\r\n- Good appearance, male height from 1.68m, female from 1.58m. Age from 22-35 years old<br />\r\n- Priority to candidates who know foreign languages ​​and have 1 year or more experience in the field of real estate, banking and finance.<br />\r\n- Have financial goals, work and life.<br />\r\n- Desire to achieve big goals.<br />\r\n- Diligent, persistent, honest.</span></span></p>','published','2019-11-30 19:52:42','2021-01-03 17:26:17',NULL);
/*!40000 ALTER TABLE `careers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `careers_translations`
--

DROP TABLE IF EXISTS `careers_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `careers_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `careers_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `salary` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`careers_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `careers_translations`
--

LOCK TABLES `careers_translations` WRITE;
/*!40000 ALTER TABLE `careers_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `careers_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_status_created_at_index` (`parent_id`,`status`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'News',0,'Nam nihil rerum voluptate aut dolores enim. Reprehenderit et quasi molestias cum et porro. Beatae et eaque earum non harum fuga. Hic illum nesciunt omnis voluptates temporibus velit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(2,'House architecture',0,'Debitis deleniti quas laborum temporibus. Quibusdam quos cupiditate ut omnis. Modi qui nemo beatae velit sint est distinctio.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(3,'House design',0,'Neque asperiores dolores repellat aliquid. Magnam rerum quis modi. Ipsum voluptatibus et ea aliquam natus corporis rerum. Quia quisquam ut minima consectetur eligendi.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(4,'Building materials',0,'Enim iusto totam architecto aut non nulla quia. Voluptatem a sed voluptas quasi est cupiditate. Quasi quas magnam excepturi esse.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-04-29 17:14:58','2025-04-29 17:14:58');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` int unsigned NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `slug` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `record_id` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zip_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Alhambra',1,1,0,0,'cities/location-1.jpg','published','2019-11-18 08:18:42','2019-12-03 05:55:52','alhambra',NULL,NULL),(2,'Oakland',1,1,0,0,'cities/location-2.jpg','published','2019-11-18 08:23:14','2019-12-03 05:55:52','oakland',NULL,NULL),(3,'Bakersfield',1,1,0,0,'cities/location-3.jpg','published','2019-11-18 08:26:54','2019-12-03 05:55:52','bakersfield',NULL,NULL),(4,'Anaheim',1,1,0,0,'cities/location-4.jpg','published','2019-11-18 08:27:57','2019-12-03 05:55:52','anaheim',NULL,NULL),(5,'San Francisco',1,1,0,0,'cities/location-5.jpg','published','2019-11-18 08:29:18','2019-12-03 05:55:52','san-francisco',NULL,NULL);
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` int NOT NULL,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'United States','United States of America',0,NULL,0,'published','2019-11-18 08:17:29','2019-11-18 08:17:29',NULL);
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` int NOT NULL,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `settings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int unsigned NOT NULL,
  `widget_id` int unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
INSERT INTO `dashboard_widget_settings` VALUES (1,NULL,1,7,0,1,'2019-11-26 02:40:58','2019-11-26 02:40:58'),(2,NULL,1,5,1,1,'2019-11-26 02:40:58','2019-11-26 02:40:58'),(3,NULL,1,6,2,1,'2019-11-26 02:40:58','2019-11-26 02:40:58'),(4,NULL,1,8,3,1,'2019-11-26 02:40:58','2019-11-26 02:40:58'),(5,NULL,1,9,4,1,'2019-11-26 02:40:58','2019-11-26 02:40:58'),(6,NULL,1,10,5,1,'2019-11-26 02:40:58','2019-11-26 02:40:58');
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
INSERT INTO `dashboard_widgets` VALUES (1,'widget_total_pages','2019-11-15 04:57:40','2019-11-15 04:57:40'),(2,'widget_total_users','2019-11-15 04:57:40','2019-11-15 04:57:40'),(3,'widget_total_plugins','2019-11-15 04:57:40','2019-11-15 04:57:40'),(4,'widget_total_themes','2019-11-15 04:57:40','2019-11-15 04:57:40'),(5,'widget_audit_logs','2019-11-15 18:54:50','2019-11-15 18:54:50'),(6,'widget_posts_recent','2019-11-15 18:54:50','2019-11-15 18:54:50'),(7,'widget_analytics_general','2019-11-15 18:54:50','2019-11-15 18:54:50'),(8,'widget_analytics_page','2019-11-15 18:54:50','2019-11-15 18:54:50'),(9,'widget_analytics_browser','2019-11-15 18:54:50','2019-11-15 18:54:50'),(10,'widget_analytics_referrer','2019-11-15 18:54:50','2019-11-15 18:54:50'),(11,'widget_total_1','2022-11-05 23:58:22','2022-11-05 23:58:22'),(12,'widget_total_2','2022-11-05 23:58:22','2022-11-05 23:58:22'),(13,'widget_total_3','2022-11-05 23:58:22','2022-11-05 23:58:22'),(14,'widget_total_4','2022-11-05 23:58:22','2022-11-05 23:58:22');
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_id` int unsigned NOT NULL,
  `lang_meta_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_type` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_meta_origin` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_lang_meta_content_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,1,'en_US','Botble\\Menu\\Models\\MenuLocation','00619055a04c4e7c82b17753b949ba37'),(2,1,'en_US','Botble\\Menu\\Models\\Menu','a4cab8a3b9366854b2323c672cb9864e'),(3,2,'en_US','Botble\\Menu\\Models\\Menu','c306f29034493939e89dad90eaaac8f7'),(4,3,'en_US','Botble\\Menu\\Models\\Menu','fad5d7030115abd6b0442f9bac3a3422'),(5,4,'en_US','Botble\\Menu\\Models\\Menu','eb4360e0e95b9d3115fcf719fc122da0');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` int unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` int unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_folder_id_user_id_created_at_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=59879 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (22702,0,'avatar','avatar',1129,'image/jpeg',151486,'users/avatar.jpg','[]','2023-10-25 00:12:49','2023-10-25 00:12:49',NULL,'public'),(59687,0,'banner','banner',1,'image/jpeg',17700,'banner/banner.jpg','[]','2025-04-29 17:14:43','2025-04-29 17:14:43',NULL,'public'),(59688,0,'location-1','location-1',2675,'image/jpeg',9803,'cities/location-1.jpg','[]','2025-04-29 17:14:43','2025-04-29 17:14:43',NULL,'public'),(59689,0,'location-2','location-2',2675,'image/jpeg',9803,'cities/location-2.jpg','[]','2025-04-29 17:14:43','2025-04-29 17:14:43',NULL,'public'),(59690,0,'location-3','location-3',2675,'image/jpeg',9803,'cities/location-3.jpg','[]','2025-04-29 17:14:43','2025-04-29 17:14:43',NULL,'public'),(59691,0,'location-4','location-4',2675,'image/jpeg',9803,'cities/location-4.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59692,0,'location-5','location-5',2675,'image/jpeg',9803,'cities/location-5.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59693,0,'1','1',2676,'image/jpeg',9803,'locations/1.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59694,0,'2','2',2676,'image/jpeg',9803,'locations/2.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59695,0,'3','3',2676,'image/jpeg',9803,'locations/3.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59696,0,'4','4',2676,'image/jpeg',9803,'locations/4.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59697,0,'5','5',2676,'image/jpeg',9803,'locations/5.jpg','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59698,0,'favicon','favicon',2677,'image/png',2392,'logo/favicon.png','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59699,0,'logo-white','logo-white',2677,'image/png',20236,'logo/logo-white.png','[]','2025-04-29 17:14:44','2025-04-29 17:14:44',NULL,'public'),(59700,0,'logo','logo',2677,'image/png',25650,'logo/logo.png','[]','2025-04-29 17:14:45','2025-04-29 17:14:45',NULL,'public'),(59701,0,'1','1',2678,'image/jpeg',9803,'accounts/1.jpg','[]','2025-04-29 17:14:46','2025-04-29 17:14:46',NULL,'public'),(59702,0,'10','10',2678,'image/jpeg',9803,'accounts/10.jpg','[]','2025-04-29 17:14:46','2025-04-29 17:14:46',NULL,'public'),(59703,0,'2','2',2678,'image/jpeg',9803,'accounts/2.jpg','[]','2025-04-29 17:14:46','2025-04-29 17:14:46',NULL,'public'),(59704,0,'3','3',2678,'image/jpeg',9803,'accounts/3.jpg','[]','2025-04-29 17:14:46','2025-04-29 17:14:46',NULL,'public'),(59705,0,'4','4',2678,'image/jpeg',9803,'accounts/4.jpg','[]','2025-04-29 17:14:46','2025-04-29 17:14:46',NULL,'public'),(59706,0,'5','5',2678,'image/jpeg',9803,'accounts/5.jpg','[]','2025-04-29 17:14:46','2025-04-29 17:14:46',NULL,'public'),(59707,0,'6','6',2678,'image/jpeg',9803,'accounts/6.jpg','[]','2025-04-29 17:14:47','2025-04-29 17:14:47',NULL,'public'),(59708,0,'7','7',2678,'image/jpeg',9803,'accounts/7.jpg','[]','2025-04-29 17:14:47','2025-04-29 17:14:47',NULL,'public'),(59709,0,'8','8',2678,'image/jpeg',9803,'accounts/8.jpg','[]','2025-04-29 17:14:47','2025-04-29 17:14:47',NULL,'public'),(59710,0,'9','9',2678,'image/jpeg',9803,'accounts/9.jpg','[]','2025-04-29 17:14:47','2025-04-29 17:14:47',NULL,'public'),(59711,0,'asset-3-at-3x','asset-3-at-3x',2679,'image/png',76803,'general/asset-3-at-3x.png','[]','2025-04-29 17:14:52','2025-04-29 17:14:52',NULL,'public'),(59712,0,'asset-4-at-3x','asset-4-at-3x',2679,'image/png',85535,'general/asset-4-at-3x.png','[]','2025-04-29 17:14:52','2025-04-29 17:14:52',NULL,'public'),(59713,0,'breadcrumb-background','breadcrumb-background',2679,'image/jpeg',505901,'general/breadcrumb-background.jpg','[]','2025-04-29 17:14:53','2025-04-29 17:14:53',NULL,'public'),(59714,0,'copyright','copyright',2679,'image/jpeg',48845,'general/copyright.jpg','[]','2025-04-29 17:14:53','2025-04-29 17:14:53',NULL,'public'),(59715,0,'home-banner','home-banner',2679,'image/jpeg',631290,'general/home-banner.jpg','[]','2025-04-29 17:14:53','2025-04-29 17:14:53',NULL,'public'),(59716,0,'newsletter-image','newsletter-image',2679,'image/jpeg',101293,'general/newsletter-image.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59717,0,'termsconditions-pagedesktop','termsconditions-pagedesktop',2679,'image/jpeg',78173,'general/termsconditions-pagedesktop.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59718,0,'video-vi-pham-ban-quyen-bi-youtube-thang-tay-trung-tri','video-vi-pham-ban-quyen-bi-youtube-thang-tay-trung-tri',2679,'image/jpeg',18757,'general/video-vi-pham-ban-quyen-bi-youtube-thang-tay-trung-tri.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59719,0,'vietnam-office-4','vietnam-office-4',2679,'image/jpeg',79608,'general/vietnam-office-4.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59720,0,'1','1',2680,'image/jpeg',66981,'news/1.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59721,0,'10','10',2680,'image/jpeg',38901,'news/10.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59722,0,'11','11',2680,'image/jpeg',51899,'news/11.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59723,0,'12','12',2680,'image/jpeg',55570,'news/12.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59724,0,'13','13',2680,'image/jpeg',82997,'news/13.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59725,0,'14','14',2680,'image/jpeg',66981,'news/14.jpg','[]','2025-04-29 17:14:54','2025-04-29 17:14:54',NULL,'public'),(59726,0,'15','15',2680,'image/jpeg',111464,'news/15.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59727,0,'16','16',2680,'image/jpeg',379750,'news/16.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59728,0,'2','2',2680,'image/jpeg',51879,'news/2.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59729,0,'3','3',2680,'image/jpeg',127122,'news/3.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59730,0,'4','4',2680,'image/jpeg',173868,'news/4.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59731,0,'5','5',2680,'image/jpeg',38901,'news/5.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59732,0,'6','6',2680,'image/jpeg',224569,'news/6.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59733,0,'7','7',2680,'image/jpeg',177684,'news/7.jpg','[]','2025-04-29 17:14:55','2025-04-29 17:14:55',NULL,'public'),(59734,0,'8','8',2680,'image/jpeg',111710,'news/8.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59735,0,'9','9',2680,'image/jpeg',143678,'news/9.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59736,0,'1','1',2681,'image/jpeg',66981,'posts/1.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59737,0,'10','10',2681,'image/jpeg',38901,'posts/10.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59738,0,'11','11',2681,'image/jpeg',51899,'posts/11.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59739,0,'12','12',2681,'image/jpeg',55570,'posts/12.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59740,0,'13','13',2681,'image/jpeg',82997,'posts/13.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59741,0,'14','14',2681,'image/jpeg',66981,'posts/14.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59742,0,'15','15',2681,'image/jpeg',111464,'posts/15.jpg','[]','2025-04-29 17:14:56','2025-04-29 17:14:56',NULL,'public'),(59743,0,'16','16',2681,'image/jpeg',379750,'posts/16.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59744,0,'2','2',2681,'image/jpeg',51879,'posts/2.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59745,0,'3','3',2681,'image/jpeg',127122,'posts/3.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59746,0,'4','4',2681,'image/jpeg',173868,'posts/4.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59747,0,'6','6',2681,'image/jpeg',224569,'posts/6.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59748,0,'7','7',2681,'image/jpeg',177684,'posts/7.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59749,0,'8','8',2681,'image/jpeg',111710,'posts/8.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59750,0,'9','9',2681,'image/jpeg',143678,'posts/9.jpg','[]','2025-04-29 17:14:57','2025-04-29 17:14:57',NULL,'public'),(59751,0,'1','1',2682,'image/jpeg',9803,'projects/1.jpg','[]','2025-04-29 17:14:58','2025-04-29 17:14:58',NULL,'public'),(59752,0,'11','11',2682,'image/jpeg',9803,'projects/11.jpg','[]','2025-04-29 17:14:58','2025-04-29 17:14:58',NULL,'public'),(59753,0,'12','12',2682,'image/jpeg',9803,'projects/12.jpg','[]','2025-04-29 17:14:58','2025-04-29 17:14:58',NULL,'public'),(59754,0,'13','13',2682,'image/jpeg',9803,'projects/13.jpg','[]','2025-04-29 17:14:58','2025-04-29 17:14:58',NULL,'public'),(59755,0,'14','14',2682,'image/jpeg',9803,'projects/14.jpg','[]','2025-04-29 17:14:58','2025-04-29 17:14:58',NULL,'public'),(59756,0,'2','2',2682,'image/jpeg',9803,'projects/2.jpg','[]','2025-04-29 17:14:58','2025-04-29 17:14:58',NULL,'public'),(59757,0,'21','21',2682,'image/jpeg',9803,'projects/21.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59758,0,'22','22',2682,'image/jpeg',9803,'projects/22.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59759,0,'23','23',2682,'image/jpeg',9803,'projects/23.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59760,0,'24','24',2682,'image/jpeg',9803,'projects/24.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59761,0,'25','25',2682,'image/jpeg',9803,'projects/25.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59762,0,'26','26',2682,'image/jpeg',9803,'projects/26.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59763,0,'3','3',2682,'image/jpeg',9803,'projects/3.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59764,0,'5','5',2682,'image/jpeg',9803,'projects/5.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59765,0,'1-1','1-1',2683,'image/jpeg',9803,'properties/1-1.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59766,0,'1-2','1-2',2683,'image/jpeg',9803,'properties/1-2.jpg','[]','2025-04-29 17:14:59','2025-04-29 17:14:59',NULL,'public'),(59767,0,'1-3','1-3',2683,'image/jpeg',9803,'properties/1-3.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59768,0,'1','1',2683,'image/jpeg',9803,'properties/1.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59769,0,'10-1','10-1',2683,'image/jpeg',9803,'properties/10-1.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59770,0,'10','10',2683,'image/jpeg',9803,'properties/10.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59771,0,'11-1','11-1',2683,'image/jpeg',9803,'properties/11-1.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59772,0,'11','11',2683,'image/jpeg',9803,'properties/11.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59773,0,'12','12',2683,'image/jpeg',9803,'properties/12.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59774,0,'13','13',2683,'image/jpeg',9803,'properties/13.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59775,0,'14','14',2683,'image/jpeg',9803,'properties/14.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59776,0,'15','15',2683,'image/jpeg',9803,'properties/15.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59777,0,'2-1','2-1',2683,'image/jpeg',9803,'properties/2-1.jpg','[]','2025-04-29 17:15:00','2025-04-29 17:15:00',NULL,'public'),(59778,0,'2-2','2-2',2683,'image/jpeg',9803,'properties/2-2.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59779,0,'2-3','2-3',2683,'image/jpeg',9803,'properties/2-3.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59780,0,'2','2',2683,'image/jpeg',9803,'properties/2.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59781,0,'21','21',2683,'image/jpeg',9803,'properties/21.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59782,0,'22-1','22-1',2683,'image/jpeg',9803,'properties/22-1.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59783,0,'22','22',2683,'image/jpeg',9803,'properties/22.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59784,0,'23','23',2683,'image/jpeg',9803,'properties/23.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59785,0,'24-1','24-1',2683,'image/jpeg',9803,'properties/24-1.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59786,0,'24','24',2683,'image/jpeg',9803,'properties/24.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59787,0,'3-1','3-1',2683,'image/jpeg',9803,'properties/3-1.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59788,0,'3-2','3-2',2683,'image/jpeg',9803,'properties/3-2.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59789,0,'3-3','3-3',2683,'image/jpeg',9803,'properties/3-3.jpg','[]','2025-04-29 17:15:01','2025-04-29 17:15:01',NULL,'public'),(59790,0,'3','3',2683,'image/jpeg',9803,'properties/3.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59791,0,'31','31',2683,'image/jpeg',9803,'properties/31.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59792,0,'311','311',2683,'image/jpeg',9803,'properties/311.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59793,0,'32','32',2683,'image/jpeg',9803,'properties/32.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59794,0,'32223-43914-378','32223-43914-378',2683,'image/jpeg',9803,'properties/32223-43914-378.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59795,0,'33','33',2683,'image/jpeg',9803,'properties/33.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59796,0,'34','34',2683,'image/jpeg',9803,'properties/34.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59797,0,'35','35',2683,'image/jpeg',9803,'properties/35.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59798,0,'4-1','4-1',2683,'image/jpeg',9803,'properties/4-1.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59799,0,'4-2','4-2',2683,'image/jpeg',9803,'properties/4-2.jpg','[]','2025-04-29 17:15:02','2025-04-29 17:15:02',NULL,'public'),(59800,0,'4','4',2683,'image/jpeg',9803,'properties/4.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59801,0,'411','411',2683,'image/jpeg',9803,'properties/411.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59802,0,'42','42',2683,'image/jpeg',9803,'properties/42.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59803,0,'421834935dbc9ef3aaa42','421834935dbc9ef3aaa42',2683,'image/jpeg',9803,'properties/421834935dbc9ef3aaa42.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59804,0,'43','43',2683,'image/jpeg',9803,'properties/43.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59805,0,'44','44',2683,'image/jpeg',9803,'properties/44.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59806,0,'5-1','5-1',2683,'image/jpeg',9803,'properties/5-1.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59807,0,'5-2','5-2',2683,'image/jpeg',9803,'properties/5-2.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59808,0,'5','5',2683,'image/jpeg',9803,'properties/5.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59809,0,'6-1','6-1',2683,'image/jpeg',9803,'properties/6-1.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59810,0,'6-2','6-2',2683,'image/jpeg',9803,'properties/6-2.jpg','[]','2025-04-29 17:15:03','2025-04-29 17:15:03',NULL,'public'),(59811,0,'6','6',2683,'image/jpeg',9803,'properties/6.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59812,0,'7-1','7-1',2683,'image/jpeg',9803,'properties/7-1.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59813,0,'7-2','7-2',2683,'image/jpeg',9803,'properties/7-2.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59814,0,'7','7',2683,'image/jpeg',9803,'properties/7.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59815,0,'71','71',2683,'image/jpeg',9803,'properties/71.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59816,0,'72','72',2683,'image/jpeg',9803,'properties/72.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59817,0,'73','73',2683,'image/jpeg',9803,'properties/73.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59818,0,'74','74',2683,'image/jpeg',9803,'properties/74.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59819,0,'75','75',2683,'image/jpeg',9803,'properties/75.jpg','[]','2025-04-29 17:15:04','2025-04-29 17:15:04',NULL,'public'),(59820,0,'78','78',2683,'image/jpeg',9803,'properties/78.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59821,0,'79','79',2683,'image/jpeg',9803,'properties/79.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59822,0,'8-1','8-1',2683,'image/jpeg',9803,'properties/8-1.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59823,0,'8-2','8-2',2683,'image/jpeg',9803,'properties/8-2.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59824,0,'8','8',2683,'image/jpeg',9803,'properties/8.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59825,0,'9-1','9-1',2683,'image/jpeg',9803,'properties/9-1.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59826,0,'9','9',2683,'image/jpeg',9803,'properties/9.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59827,0,'a1-1','a1-1',2683,'image/jpeg',9803,'properties/a1-1.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59828,0,'a1-2','a1-2',2683,'image/jpeg',9803,'properties/a1-2.jpg','[]','2025-04-29 17:15:05','2025-04-29 17:15:05',NULL,'public'),(59829,0,'a1','a1',2683,'image/jpeg',9803,'properties/a1.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59830,0,'a10','a10',2683,'image/jpeg',9803,'properties/a10.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59831,0,'a2-1','a2-1',2683,'image/jpeg',9803,'properties/a2-1.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59832,0,'a2-2','a2-2',2683,'image/jpeg',9803,'properties/a2-2.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59833,0,'a2','a2',2683,'image/jpeg',9803,'properties/a2.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59834,0,'a3-1','a3-1',2683,'image/jpeg',9803,'properties/a3-1.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59835,0,'a3-2','a3-2',2683,'image/jpeg',9803,'properties/a3-2.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59836,0,'a3','a3',2683,'image/jpeg',9803,'properties/a3.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59837,0,'a4-1','a4-1',2683,'image/jpeg',9803,'properties/a4-1.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59838,0,'a4-2','a4-2',2683,'image/jpeg',9803,'properties/a4-2.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59839,0,'a4','a4',2683,'image/jpeg',9803,'properties/a4.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59840,0,'a5-1','a5-1',2683,'image/jpeg',9803,'properties/a5-1.jpg','[]','2025-04-29 17:15:06','2025-04-29 17:15:06',NULL,'public'),(59841,0,'a5','a5',2683,'image/jpeg',9803,'properties/a5.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59842,0,'a6-1','a6-1',2683,'image/jpeg',9803,'properties/a6-1.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59843,0,'a6','a6',2683,'image/jpeg',9803,'properties/a6.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59844,0,'a7','a7',2683,'image/jpeg',9803,'properties/a7.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59845,0,'a8','a8',2683,'image/jpeg',9803,'properties/a8.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59846,0,'a9','a9',2683,'image/jpeg',9803,'properties/a9.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59847,0,'b1','b1',2683,'image/jpeg',9803,'properties/b1.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59848,0,'b2','b2',2683,'image/jpeg',9803,'properties/b2.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59849,0,'b3','b3',2683,'image/jpeg',9803,'properties/b3.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59850,0,'b4-1','b4-1',2683,'image/jpeg',9803,'properties/b4-1.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59851,0,'b4','b4',2683,'image/jpeg',9803,'properties/b4.jpg','[]','2025-04-29 17:15:07','2025-04-29 17:15:07',NULL,'public'),(59852,0,'b5-1','b5-1',2683,'image/jpeg',9803,'properties/b5-1.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59853,0,'b5','b5',2683,'image/jpeg',9803,'properties/b5.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59854,0,'b6','b6',2683,'image/jpeg',9803,'properties/b6.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59855,0,'download','download',2683,'image/jpeg',9803,'properties/download.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59856,0,'e1','e1',2683,'image/jpeg',9803,'properties/e1.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59857,0,'e2','e2',2683,'image/jpeg',9803,'properties/e2.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59858,0,'e3','e3',2683,'image/jpeg',9803,'properties/e3.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59859,0,'e4','e4',2683,'image/jpeg',9803,'properties/e4.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59860,0,'e5','e5',2683,'image/jpeg',9803,'properties/e5.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59861,0,'e7','e7',2683,'image/jpeg',9803,'properties/e7.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59862,0,'e8','e8',2683,'image/jpeg',9803,'properties/e8.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59863,0,'floor','floor',2683,'image/png',9803,'properties/floor.png','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59864,0,'p1','p1',2683,'image/jpeg',9803,'properties/p1.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59865,0,'p2','p2',2683,'image/jpeg',9803,'properties/p2.jpg','[]','2025-04-29 17:15:08','2025-04-29 17:15:08',NULL,'public'),(59866,0,'property-video-thumb','property-video-thumb',2683,'image/jpeg',9803,'properties/property-video-thumb.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59867,0,'q1','q1',2683,'image/jpeg',9803,'properties/q1.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59868,0,'q2','q2',2683,'image/jpeg',9803,'properties/q2.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59869,0,'q3','q3',2683,'image/jpeg',9803,'properties/q3.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59870,0,'q6','q6',2683,'image/jpeg',9803,'properties/q6.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59871,0,'q7','q7',2683,'image/jpeg',9803,'properties/q7.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59872,0,'q8','q8',2683,'image/jpeg',9803,'properties/q8.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59873,0,'t1','t1',2683,'image/jpeg',9803,'properties/t1.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59874,0,'t2','t2',2683,'image/jpeg',9803,'properties/t2.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59875,0,'t3','t3',2683,'image/jpeg',9803,'properties/t3.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59876,0,'t4','t4',2683,'image/jpeg',9803,'properties/t4.jpg','[]','2025-04-29 17:15:09','2025-04-29 17:15:09',NULL,'public'),(59877,0,'t5','t5',2683,'image/jpeg',9803,'properties/t5.jpg','[]','2025-04-29 17:15:10','2025-04-29 17:15:10',NULL,'public'),(59878,0,'wp1a','wp1a',2683,'image/jpeg',9803,'properties/wp1a.jpg','[]','2025-04-29 17:15:10','2025-04-29 17:15:10',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_parent_id_user_id_created_at_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2684 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,1,'Banners',NULL,'banner',0,'2019-11-16 02:00:43','2019-11-16 02:00:50',NULL),(1129,0,'users',NULL,'users',0,'2023-10-25 00:12:49','2023-10-25 00:12:49',NULL),(2675,0,'cities',NULL,'cities',0,'2025-04-29 17:14:43','2025-04-29 17:14:43',NULL),(2676,0,'locations',NULL,'locations',0,'2025-04-29 17:14:44','2025-04-29 17:14:44',NULL),(2677,0,'logo',NULL,'logo',0,'2025-04-29 17:14:44','2025-04-29 17:14:44',NULL),(2678,0,'accounts',NULL,'accounts',0,'2025-04-29 17:14:46','2025-04-29 17:14:46',NULL),(2679,0,'general',NULL,'general',0,'2025-04-29 17:14:52','2025-04-29 17:14:52',NULL),(2680,0,'news',NULL,'news',0,'2025-04-29 17:14:54','2025-04-29 17:14:54',NULL),(2681,0,'posts',NULL,'posts',0,'2025-04-29 17:14:56','2025-04-29 17:14:56',NULL),(2682,0,'projects',NULL,'projects',0,'2025-04-29 17:14:58','2025-04-29 17:14:58',NULL),(2683,0,'properties',NULL,'properties',0,'2025-04-29 17:14:59','2025-04-29 17:14:59',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `media_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned NOT NULL,
  `location` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-04-29 17:14:52','2025-04-29 17:14:52');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int unsigned NOT NULL,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `reference_id` int unsigned DEFAULT '0',
  `reference_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `menu_nodes_related_id_index` (`reference_id`),
  KEY `menu_nodes_index` (`parent_id`,`reference_id`,`reference_type`,`has_child`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,0,NULL,'/projects',NULL,0,'Projects',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(2,1,0,0,NULL,'/properties',NULL,1,'Properties',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(3,1,0,0,NULL,'/agents',NULL,2,'Agents',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(4,1,0,2,'Botble\\Page\\Models\\Page','/news',NULL,3,'News',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(5,1,0,0,NULL,'/careers',NULL,4,'Careers',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(6,1,0,4,'Botble\\Page\\Models\\Page','/contact',NULL,5,'Contact',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(7,2,0,3,'Botble\\Page\\Models\\Page','/about-us',NULL,0,'About us',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(8,2,0,4,'Botble\\Page\\Models\\Page','/contact',NULL,1,'Contact us',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(9,2,0,0,NULL,'/careers',NULL,2,'Careers',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(10,2,0,5,'Botble\\Page\\Models\\Page','/terms-conditions',NULL,3,'Terms & Conditions',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(11,3,0,0,NULL,'/projects',NULL,0,'All projects',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(12,3,0,0,NULL,'/properties',NULL,1,'All properties',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(13,3,0,0,NULL,'/properties?type=sale',NULL,2,'Houses for sale',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(14,3,0,0,NULL,'/properties?type=rent',NULL,3,'Houses for rent',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(15,4,0,2,'Botble\\Page\\Models\\Page','/news',NULL,0,'Latest news',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(16,4,0,2,'Botble\\Blog\\Models\\Category',NULL,NULL,1,'House architecture',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(17,4,0,4,'Botble\\Blog\\Models\\Category',NULL,NULL,2,'House design',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52'),(18,4,0,6,'Botble\\Blog\\Models\\Category',NULL,NULL,3,'Building materials',NULL,'_self',0,'2025-04-29 17:14:52','2025-04-29 17:14:52');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(2,'About','about','published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(3,'More information','more-information','published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(4,'News','news','published','2025-04-29 17:14:52','2025-04-29 17:14:52');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `reference_id` int unsigned NOT NULL,
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `reference_type` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_content_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-17 20:34:59','2019-11-17 20:34:59'),(2,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-17 20:53:34','2019-11-17 20:53:34'),(3,3,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-17 21:09:55','2019-11-17 21:09:55'),(4,4,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-17 21:18:11','2019-11-17 21:18:11'),(5,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\PropertyFeature','2019-11-17 21:40:58','2019-11-17 21:40:58'),(6,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\PropertyFeature','2019-11-17 21:41:43','2019-11-17 21:41:43'),(7,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-18 00:34:49','2019-11-18 00:34:49'),(8,5,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 00:47:52','2019-11-18 00:47:52'),(9,6,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 01:05:58','2019-11-18 01:05:58'),(10,7,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 01:12:07','2019-11-18 01:12:07'),(11,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-18 01:28:45','2019-11-18 01:28:45'),(12,8,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 01:49:36','2019-11-18 01:49:36'),(13,9,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 02:02:19','2019-11-18 02:02:19'),(14,10,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 02:16:53','2019-11-18 02:16:53'),(15,11,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 02:22:48','2019-11-18 02:22:48'),(16,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-18 02:33:35','2019-11-18 02:33:35'),(17,12,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 02:47:05','2019-11-18 02:47:05'),(18,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Post','2019-11-18 02:51:35','2019-11-18 02:51:35'),(19,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Tag','2019-11-18 02:51:35','2019-11-18 02:51:35'),(20,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Post','2019-11-18 02:55:53','2019-11-18 02:55:53'),(21,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Tag','2019-11-18 02:55:53','2019-11-18 02:55:53'),(22,3,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Post','2019-11-18 02:59:01','2019-11-18 02:59:01'),(23,4,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Post','2019-11-18 03:07:27','2019-11-18 03:07:27'),(24,3,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Tag','2019-11-18 03:07:27','2019-11-18 03:07:27'),(25,3,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-18 03:30:34','2019-11-18 03:30:34'),(26,4,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-18 03:38:13','2019-11-18 03:38:13'),(27,5,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-18 03:45:06','2019-11-18 03:45:06'),(28,6,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-18 03:53:20','2019-11-18 03:53:20'),(29,13,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 07:23:02','2019-11-18 07:23:02'),(30,14,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 07:36:29','2019-11-18 07:36:29'),(31,15,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 07:44:44','2019-11-18 07:44:44'),(32,16,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 07:59:14','2019-11-18 07:59:14'),(33,17,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-18 08:13:07','2019-11-18 08:13:07'),(34,7,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-21 01:54:36','2019-11-21 01:54:36'),(35,8,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-21 02:28:09','2019-11-21 02:28:09'),(36,9,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-21 02:40:25','2019-11-21 02:40:25'),(37,10,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-21 02:58:55','2019-11-21 02:58:55'),(38,11,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-21 03:16:25','2019-11-21 03:16:25'),(39,12,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Project','2019-11-21 03:25:22','2019-11-21 03:25:22'),(40,18,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 05:51:54','2019-11-21 05:51:54'),(41,19,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 06:03:11','2019-11-21 06:03:11'),(42,20,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 06:12:15','2019-11-21 06:12:15'),(43,21,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 06:26:59','2019-11-21 06:26:59'),(44,22,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 06:56:50','2019-11-21 06:56:50'),(45,23,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 07:18:36','2019-11-21 07:18:36'),(46,24,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 07:26:48','2019-11-21 07:26:48'),(47,25,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 07:34:38','2019-11-21 07:34:38'),(48,26,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 07:40:46','2019-11-21 07:40:46'),(49,27,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 07:45:34','2019-11-21 07:45:34'),(52,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-21 07:49:25','2019-11-21 07:49:25'),(53,3,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-21 07:49:35','2019-11-21 07:49:35'),(54,4,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-21 07:50:02','2019-11-21 07:50:02'),(55,5,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-21 07:50:17','2019-11-21 07:50:17'),(56,6,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-21 07:50:36','2019-11-21 07:50:36'),(57,7,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-21 07:50:58','2019-11-21 07:50:58'),(58,28,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 19:53:17','2019-11-21 19:53:17'),(59,29,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-21 19:59:16','2019-11-21 19:59:16'),(60,30,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-22 00:29:01','2019-11-22 00:29:01'),(61,31,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-22 00:42:28','2019-11-22 00:42:28'),(62,32,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-22 00:47:18','2019-11-22 00:47:18'),(63,33,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-22 00:57:15','2019-11-22 00:57:15'),(64,34,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\RealEstate\\Models\\Property','2019-11-22 01:06:09','2019-11-22 01:06:09'),(65,8,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Blog\\Models\\Category','2019-11-22 01:26:08','2019-11-22 01:26:08'),(74,1,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Career\\Models\\Career','2019-11-30 19:43:10','2019-11-30 19:43:10'),(75,2,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Career\\Models\\Career','2019-11-30 19:49:07','2019-11-30 19:49:07'),(76,3,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Career\\Models\\Career','2019-11-30 19:52:42','2019-11-30 19:52:42'),(77,4,'seo_meta','[{\"seo_title\":null,\"seo_description\":null}]','Botble\\Career\\Models\\Career','2019-11-30 19:56:50','2019-11-30 19:56:50'),(80,2,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(81,4,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(82,6,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(83,8,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(84,10,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(85,12,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(86,14,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(87,16,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(88,18,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(89,20,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(90,22,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(91,24,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(92,26,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(93,28,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(94,30,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(95,32,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(96,34,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Property','2021-04-29 20:46:36','2021-04-29 20:46:36'),(97,2,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Project','2021-04-29 20:46:36','2021-04-29 20:46:36'),(98,4,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Project','2021-04-29 20:46:36','2021-04-29 20:46:36'),(99,6,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Project','2021-04-29 20:46:36','2021-04-29 20:46:36'),(100,8,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Project','2021-04-29 20:46:36','2021-04-29 20:46:36'),(101,10,'video','[{\"thumbnail\":\"\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Project','2021-04-29 20:46:36','2021-04-29 20:46:36'),(102,12,'video','[{\"thumbnail\":\"properties\\/property-video-thumb.jpg\",\"url\":\"https:\\/\\/www.youtube.com\\/watch?v=UfEiKK-iX70\"}]','Botble\\RealEstate\\Models\\Project','2021-04-29 20:46:36','2021-04-29 20:46:36'),(103,1,'subscribed_packaged_id','[2]','Botble\\Payment\\Models\\Payment','2022-12-27 20:03:55','2022-12-27 20:03:55');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=240 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2013_04_09_032329_create_base_tables',1),(2,'2013_04_09_062329_create_revisions_table',1),(3,'2014_10_12_000000_create_users_table',1),(4,'2014_10_12_100000_create_password_resets_table',1),(5,'2016_06_01_000001_create_oauth_auth_codes_table',1),(6,'2016_06_01_000002_create_oauth_access_tokens_table',1),(7,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),(8,'2016_06_01_000004_create_oauth_clients_table',1),(9,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),(10,'2016_06_10_230148_create_acl_tables',1),(11,'2016_06_14_230857_create_menus_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_05_074239_create_setting_table',1),(14,'2016_11_28_032840_create_dashboard_widget_tables',1),(15,'2016_12_16_084601_create_widgets_table',1),(16,'2017_05_09_070343_create_media_tables',1),(17,'2017_11_03_070450_create_slug_table',1),(18,'2019_07_15_042406_change_site_title_from_settings_to_theme_options',1),(19,'2019_08_13_033145_remove_unused_columns_in_users_table',1),(20,'2019_08_19_000000_create_failed_jobs_table',1),(21,'2019_09_07_030654_update_menu_nodes_table',1),(22,'2019_09_07_045041_update_slugs_table',1),(23,'2019_09_07_050405_update_slug_reference_for_page',1),(24,'2019_09_08_014859_update_meta_boxes_table',1),(25,'2019_09_08_015629_update_meta_box_data_for_page',1),(26,'2019_09_12_073711_update_media_url',1),(27,'2019_09_12_073711_update_media_url_for_current_data',1),(28,'2019_10_20_002256_remove_parent_id_in_pages_table',1),(31,'2018_06_22_032304_create_real_estate_table',2),(32,'2015_06_29_025744_create_audit_history',3),(33,'2015_06_18_033822_create_blog_table',4),(34,'2019_09_07_035526_update_menu_node_reference_type_for_category',4),(35,'2019_09_07_050058_update_slug_reference_for_blog',4),(36,'2019_09_07_155716_update_language_meta_for_blog',4),(37,'2019_09_08_015552_update_meta_box_data_for_blog',4),(38,'2019_10_20_002342_remove_parent_id_in_tags_table',4),(39,'2016_10_03_032336_create_languages_table',5),(40,'2019_09_07_154718_update_lang_meta_table',5),(42,'2016_06_17_091537_create_contacts_table',7),(43,'2015_08_15_122343_create_notes_table',8),(44,'2019_11_18_035125_add_column_type_into_re_properties_table',9),(45,'2019_11_18_035712_create_investor_table',9),(46,'2019_11_18_040153_update_real_estates_table',9),(47,'2019_11_18_041228_drop_table_re_property_categories',10),(48,'2019_11_18_082146_create_currencies_table',11),(49,'2019_11_18_061011_create_country_table',12),(50,'2019_11_18_061730_create_state_table',12),(51,'2019_11_18_062515_create_city_table',12),(52,'2019_11_19_063851_create_project_features_table',13),(53,'2019_11_21_090830_update_project_and_property_table',14),(54,'2019_11_21_130139_add_price_to_projects_table',15),(55,'2019_11_14_210650_create_consults_table',16),(56,'2019_11_26_024326_update_property_type',17),(57,'2019_06_24_211801_create_career_table',18),(58,'2019_12_03_123314_add_column_slug_into_cities_table',19),(59,'2019_12_03_124417_add_column_city_id_into_table_properties_and_projects',19),(60,'2017_05_18_080441_create_payment_tables',20),(61,'2019_12_10_140938_create_vendor_table',20),(62,'2019_12_15_025938_update_column_images_in_real_estate_tables',20),(63,'2019_12_17_064316_add_column_period_to_table_re_properties',20),(64,'2019_12_24_033049_add_column_author_into_re_properties_table',20),(65,'2019_12_24_083810_vendor_create_package_table',20),(66,'2019_12_27_004653_update_vendors_table_with_package_data',20),(68,'2020_01_08_002704_real_estate_create_type_table',21),(69,'2020_01_10_133700_change_re_types_to_re_categories',22),(70,'2016_10_07_193005_create_translations_table',23),(71,'2020_01_23_133752_update_account_tables',24),(72,'2020_02_03_144309_update_column_payment_channel',25),(73,'2020_02_06_143217_update_vendor_table',26),(74,'2020_02_11_133026_add_description_to_table_payments',27),(75,'2020_02_11_140823_create_transactions_table',27),(76,'2020_02_23_111922_fix_column_number_block_in_re_properties_table',27),(77,'2020_03_24_151004_add_moderation_status_into_properties_table',28),(78,'2020_03_25_030953_create_table_vendor_packages',29),(79,'2020_03_25_083610_add_column_expire_date_into_re_properties_table',30),(80,'2020_03_26_081108_add_column_auto_renew_to_re_properties_table',31),(81,'2020_03_16_072752_add_column_abbreviation_to_states_table',32),(82,'2020_03_28_020724_make_column_user_id_nullable_table_revisions',33),(83,'2020_03_23_093053_update_payments_table',34),(84,'2020_04_22_074304_add_column_never_expired_to_re_properties_table',35),(85,'2020_05_26_014304_add_column_provider_to_oauth_clients_table',36),(86,'2020_07_27_085437_add_icon_to_re_features',37),(90,'2020_08_21_102728_real_estate_create_facility_table',38),(91,'2020_08_22_024455_rename_table_for_accounts',39),(92,'2020_08_26_130439_add_column_username_into_table_re_accounts',40),(93,'2020_09_09_110653_update_table_careers',41),(94,'2020_09_15_111419_fix_old_data_for_re_properties',42),(95,'2020_10_05_030817_make_column_charge_id_nullable',43),(96,'2020_10_18_134416_fix_audit_logs_table',44),(97,'2020_10_24_133432_change_column_distance_to_string',45),(99,'2020_10_31_053746_add_column_description_into_re_categories_table',46),(100,'2019_01_05_053554_create_jobs_table',47),(101,'2020_12_05_112556_change_contact_page_to_a_page',48),(102,'2021_02_11_031126_update_price_column_in_projects_and_properties',49),(103,'2021_02_16_092633_remove_default_value_for_author_type',50),(104,'2021_03_08_024049_add_lat_long_into_real_estate_tables',51),(105,'2021_03_27_144913_add_customer_type_into_table_payments',52),(106,'2021_05_24_034720_make_column_currency_nullable',53),(107,'2021_06_10_091950_add_column_is_featured_to_table_re_accounts',54),(108,'2021_07_07_021757_update_table_account_activity_logs',55),(109,'2021_07_18_101839_fix_old_theme_options',56),(110,'2021_08_05_134214_fix_social_link_theme_options',57),(111,'2021_08_09_161302_add_metadata_column_to_payments_table',58),(112,'2021_09_29_042758_create_re_categories_multilevel_table',59),(113,'2021_10_19_020859_update_metadata_field',60),(114,'2021_10_31_031254_add_company_to_accounts_table',61),(115,'2021_10_25_021023_fix-priority-load-for-language-advanced',62),(116,'2021_12_03_030600_create_blog_translations',62),(117,'2021_12_03_075608_create_page_translations',62),(118,'2021_12_03_084118_create_location_translations',62),(119,'2021_12_03_094518_migrate_old_location_data',62),(120,'2021_12_04_095357_create_careers_translations_table',62),(121,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',63),(122,'2021_12_10_034807_create_real_estate_translation_tables',64),(123,'2021_12_18_081636_add_property_project_views_count',65),(124,'2022_01_16_085908_improve_plugin_location',66),(125,'2022_04_19_113923_add_index_to_table_posts',67),(126,'2022_04_20_100851_add_index_to_media_table',67),(127,'2022_04_20_101046_add_index_to_menu_table',67),(128,'2022_05_03_033044_update_column_images_in_real_estate_tables',68),(129,'2022_05_04_033044_update_column_images_in_real_estate_tables',69),(130,'2022_06_04_033634_improve_homepage_content',70),(131,'2022_06_28_151901_activate_paypal_stripe_plugin',71),(132,'2022_07_02_081723_fix_expired_date_column',71),(133,'2019_12_14_000001_create_personal_access_tokens_table',72),(134,'2022_07_07_153354_update_charge_id_in_table_payments',72),(135,'2022_07_10_034813_move_lang_folder_to_root',72),(136,'2022_08_01_090213_update_table_properties_and_projects',72),(137,'2022_08_04_051940_add_missing_column_expires_at',72),(138,'2022_08_04_052122_delete_location_backup_tables',72),(139,'2022_10_14_024629_drop_column_is_featured',73),(140,'2022_10_29_065232_increase_states_abbreviation_column',74),(141,'2022_11_06_061847_increase_state_translations_abbreviation_column',75),(142,'2022_11_06_070405_improve_homepage_search_box',75),(143,'2022_11_18_063357_add_missing_timestamp_in_table_settings',76),(144,'2022_12_02_093615_update_slug_index_columns',76),(145,'2022_09_01_000001_create_admin_notifications_tables',77),(146,'2023_01_30_024431_add_alt_to_media_table',78),(147,'2023_01_31_023233_create_re_custom_fields_table',79),(148,'2023_02_06_000000_add_location_to_re_accounts_table',79),(149,'2023_02_06_024257_add_package_translations',79),(150,'2023_02_08_062457_add_custom_fields_translation_table',80),(151,'2014_10_12_100000_create_password_reset_tokens_table',81),(152,'2023_02_15_024644_create_re_reviews_table',81),(153,'2023_02_16_042611_drop_table_password_resets',81),(154,'2023_02_20_072604_create_re_invoices_table',82),(155,'2023_02_20_081251_create_re_account_packages_table',82),(156,'2023_04_04_030709_add_unique_id_to_properties_and_projects_table',83),(157,'2023_04_14_164811_make_phone_and_email_in_table_re_consults_nullable',84),(158,'2023_04_23_005903_add_column_permissions_to_admin_notifications',84),(159,'2023_04_23_061847_increase_state_translations_abbreviation_column',84),(160,'2023_05_08_114004_improve_properties_and_projects_page',85),(161,'2023_05_09_062031_unique_reviews_table',85),(162,'2023_05_10_075124_drop_column_id_in_role_users_table',85),(163,'2023_05_26_034353_fix_properties_projects_image',86),(164,'2023_05_27_004215_add_column_ip_into_table_re_consults',86),(165,'2023_07_06_011444_create_slug_translations_table',87),(166,'2023_07_18_040500_convert_cities_is_featured_to_selecting_locations_from_shortcode',87),(167,'2023_07_25_034513_create_re_coupons_table',87),(168,'2023_07_25_034672_add_coupon_code_column_to_jb_invoices_table',87),(169,'2023_07_26_041451_add_more_columns_to_location_table',87),(170,'2023_07_27_041451_add_more_columns_to_location_translation_table',87),(171,'2023_07_28_073307_drop_unique_in_states_cities_translations',87),(172,'2023_08_02_074208_change_square_column_to_float',87),(173,'2023_08_07_000001_add_is_public_profile_column_to_re_accounts_table',87),(174,'2023_08_09_004607_make_column_project_id_nullable',87),(175,'2023_08_15_073307_drop_unique_in_states_cities_translations',88),(176,'2023_08_21_090810_make_page_content_nullable',89),(177,'2023_08_29_074620_make_column_author_id_nullable',90),(178,'2023_09_11_084630_update_mandatory_fields_in_consult_form_table',91),(179,'2023_09_14_021936_update_index_for_slugs_table',92),(180,'2023_09_14_022423_add_index_for_language_table',92),(181,'2023_09_20_050420_add_missing_translation_column',93),(182,'2023_10_21_065016_make_state_id_in_table_cities_nullable',94),(183,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',95),(184,'2023_11_14_033417_change_request_column_in_table_audit_histories',95),(185,'2023_11_21_071820_add_missing_slug_for_agents',95),(186,'2023_12_06_100448_change_random_hash_for_media',95),(187,'2023_12_07_095130_add_color_column_to_media_folders_table',95),(188,'2023_12_12_105220_drop_translations_table',95),(189,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',95),(190,'2024_01_11_084816_add_investor_translations_table',95),(191,'2024_01_31_022842_add_description_to_re_packages_table',96),(192,'2024_03_13_000001_drop_type_column_from_custom_field_translations_table',96),(193,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',96),(194,'2024_03_25_000001_update_captcha_settings_for_contact',96),(195,'2024_04_04_110758_update_value_column_in_user_meta_table',96),(196,'2024_04_19_063914_create_custom_fields_table',96),(197,'2024_04_23_124505_add_features_column_to_re_packages',96),(198,'2024_04_23_135106_add_columns_to_re_investors',96),(199,'2024_04_27_100730_improve_analytics_setting',96),(200,'2024_05_12_091229_add_column_visibility_to_table_media_files',96),(201,'2024_05_16_100000_change_random_hash_for_media',97),(202,'2024_05_25_000001_update_captcha_settings_for_real_estate',98),(203,'2024_06_16_163428_make_investor_id_nullable',99),(204,'2017_10_24_154832_create_newsletter_table',100),(205,'2020_11_18_150916_ads_create_ads_table',100),(206,'2021_12_02_035301_add_ads_translations_table',100),(207,'2023_04_17_062645_add_open_in_new_tab',100),(208,'2023_08_11_060908_create_announcements_table',100),(209,'2023_11_07_023805_add_tablet_mobile_image',100),(210,'2024_03_25_000001_update_captcha_settings_for_newsletter',100),(211,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',100),(212,'2024_06_20_103539_create_consult_custom_fields_table',100),(213,'2024_07_04_083133_create_payment_logs_table',100),(214,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',100),(215,'2024_07_08_235824_fix_facilities_primary_key',100),(216,'2024_07_12_100000_change_random_hash_for_media',101),(217,'2024_07_26_090340_add_private_notes_column_to_re_properties_projects_table',102),(218,'2024_07_30_091615_fix_order_column_in_categories_table',102),(219,'2024_08_09_075542_add_accounts_translations',103),(220,'2024_08_12_124528_add_approved_at_column_to_re_accounts_table',104),(221,'2024_08_17_094600_add_image_into_countries',105),(222,'0001_01_01_000001_create_cache_table',106),(223,'2024_08_31_074158_add_floor_plans_columns_to_re_properties_table',106),(224,'2024_09_04_130921_add_reject_reason_column_to_re_properties_table',106),(225,'2024_09_19_021436_make_email_in_accounts_table_nullable',106),(226,'2024_09_30_024515_create_sessions_table',106),(227,'2024_11_18_023706_add_floor_plan_to_table_re_properties_translations',106),(228,'2024_12_31_081648_correct_career_slugs',107),(229,'2025_01_06_033807_add_default_value_for_categories_author_type',108),(230,'2025_01_08_093652_add_zip_code_to_cities',108),(231,'2025_02_11_153025_add_action_label_to_announcement_translations',109),(232,'2025_04_03_000001_add_user_type_to_audit_histories_table',110),(233,'2025_04_08_040931_create_social_logins_table',110),(234,'2025_04_12_000003_add_payment_fee_to_payments_table',110),(235,'2025_04_12_161730_add_featured_priority_to_re_properties_table',110),(236,'2025_04_12_165120_add_featured_priority_to_re_projects_table',110),(237,'2025_04_21_000000_add_tablet_mobile_image_to_ads_translations_table',111),(238,'2025_04_23_034738_make_featured_priority_nullable',112),(239,'2025_05_22_000001_add_payment_fee_type_to_settings_table',113);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `reference_id` int unsigned NOT NULL,
  `reference_type` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int unsigned NOT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_access_tokens`
--

DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint DEFAULT NULL,
  `client_id` int unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `scopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_access_tokens`
--

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_auth_codes`
--

DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint NOT NULL,
  `client_id` int unsigned NOT NULL,
  `scopes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_auth_codes`
--

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_clients`
--

DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `secret` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `redirect` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `provider` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_clients`
--

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_personal_access_clients`
--

DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_personal_access_clients`
--

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `oauth_refresh_tokens`
--

DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access_token_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `oauth_refresh_tokens`
--

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int NOT NULL,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Home','<div>[search-box title=\"Find your favorite homes at Flex Home\" background_image=\"general/home-banner.jpg\" enable_search_projects_on_homepage_search=\"yes\" default_home_search_type=\"project\"][/search-box]</div><div>[featured-projects title=\"Featured projects\" subtitle=\"We make the best choices with the hottest and most prestigious projects, please visit the details below to find out more.\" limit=\"4\"][/featured-projects]</div><div>[properties-by-locations title=\"Properties by locations\" subtitle=\"Each place is a good choice, it will help you make the right decision, do not miss the opportunity to discover our wonderful properties.\" city=\"1,2,3,4,5\"][/properties-by-locations]</div><div>[properties-for-sale title=\"Properties For Sale\" subtitle=\"Below is a list of properties that are currently up for sale\" limit=\"8\"][/properties-for-sale]</div><div>[properties-for-rent title=\"Properties For Rent\" subtitle=\"Below is a detailed price list of each property for rent\" limit=\"8\"][/properties-for-rent]</div><div>[featured-agents title=\"Featured Agents\"][/featured-agents]</div><div>[recently-viewed-properties title=\"Recently Viewed Properties\" subtitle=\"Your currently viewed properties.\" limit=\"8\"][/recently-viewed-properties]</div><div>[latest-news title=\"News\" subtitle=\"Below is the latest real estate news we get regularly updated from reliable sources.\" limit=\"4\"][/latest-news]</div>',1,NULL,'homepage',NULL,'published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(2,'News','---',1,NULL,'default',NULL,'published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(3,'About us','<h4><span style=\"font-size:18px;\"><b>1. COMPANY</b><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong> PROFILE</strong></span></span></h4>\n\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">Founded on August 28, 1993 (formerly known as Truong Thinh Phat Construction Co., Ltd.), Flex Home operates in the field of real estate business, building villas for rent.<br />\nWith the slogan &quot;Breaking time, through space&quot; with a sustainable development strategy, taking Real Estate as a focus area, Flex Home is constantly connecting between buyers and sellers in the field. Real estate, bringing people closer together, over the distance of time and space, is a reliable place for real estate investment - an area that is constantly evolving over time.</span></span></p>\n\n<blockquote>\n<h2 style=\"font-style: italic; text-align: center;\"><span style=\"font-size:24px;\"><strong><span style=\"font-family:Arial,Helvetica,sans-serif;\"><span style=\"color:#16a085;\">&quot;Breaking time, through space&quot;</span></span></strong></span></h2>\n</blockquote>\n\n<h4 style=\"text-align: center;\"><img alt=\"\" src=\"https://flex-home.test/storage/general/asset-3-at-3x.png\" style=\"width: 90%;\" /></h4>\n\n<h4><span style=\"font-size:18px;\"><b><font face=\"Arial, Helvetica, sans-serif\">2. VISION&nbsp;</font></b></span></h4>\n\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Acquiring domestic areas.<br />\n- Reaching far across continents.</span></span></p>\n\n<h4><span style=\"font-size:18px;\"><b>3. MISSION</b></span></h4>\n\n<p><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">- Creating the community<br />\n- Building destinations<br />\n- Nurture happiness</span></span></p>\n\n<p><img alt=\"\" src=\"https://flex-home.test/storage/general/vietnam-office-4.jpg\" /></p>\n',1,NULL,'default','Founded on August 28, 1993 (formerly known as Truong Thinh Phat Construction Co., Ltd.), Flex Home operates in the field of real estate business, building villas for rent.\nWith the slogan \"Breaking time, through space\" with a sustainable development strategy, taking Real Estate as a focus area, Flex Home is constantly connecting between buyers and sellers in the field.','published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(4,'Contact','<p>[contact-form][/contact-form]<br />\n&nbsp;</p>\n\n<h3>Directions</h3>\n\n<p>[google-map]North Link Building, 10 Admiralty Street, 757695 Singapore[/google-map]</p>\n\n<p>&nbsp;</p>',1,NULL,'default',NULL,'published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(5,'Terms &amp; Conditions','<p style=\"text-align: justify;\"><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">Access to and use of the Flex Home website is subject to the following terms, conditions, and relevant laws of Vietnam.</span></span></p>\n\n<h4 style=\"text-align: justify;\"><span style=\"font-size:18px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>1. Copyright</strong></span></span></h4>\n\n<p style=\"text-align: justify;\"><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">Copyrights and other intellectual property rights to all text, images, audio, software and other content on this site are owned by Flex Home and its affiliates. Users are allowed to view the contents of the website, cite the contents by printing, downloading the hard disk and distributing it to others for non-commercial purposes, providing information or personal purposes. </span></span><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">Any content from this site may not be used for sale or distribution for profit, nor may it be edited or included in any other publication or website.</span></span></p>\n\n<h4 style=\"text-align: justify;\"><span style=\"font-size:18px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>2. Content</strong></span></span></h4>\n\n<p style=\"text-align: justify;\"><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">The information on this website is compiled with great confidence but for general information research purposes only. While we endeavor to maintain updated and accurate information, we make no representations or warranties in any manner regarding completeness, accuracy, reliability, appropriateness or availability in relation to web site, or related information, product, service, or image within the website for any purpose. </span></span></p>\n\n<p style=\"text-align: justify;\"><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">Flex Home and its employees, managers, and agents are not responsible for any loss, damage or expense incurred as a result of accessing and using this website and the sites. </span></span><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">The web is connected to it, including but not limited to, loss of profits, direct or indirect losses. We are also not responsible, or jointly responsible, if the site is temporarily inaccessible due to technical issues beyond our control. Any comments, suggestions, images, ideas and other information or materials that users submit to us through this site will become our exclusive property, including the right to may arise in the future associated with us.</span></span></p>\n\n<p style=\"text-align: center;\"><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><img alt=\"\" src=\"https://flex-home.test/storage/general/copyright.jpg\" style=\"width: 90%;\" /></span></span></p>\n\n<h4 style=\"text-align: justify;\"><span style=\"font-size:18px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\"><strong>3. Note on&nbsp;connected sites</strong></span></span></h4>\n\n<p style=\"text-align: justify;\"><span style=\"font-size:16px;\"><span style=\"font-family:Arial,Helvetica,sans-serif;\">At many points in the website, users can get links to other websites related to a specific aspect. This does not mean that we are related to the websites or companies that own these websites. Although we intend to connect users to sites of interest, we are not responsible or jointly responsible for our employees, managers, or representatives. with other websites and information contained therein.</span></span></p>\n',1,NULL,'default','Copyrights and other intellectual property rights to all text, images, audio, software and other content on this site are owned by Flex Home and its affiliates. Users are allowed to view the contents of the website, cite the contents by printing, downloading the hard disk and distributing it to others for non-commercial purposes.','published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(6,'Cookie Policy','<h3>EU Cookie Consent</h3><p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p><h4>Essential Data</h4><p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p><p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p><p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>',1,NULL,'default',NULL,'published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(7,'Properties','<div>[properties-list title=\"Discover our properties\" description=\"Discover our properties\" description=\"Each place is a good choice, it will help you make the right decision, do not miss the opportunity to discover our wonderful properties.\" number_of_properties_per_page=\"12\"][/properties-list]</div>',1,NULL,'homepage',NULL,'published','2025-04-29 17:14:52','2025-04-29 17:14:52'),(8,'Projects','<div>[projects-list  title=\"Discover our projects\" description=\"We make the best choices with the hottest and most prestigious projects, please visit the details below to find out more\" number_of_projects_per_page=\"12\"][/projects-list]</div>',1,NULL,'homepage',NULL,'published','2025-04-29 17:14:52','2025-04-29 17:14:52');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `response` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `currency` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order_id` int unsigned DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` int unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,250.00,0.00,'USD',0,'AS2MND60W6','bank_transfer','2022-12-27 20:03:55','2022-12-27 20:03:55',NULL,2,'pending','confirm',1,NULL,NULL,'Botble\\RealEstate\\Models\\Account',NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int unsigned NOT NULL,
  `post_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (1,1,5609),(2,4,5609),(3,1,5610),(4,3,5610),(5,2,5611),(6,3,5611),(7,1,5612),(8,2,5612),(9,1,5613),(10,4,5613),(11,2,5614),(12,4,5614),(13,1,5615),(14,4,5615),(15,1,5616),(16,3,5616),(17,3,5617),(18,4,5617),(19,2,5618),(20,3,5618),(21,1,5619),(22,4,5619),(23,3,5620),(24,4,5620),(25,2,5621),(26,3,5621),(27,2,5622),(28,3,5622),(29,1,5623),(30,2,5623),(31,3,5624),(32,4,5624);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int unsigned NOT NULL,
  `post_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (1,1,5609),(2,2,5609),(3,3,5609),(4,1,5610),(5,2,5610),(6,3,5610),(7,1,5611),(8,2,5611),(9,3,5611),(10,1,5612),(11,2,5612),(12,3,5612),(13,1,5613),(14,2,5613),(15,3,5613),(16,1,5614),(17,2,5614),(18,3,5614),(19,1,5615),(20,2,5615),(21,3,5615),(22,1,5616),(23,2,5616),(24,3,5616),(25,1,5617),(26,2,5617),(27,3,5617),(28,1,5618),(29,2,5618),(30,3,5618),(31,1,5619),(32,2,5619),(33,3,5619),(34,1,5620),(35,2,5620),(36,3,5620),(37,1,5621),(38,2,5621),(39,3,5621),(40,1,5622),(41,2,5622),(42,3,5622),(43,1,5623),(44,2,5623),(45,3,5623),(46,1,5624),(47,2,5624),(48,3,5624);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_author_id_author_type_created_at_index` (`status`,`author_id`,`author_type`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=5625 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'BCG sets great store by real estate negotiations','BCG leaders shared with investors at a meeting this month that real estate and renewable energy will be the two main activities of the group. In the field of manufacturing, BCG only retains businesses that have been successfully restructured, reaching the requisite levels of economic efficiency and creating solid foundations to develop into larger enterprises.','<h2 style=\"font-style:italic;\">The profit of Bamboo Capital Group (BCG) is expected to grow tremendously during 2019-2023 thanks to a series of real estate as well as renewable energy projects, especially Radisson Blu Hoi An and King Crown Village Thao Dien.</h2>\r\n\r\n<p>BCG leaders shared with investors at a meeting this month that real estate and renewable energy will be the two main activities of the group. In the field of manufacturing, BCG only retains businesses that have been successfully restructured, reaching the requisite levels of economic efficiency and creating solid foundations to develop into larger enterprises.</p>\r\n\r\n<p>BCG expects to reach the after-tax profit of VND312 billion ($13.56 million) this year, VND681.5 ($29.6 million) in 2020, and VND826.5 billion ($35.93 million) in 2023. In real estate, BCG has implemented the Radisson Blu Hoi An project with the scale of 734 apartments and coastal villas, King Crown Village Thao Dien in District 2, Ho Chi Minh City with 17 villas in the first phase and serviced apartments and a hotel, as well as offices for lease in the second phase.</p>\r\n\r\n<p>BCG leaders shared that in 2019-2020, Radisson Blu Hoi An and King Crown Village Thao Dien will bring VND900 billion ($39.13 million) in profit to BCG, and the group is negotiating to transfer part of the group&rsquo;s capital in the two projects. BCG owns a hundred per cent in Radisson Blu Hoi An, and 48.5 per cent in King Crown Village Thao Dien.</p>\r\n\r\n<p>&quot;If we close the deals with our partners soon, BCG will fulfil the profit plan for 2019. Currently, the deal is still in progress, but we are confident in implementing our 2019 profit plan. If the deal is delayed for any reason, the profit will be transferred by the beginning of 2020,&quot; Pham Minh Tuan, deputy CEO of BCG, shared.</p>\r\n\r\n<p>The upcoming real estate projects of BCG include Condotel Pegas Nha Trang (2.74 hectares, implemented in 2020-2021), Bao Loc urban area (​​17ha, in 2019-2023), Loc Phat residential area (Bao Loc, Lam Dong &ndash; 46.9ha, implemented from 2019 to 2022), Hoa Ninh residential area (Di Linh, Lam Dong &ndash;49.3ha, implemented in 2020-2023), Hiep Binh Chanh urban area (​​6.3ha, implemented in 2020-2022).</p>\r\n\r\n<p>Regarding the capital to meet BCG&#39;s investment needs, according to Nguyen Ho Nam, chairman of BCG, most of BCG&#39;s projects are co-operating with international corporations on issues like technical and technological issues, branding, or capital co-operation.</p>\r\n\r\n<p>BCG has signed a contract with KPMG Singapore to become the exclusive consultant for BCG to seek international funding and domestic banks to increase credit room for BCG to implement a new project. Along with that, BCG received capital contributions from South Korean investors including Hanwha Energy involved in solar power plant projects and real estate firm Woomi.</p>\r\n\r\n<p>BCG is also working with a strategic partner from Europe. In the field of renewable energy, BCG finished two solar energy projects in Long An with the total capacity of over 140MW. Of these, the BCG-CME Long An 1 solar power plant, which in BCG holds 37.5 per cent, has the capacity of 40.5MW and is expected to bring revenue of VND140-150 billion ($6.1-6.5 million) per year from 2020.</p>\r\n\r\n<p>BCG-CME Long An 2 (GAIA) has the capacity of 100.5MW and is expected to launch operations in this November, bringing revenue of about VND320 billion per year from 2020. BCG has a 32.5 per cent stake in GAIA.</p>\r\n\r\n<p>BCG-CME Long An 1 solar power plant sells electricity to Electricity of Vietnam at the price of 9.35 US cent per kW for 20 years, while GAIA hopes to sell electricity at 8.72 US cent per kW. In addition to the two projects above, BCG is trying to complete procedures for other solar power plants in Long An (100MW), Dak Lak (50MW), Gia Lai (300MW), Tay Ninh (165MW), a surface solar power plant in Quang Nam (200MW), a wind power plant in Soc Trang (50MW).</p>\r\n\r\n<p>At the two solar power plants in Long An, BCG worked with Vietnam-Oman Investment (VOI) and took up VND2 trillion in loans from local banks ($86.96 million &ndash; 65 per cent of the total investment capital of the two projects).</p>','published',1,'Botble\\ACL\\Models\\User',1,'properties/1-2.jpg',1686,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(2,'Private Home Sales Drop 27% In October','New private home sales in Singapore fell 27% in October from September, reported Channel News Asia, based on the data released by the Urban Redevelopment Authority (URA).\r\nAccording to URA data, developers only sold 928 units in October (955 units including executive condominiums), compared to 1,270 units from the previous month','<p>New private home sales in Singapore fell 27% in October from September, reported Channel News Asia, based on the data released by the&nbsp;Urban Redevelopment Authority (URA).</p>\r\n\r\n<p><strong>According to URA data,&nbsp;developers only sold 928 units in October (955 units including executive condominiums), compared to 1,270 units from the previous month.</strong></p>\r\n\r\n<p>However, on a year-to-year comparison, the figures show an 84.9% increase.</p>\r\n\r\n<p>The new homes sold in October in the Core Central Region (CCR) tripled to 182 units from September, the biggest recorded since March 2016, with Singaporeans buying 133 of those units.</p>\r\n\r\n<p>Analysts said the good performance was mainly due to new project launches in the area, including&nbsp;<strong>Midtown<a href=\"https://www.propertyguru.com.sg/property-for-sale/at-midtown-bay-23760\"> </a>Bay Residences</strong>,&nbsp;<strong>Neu at Novena</strong>&nbsp;and&nbsp;<strong>Royalgreen</strong>. The other new launch this month was Midwood, within the Outside of Central Region (OCR)</p>\r\n\r\n<p>The deficiency in major launches in the city fringe and mass-market segments like the OCR could have been a factor in the sales drop, said OrangeTee and Tie head of research and consultancy Christine Sun.</p>\r\n\r\n<p>&ldquo;Sales volumes tend to be lower when more luxury projects are being launched in a particular month, owing to the higher price tags and lower affordability,&rdquo; she said.</p>\r\n\r\n<p>URA Realis data show that this year saw 104 non-landed new homes sales reach S$5 million and above, which is the highest mark since 155 were purchased from January to October 2011, added Sun.</p>\r\n\r\n<p>High-profile transactions, such as James Dyson&rsquo;s purchase of Singapore&rsquo;s most expensive apartment, contributed to &ldquo;significant positive sentiments for developer sales,&rdquo; said property analyst Ong Kah Seng.</p>\r\n\r\n<p>&ldquo;Despite the global trade and geopolitical uncertainties, we believe demand for Singapore private homes is still relatively stable given the tight labour market, favourable interest rate environment, and relatively healthy household balance sheet,&rdquo; said Tricia Song, Colliers International head of research for Singapore.</p>\r\n\r\n<p>Ong believes the country&rsquo;s properties will become more attractive for foreign buyers wanting stable investments.</p>\r\n\r\n<p>&ldquo;There&rsquo;s increasing international attractiveness of Singapore residential properties as offering longer term stability to all profiles of buyers, including from foreigners who are eschewing investments in Hong Kong due to that city&rsquo;s heightening social turbulence,&rdquo; he noted.</p>','published',1,'Botble\\ACL\\Models\\User',1,'properties/2-2.jpg',580,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(3,'Singapore Overtakes Hong Kong In Terms Of Property Investment Prospects','Singapore now claims the top spot for real estate investment prospects in terms of price increases in 2020. Hong Kong, rocked by months of violent political protests, has fallen from 14th place to the bottom of the pile in 2019.','<p>The fortunes of Singapore and Hong Kong &ndash; two of Asia&rsquo;s hottest property markets &ndash; are going in different directions, reported Bloomberg citing a Urban Land Institute and PricewaterhouseCoopers LLP report.</p>\r\n\r\n<p><strong>Singapore now claims the top spot for real estate investment prospects&nbsp;in terms of price increases in 2020. Hong Kong, rocked by months of violent political protests, has fallen from 14th place to the bottom of the pile in 2019.</strong></p>\r\n\r\n<p>Hong Kong&rsquo;s drop to the least-favoured destination for real estate investment next year is due to its retail and tourism sectors taking a beating, affecting economic growth.</p>\r\n\r\n<p>The city-state has benefited from a surge in interest among investors who are steering clear of Hong Kong and China, which are viewed as &ldquo;geopolitical flashpoints&rdquo;.</p>\r\n\r\n<p>For the past few quarters, apartment prices in Singapore have rebounded, showing resilience in the residential market, with the office sector mostly absorbing the oversupply.</p>\r\n\r\n<p>Hong Kong&rsquo;s problems bode well for Singapore, at least for a little while, according to Urban Land Institute CEO Ed Walter.</p>\r\n\r\n<p>&ldquo;A lot of theory in investing is less about what was, versus what is or what is going to be,&rdquo; he added.</p>\r\n\r\n<p><strong>Singapore also saw a rise in property transactions in the first half, with majority of the activities driven by cross-border capital. Deals amounted to $4.9 billion (S$6.6 billion) in the period, a 73% year-on-year growth.</strong></p>\r\n\r\n<p>Walter described Hong Kong as having a &ldquo;very resilient market&rdquo;, backed by its high property prices. He believes that after the protests, sectors such as retail can recover quickly.</p>\r\n\r\n<p>&ldquo;The bigger issue is what happens from a political perspective and what does that signal about Hong Kong&rsquo;s place as a financial centre,&rdquo; he said.</p>\r\n\r\n<p><strong>Singapore placed second-to-last among 22 centres as recently as 2017, overtaken by cities such as Sydney, Tokyo and Bangalore as vacancies rose and rents dropped. In 2017, Hong Kong placed 18th.</strong></p>\r\n\r\n<p><img alt=\"\" src=\"https://flex-home.botble.com/storage/properties/3-2.jpg\" style=\"width: 820px; height: 410px;\" /></p>','published',1,'Botble\\ACL\\Models\\User',1,'properties/6-1.jpg',181,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(4,'S. Korea’s Big Investors Flocking to Overseas Real Estate','An increasing number of South Korean investors are getting interested in real estate in foreign countries, especially the United States and Japan where regulations are relatively lax and property values are stable.','<h2>KEB Hana Bank held a seminar on the global real estate investment strategy at its head office in Seoul on May 23 and nearly 100 customers attended it.</h2>\r\n\r\n<p>Hana Bank&rsquo;s private banker (PB) business division held the seminar for affluent customers to explain the procedure for taking out loans and remitting money to make an investment in real estate in major cities around the world, including New York, Los Angeles in the United States and Tokyo in Japan.</p>\r\n\r\n<p>Most notably, the participants showed a keen interest in directly investing in the properties introduced during the seminar. Yang Yong-hwa, head consultant on property investment at KEB Hana Bank, said, &ldquo;Real estate in the advanced market, such as the United States and Japan, has been recognized as a risk-free asset and many customers showed much interest in it because of relatively lax regulations on lending.&rdquo;</p>\r\n\r\n<h3 style=\"text-align: center;\"><img alt=\"S. Korea’s Big Investors Flocking to Overseas Real Estate\" longdesc=\"S. Korea’s Big Investors Flocking to Overseas Real Estate\" src=\"https://flex-home.botble.com/storage/properties/32223-43914-378.jpg\" style=\"width: 573px; height: 533px;\" /></h3>\r\n\r\n<p style=\"text-align: center;\"><em>S. Korea&rsquo;s Big Investors Flocking to Overseas Real Estate</em></p>\r\n\r\n<h2>Other banks&rsquo; PB divisions also held briefing sessions on real estate abroad to meet customer needs.</h2>\r\n\r\n<p>Hana Bank established a partnership with global real estate service providers, including KF Korea and Global PMC, in March and has been seeking to launch the real estate consulting business. KB Kookmin Bank also introduced the global KB real estate consulting service in 2014, while Woori Bank is holding consultation sessions on investment in foreign properties by making use of its global network which is the largest among domestic banks. Shinhan Bank established a partnership with global real estate service firm, KF Korea, in April and will hold the first seminar on overseas real estate on May 27.</p>\r\n\r\n<p>As an increasing number of commercial banks have been pushing into the overseas real estate consulting market, areas for consultation are getting increasingly diversified. Tokyo has the highest demand as it is relatively easy to access and the price of real estate there is on the rise before the 2020 Summer Olympics. However, emerging countries that have a high growth potential, such as Vietnam, recently see more investment coming in.</p>','published',1,'Botble\\ACL\\Models\\User',1,'properties/download.jpg',1976,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5609,'The Top 2020 Handbag Trends to Know','Non dolor amet non aut tempora dolore. Omnis ab nihil cupiditate et. Non vel itaque eos labore maxime reiciendis.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>Nile On every golden scale! \'How cheerfully he seems to suit them!\' \'I haven\'t opened it yet,\' said the Cat, and vanished. Alice was more hopeless than ever: she sat down and cried. \'Come, there\'s no name signed at the stick, and made another snatch in the distance. \'And yet what a wonderful dream it had made. \'He took me for asking! No, it\'ll never do to ask: perhaps I shall have to beat them off, and found that, as nearly as large as himself, and this was the cat.) \'I hope they\'ll remember her saucer of milk at tea-time. Dinah my dear! I shall only look up in a ring, and begged the Mouse was bristling all over, and she went on without attending to her, one on each side to guard him; and near the house if it began ordering people about like mad things all this grand procession, came THE KING AND QUEEN OF HEARTS. Alice was beginning to end,\' said the Mock Turtle said: \'I\'m too stiff. And the Gryphon interrupted in a sulky tone; \'Seven jogged my elbow.\' On which Seven looked up and.</p><p class=\"text-center\"><img src=\"/storage/news/2.jpg\"></p><p>King; \'and don\'t look at all a pity. I said \"What for?\"\' \'She boxed the Queen\'s ears--\' the Rabbit in a deep sigh, \'I was a large fan in the same thing,\' said the Caterpillar. Alice folded her hands, and she sat down again into its face was quite a new idea to Alice, and tried to look over their shoulders, that all the jurymen on to the porpoise, \"Keep back, please: we don\'t want to stay with it as you are; secondly, because they\'re making such a thing I ask! It\'s always six o\'clock now.\' A.</p><p class=\"text-center\"><img src=\"/storage/news/10.jpg\"></p><p>So Bill\'s got to do,\' said Alice to find that she did not get dry again: they had to ask them what the next witness!\' said the Dormouse again, so she went on so long that they were mine before. If I or she fell past it. \'Well!\' thought Alice to herself, \'it would have made a memorandum of the table. \'Have some wine,\' the March Hare. Alice was only the pepper that had fallen into it: there were TWO little shrieks, and more puzzled, but she saw them, they set to work very carefully, remarking, \'I really must be growing small again.\' She got up this morning, but I THINK I can do no more, whatever happens. What WILL become of you? I gave her answer. \'They\'re done with a smile. There was no longer to be Number One,\' said Alice. \'I mean what I used to say than his first speech. \'You should learn not to lie down on the breeze that followed them, the melancholy words:-- \'Soo--oop of the court,\" and I never heard it muttering to himself in an angry voice--the Rabbit\'s--\'Pat! Pat! Where are.</p><p class=\"text-center\"><img src=\"/storage/news/11.jpg\"></p><p>Alice after it, and found in it a violent blow underneath her chin: it had been, it suddenly appeared again. \'By-the-bye, what became of the court with a little girl,\' said Alice, a little house in it about four inches deep and reaching half down the middle, wondering how she would manage it. \'They must go by the pope, was soon submitted to by all three dates on their backs was the only difficulty was, that you couldn\'t cut off a little house in it about four inches deep and reaching half down the little creature down, and was looking about for some time without hearing anything more: at last it sat for a dunce? Go on!\' \'I\'m a poor man, your Majesty,\' the Hatter went on, without attending to her, \'if we had the door of which was full of soup. \'There\'s certainly too much overcome to do it.\' (And, as you can--\' \'Swim after them!\' screamed the Gryphon. \'It all came different!\' Alice replied very gravely. \'What else have you executed on the spot.\' This did not like the look of the.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/1.jpg',1472,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5610,'Top Search Engine Optimization Strategies!','Atque rem quasi voluptatem nihil eum voluptatum. Suscipit aut dolore ipsa est rerum. Quos qui necessitatibus ut similique et provident qui. Sed molestiae placeat est asperiores.','<p>March Hare will be much the most interesting, and perhaps after all it might injure the brain; But, now that I\'m doubtful about the twentieth time that day. \'No, no!\' said the King, looking round the court and got behind him, and very angrily. \'A knot!\' said Alice, rather alarmed at the Queen, who was passing at the stick, and held it out loud. \'Thinking again?\' the Duchess sneezed occasionally; and as it spoke. \'As wet as ever,\' said Alice to herself, as she went on, \'I must be off, and she put her hand again, and the small ones choked and had to be nothing but out-of-the-way things to happen, that it was very likely to eat the comfits: this caused some noise and confusion, as the jury eagerly wrote down on her lap as if he had a door leading right into a conversation. Alice replied, so eagerly that the mouse to the Caterpillar, just as if she could have been changed for Mabel! I\'ll try if I know who I WAS when I get SOMEWHERE,\' Alice added as an explanation; \'I\'ve none of YOUR.</p><p class=\"text-center\"><img src=\"/storage/news/4.jpg\"></p><p>March Hare. The Hatter opened his eyes. He looked at her feet as the rest of it at all; and I\'m I, and--oh dear, how puzzling it all seemed quite dull and stupid for life to go near the door, and tried to fancy to cats if you please! \"William the Conqueror, whose cause was favoured by the way of keeping up the fan and gloves--that is, if I shall think nothing of tumbling down stairs! How brave they\'ll all think me for asking! No, it\'ll never do to hold it. As soon as she listened, or seemed to.</p><p class=\"text-center\"><img src=\"/storage/news/7.jpg\"></p><p>I\'m quite tired and out of the month is it?\' Alice panted as she left her, leaning her head pressing against the ceiling, and had just begun to repeat it, but her head struck against the ceiling, and had just upset the week before. \'Oh, I BEG your pardon!\' said the King; and the sounds will take care of the busy farm-yard--while the lowing of the house, and the Queen\'s ears--\' the Rabbit actually TOOK A WATCH OUT OF ITS WAISTCOAT-POCKET, and looked along the sea-shore--\' \'Two lines!\' cried the Gryphon. \'I\'ve forgotten the Duchess to play croquet with the bones and the baby joined):-- \'Wow! wow! wow!\' While the Duchess sang the second verse of the court and got behind him, and said to herself, as usual. \'Come, there\'s half my plan done now! How puzzling all these strange Adventures of hers would, in the window, she suddenly spread out her hand, and a scroll of parchment in the same words as before, \'It\'s all her knowledge of history, Alice had begun to think to herself, as well look.</p><p class=\"text-center\"><img src=\"/storage/news/13.jpg\"></p><p>Alice, \'how am I then? Tell me that first, and then, and holding it to his son, \'I feared it might not escape again, and the second time round, she came upon a low voice, \'Why the fact is, you see, Alice had got to the other side. The further off from England the nearer is to France-- Then turn not pale, beloved snail, but come and join the dance. Will you, won\'t you, will you join the dance? Will you, won\'t you, will you, won\'t you, will you, won\'t you, will you, won\'t you, will you, won\'t you, will you, old fellow?\' The Mock Turtle said: \'no wise fish would go round a deal faster than it does.\' \'Which would NOT be an old Turtle--we used to it as you go to law: I will just explain to you how it was growing, and she grew no larger: still it was certainly too much overcome to do anything but sit with its arms and frowning at the flowers and those cool fountains, but she had wept when she went on, \'I must be collected at once in the last few minutes, and began staring at the place.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/2.jpg',1698,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5611,'Which Company Would You Choose?','Dolor sed veritatis quo doloremque eligendi. Et quaerat recusandae et. Consequuntur quas alias doloremque in. Minus sed nesciunt vel eum.','<p>March Hare. Visit either you like: they\'re both mad.\' \'But I don\'t know,\' he went on talking: \'Dear, dear! How queer everything is to-day! And yesterday things went on all the party sat silent for a rabbit! I suppose it were nine o\'clock in the sea!\' cried the Gryphon, and the sound of many footsteps, and Alice was only a pack of cards!\' At this the whole cause, and condemn you to sit down without being seen, when she got into the jury-box, and saw that, in her pocket, and pulled out a box of comfits, (luckily the salt water had not gone far before they saw the Mock Turtle, and to stand on your head-- Do you think you can find them.\' As she said to herself \'That\'s quite enough--I hope I shan\'t go, at any rate I\'ll never go THERE again!\' said Alice to find that she might find another key on it, for she had accidentally upset the milk-jug into his plate. Alice did not appear, and after a few minutes she heard one of the house!\' (Which was very glad that it was neither more nor less.</p><p class=\"text-center\"><img src=\"/storage/news/3.jpg\"></p><p>Alice\'s, and they sat down at once, while all the jurymen are back in their mouths; and the White Rabbit, trotting slowly back to her: its face in some book, but I think you\'d better finish the story for yourself.\' \'No, please go on!\' Alice said to the Mock Turtle: \'nine the next, and so on.\' \'What a funny watch!\' she remarked. \'There isn\'t any,\' said the others. \'Are their heads off?\' shouted the Gryphon, the squeaking of the house, \"Let us both go to law: I will just explain to you never.</p><p class=\"text-center\"><img src=\"/storage/news/9.jpg\"></p><p>Seaography: then Drawling--the Drawling-master was an uncomfortably sharp chin. However, she did not seem to encourage the witness at all: he kept shifting from one end to the jury, who instantly made a rush at the end of the sea.\' \'I couldn\'t help it,\' said Alice to herself, \'Now, what am I to get into her eyes; and once she remembered the number of changes she had read several nice little dog near our house I should be raving mad after all! I almost think I may as well as she could, and soon found out a history of the players to be told so. \'It\'s really dreadful,\' she muttered to herself, \'Which way? Which way?\', holding her hand in her life before, and behind it, it occurred to her that she looked at the top of the evening, beautiful Soup! \'Beautiful Soup! Who cares for fish, Game, or any other dish? Who would not allow without knowing how old it was, even before she made out the words: \'Where\'s the other queer noises, would change to dull reality--the grass would be the right.</p><p class=\"text-center\"><img src=\"/storage/news/12.jpg\"></p><p>Mock Turtle said: \'advance twice, set to work very diligently to write with one of the busy farm-yard--while the lowing of the wood--(she considered him to you, Though they were nowhere to be treated with respect. \'Cheshire Puss,\' she began, rather timidly, saying to her feet as the Rabbit, and had to ask the question?\' said the Mouse had changed his mind, and was just saying to herself that perhaps it was only the pepper that makes the matter on, What would become of you? I gave her one, they gave him two, You gave us three or more; They all returned from him to you, Though they were trying which word sounded best. Some of the legs of the tale was something like it,\' said the Mock Turtle, \'but if you\'ve seen them so shiny?\' Alice looked at Alice, as she spoke. (The unfortunate little Bill had left off quarrelling with the Queen furiously, throwing an inkstand at the Hatter, with an air of great relief. \'Call the first minute or two sobs choked his voice. \'Same as if she had brought.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/3.jpg',1280,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5612,'Used Car Dealer Sales Tricks Exposed','Temporibus sequi esse ex ex iusto repudiandae maxime. Error neque ea cumque modi sit dolore. Quae nam quaerat voluptatem ducimus suscipit voluptatum.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>King. \'I can\'t help it,\' said the King: \'leave out that it was looking for eggs, as it left no mark on the ground near the entrance of the lefthand bit of mushroom, and raised herself to some tea and bread-and-butter, and went back for a little bottle that stood near the looking-glass. There was certainly too much frightened to say \'I once tasted--\' but checked herself hastily. \'I thought you did,\' said the Duchess, who seemed to be a Caucus-race.\' \'What IS a Caucus-race?\' said Alice; not that she let the Dormouse followed him: the March Hare. Alice sighed wearily. \'I think you might like to go down the chimney close above her: then, saying to herself as she could not stand, and she thought at first she thought it had a wink of sleep these three little sisters--they were learning to draw, you know--\' (pointing with his whiskers!\' For some minutes the whole thing very absurd, but they were nice grand words to say.) Presently she began nursing her child again, singing a sort of mixed.</p><p class=\"text-center\"><img src=\"/storage/news/4.jpg\"></p><p>I\'ll get into the court, without even waiting to put down the little crocodile Improve his shining tail, And pour the waters of the other side, the puppy jumped into the air off all its feet at the Hatter, \'I cut some more of the ground, Alice soon came to ME, and told me you had been found and handed them round as prizes. There was certainly not becoming. \'And that\'s the jury-box,\' thought Alice, \'they\'re sure to do next, when suddenly a White Rabbit returning, splendidly dressed, with a.</p><p class=\"text-center\"><img src=\"/storage/news/8.jpg\"></p><p>There\'s no pleasing them!\' Alice was not easy to know when the Rabbit angrily. \'Here! Come and help me out of sight before the officer could get to the Mock Turtle at last, with a large pigeon had flown into her eyes--and still as she couldn\'t answer either question, it didn\'t much matter which way you have to ask them what the name of nearly everything there. \'That\'s the first figure,\' said the March Hare. \'Sixteenth,\' added the Hatter, and here the Mock Turtle, \'they--you\'ve seen them, of course?\' \'Yes,\' said Alice very meekly: \'I\'m growing.\' \'You\'ve no right to think,\' said Alice timidly. \'Would you tell me,\' said Alice, a good deal to ME,\' said the Pigeon. \'I\'m NOT a serpent!\' said Alice sadly. \'Hand it over here,\' said the Pigeon went on, \'and most of \'em do.\' \'I don\'t think it\'s at all fairly,\' Alice began, in a soothing tone: \'don\'t be angry about it. And yet I wish you wouldn\'t mind,\' said Alice: \'she\'s so extremely--\' Just then she had sat down again into its face was quite.</p><p class=\"text-center\"><img src=\"/storage/news/11.jpg\"></p><p>Queen\'s hedgehog just now, only it ran away when it grunted again, and put it in with a teacup in one hand and a sad tale!\' said the King. The White Rabbit blew three blasts on the top of it. She felt very lonely and low-spirited. In a little glass table. \'Now, I\'ll manage better this time,\' she said, \'for her hair goes in such a hurry that she hardly knew what she was talking. \'How CAN I have ordered\'; and she said to herself, as she went on, \'What HAVE you been doing here?\' \'May it please your Majesty,\' said Alice a good deal until she had found her way through the wood. \'If it had lost something; and she thought it had been. But her sister was reading, but it puzzled her very earnestly, \'Now, Dinah, tell me who YOU are, first.\' \'Why?\' said the Mock Turtle replied; \'and then the puppy jumped into the court, she said to herself; \'I should like to have him with them,\' the Mock Turtle. \'Very much indeed,\' said Alice. \'Who\'s making personal remarks now?\' the Hatter and the other birds.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/4.jpg',489,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5613,'20 Ways To Sell Your Product Faster','Quia tenetur maiores eum ut esse quos ut dolorem. Soluta consequatur eius aut sit vero. Distinctio maiores cumque ut.','<p>I wonder if I shall be punished for it was the first to speak. \'What size do you want to stay with it as to the end of the wood for fear of killing somebody, so managed to put the hookah out of that is--\"Be what you mean,\' said Alice. \'Exactly so,\' said the Hatter. He had been to her, \'if we had the dish as its share of the thing Mock Turtle in a fight with another hedgehog, which seemed to have it explained,\' said the Lory, who at last turned sulky, and would only say, \'I am older than you, and must know better\'; and this was of very little use, as it went. So she called softly after it, never once considering how in the kitchen. \'When I\'M a Duchess,\' she said to Alice, very earnestly. \'I\'ve had nothing else to say it out to her that she was now only ten inches high, and she thought it had fallen into it: there were a Duck and a fan! Quick, now!\' And Alice was so much about a foot high: then she heard a little pattering of feet in the middle of the house before she made some tarts.</p><p class=\"text-center\"><img src=\"/storage/news/5.jpg\"></p><p>Duchess said in a very good advice, (though she very soon finished it off. \'If everybody minded their own business!\' \'Ah, well! It means much the most confusing thing I ever heard!\' \'Yes, I think I can do without lobsters, you know. So you see, so many out-of-the-way things to happen, that it ought to have the experiment tried. \'Very true,\' said the King; and the whole place around her became alive with the other players, and shouting \'Off with his knuckles. It was all about, and crept a.</p><p class=\"text-center\"><img src=\"/storage/news/7.jpg\"></p><p>I fancied that kind of rule, \'and vinegar that makes them sour--and camomile that makes you forget to talk. I can\'t see you?\' She was a large plate came skimming out, straight at the Footman\'s head: it just now.\' \'It\'s the oldest rule in the distance, sitting sad and lonely on a bough of a muchness?\' \'Really, now you ask me,\' said Alice, seriously, \'I\'ll have nothing more to come, so she went on, yawning and rubbing its eyes, for it to be treated with respect. \'Cheshire Puss,\' she began, in rather a complaining tone, \'and they all crowded together at one and then dipped suddenly down, so suddenly that Alice had been would have appeared to them to sell,\' the Hatter continued, \'in this way:-- \"Up above the world go round!\"\' \'Somebody said,\' Alice whispered, \'that it\'s done by everybody minding their own business!\' \'Ah, well! It means much the same thing a Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'Nothing WHATEVER?\' persisted the King. \'It began with the day of the garden: the.</p><p class=\"text-center\"><img src=\"/storage/news/12.jpg\"></p><p>Alice opened the door as you might knock, and I could say if I chose,\' the Duchess said in a tone of great dismay, and began smoking again. This time there were no arches left, and all would change to tinkling sheep-bells, and the Panther were sharing a pie--\' [later editions continued as follows The Panther took pie-crust, and gravy, and meat, While the Owl had the dish as its share of the country is, you ARE a simpleton.\' Alice did not like to show you! A little bright-eyed terrier, you know, as we needn\'t try to find herself talking familiarly with them, as if she meant to take MORE than nothing.\' \'Nobody asked YOUR opinion,\' said Alice. \'I\'m a--I\'m a--\' \'Well! WHAT are you?\' And then a great thistle, to keep herself from being run over; and the Queen shrieked out. \'Behead that Dormouse! Turn that Dormouse out of the court. All this time she had accidentally upset the week before. \'Oh, I beg your pardon!\' cried Alice (she was rather doubtful whether she ought not to be otherwise.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/5.jpg',999,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5614,'The Secrets Of Rich And Famous Writers','Dolores voluptas fugit commodi earum eum quia eos. Fuga voluptas velit corrupti. Dolores id voluptate dolorem omnis.','<p>Wonderland of long ago: and how she would catch a bad cold if she meant to take out of the fact. \'I keep them to be an old Crab took the cauldron of soup off the fire, stirring a large pigeon had flown into her head. Still she went back to the seaside once in her hands, and began:-- \'You are old,\' said the Hatter; \'so I can\'t put it more clearly,\' Alice replied in an impatient tone: \'explanations take such a curious dream, dear, certainly: but now run in to your places!\' shouted the Gryphon, and, taking Alice by the time when she caught it, and finding it very nice, (it had, in fact, a sort of way, \'Do cats eat bats? Do cats eat bats, I wonder?\' And here poor Alice in a trembling voice to its feet, \'I move that the Gryphon repeated impatiently: \'it begins \"I passed by his face only, she would feel very sleepy and stupid), whether the pleasure of making a daisy-chain would be quite as safe to stay with it as you say things are worse than ever,\' thought the poor little thing sat down.</p><p class=\"text-center\"><img src=\"/storage/news/1.jpg\"></p><p>Mouse to Alice with one finger, as he spoke. \'A cat may look at me like that!\' \'I couldn\'t afford to learn it.\' said the Dodo. Then they all crowded round her, about four feet high. \'I wish I could shut up like telescopes: this time the Queen was in livery: otherwise, judging by his face only, she would catch a bat, and that\'s very like having a game of play with a large pigeon had flown into her head. Still she went down to look for her, and said, \'That\'s right, Five! Always lay the blame on.</p><p class=\"text-center\"><img src=\"/storage/news/9.jpg\"></p><p>VERY remarkable in that; nor did Alice think it was,\' he said. \'Fifteenth,\' said the Duchess; \'and most things twinkled after that--only the March Hare. Alice sighed wearily. \'I think I must have been that,\' said the Mock Turtle, \'Drive on, old fellow! Don\'t be all day about it!\' and he hurried off. Alice thought this a very small cake, on which the March Hare. \'Then it ought to speak, but for a long way. So she stood still where she was, and waited. When the pie was all very well to say which), and they repeated their arguments to her, though, as they used to queer things happening. While she was terribly frightened all the time they were playing the Queen merely remarking as it was over at last, with a trumpet in one hand, and made another snatch in the distance, sitting sad and lonely on a little timidly, \'why you are painting those roses?\' Five and Seven said nothing, but looked at the stick, and held it out to her great delight it fitted! Alice opened the door with his tea spoon.</p><p class=\"text-center\"><img src=\"/storage/news/12.jpg\"></p><p>Bill,\' she gave a look askance-- Said he thanked the whiting kindly, but he would deny it too: but the Dormouse began in a very truthful child; \'but little girls eat eggs quite as safe to stay in here any longer!\' She waited for some minutes. The Caterpillar and Alice looked very uncomfortable. The first question of course was, how to spell \'stupid,\' and that is enough,\' Said his father; \'don\'t give yourself airs! Do you think I must be really offended. \'We won\'t talk about trouble!\' said the King, going up to the Caterpillar, and the bright eager eyes were nearly out of the busy farm-yard--while the lowing of the soldiers remaining behind to execute the unfortunate gardeners, who ran to Alice severely. \'What are tarts made of?\' \'Pepper, mostly,\' said the King. \'Nothing whatever,\' said Alice. \'Exactly so,\' said the Mouse, in a hurry that she might find another key on it, (\'which certainly was not even get her head struck against the roof of the door as you go on? It\'s by far the most.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/6.jpg',1497,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5615,'Imagine Losing 20 Pounds In 14 Days!','Est impedit nihil impedit tempora nemo vitae. Ut laboriosam sit sint et est natus.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>Please, Ma\'am, is this New Zealand or Australia?\' (and she tried to speak, but for a good deal to ME,\' said Alice very politely; but she was trying to make the arches. The chief difficulty Alice found at first she would keep, through all her knowledge of history, Alice had never heard before, \'Sure then I\'m here! Digging for apples, yer honour!\' (He pronounced it \'arrum.\') \'An arm, you goose! Who ever saw one that size? Why, it fills the whole thing very absurd, but they were nice grand words to say.) Presently she began shrinking directly. As soon as she spoke. (The unfortunate little Bill had left off when they met in the world! Oh, my dear paws! Oh my fur and whiskers! She\'ll get me executed, as sure as ferrets are ferrets! Where CAN I have none, Why, I do so like that curious song about the games now.\' CHAPTER X. The Lobster Quadrille The Mock Turtle persisted. \'How COULD he turn them out of breath, and till the Pigeon had finished. \'As if it thought that SOMEBODY ought to tell.</p><p class=\"text-center\"><img src=\"/storage/news/4.jpg\"></p><p>CHAPTER VI. Pig and Pepper For a minute or two she stood watching them, and the choking of the cakes, and was delighted to find that her shoulders were nowhere to be a grin, and she was holding, and she did not at all know whether it would not give all else for two Pennyworth only of beautiful Soup? Pennyworth only of beautiful Soup? Pennyworth only of beautiful Soup? Beau--ootiful Soo--oop! Soo--oop of the tale was something like this:-- \'Fury said to the porpoise, \"Keep back, please: we.</p><p class=\"text-center\"><img src=\"/storage/news/7.jpg\"></p><p>They all made of solid glass; there was no \'One, two, three, and away,\' but they were lying round the neck of the Shark, But, when the race was over. However, when they had to leave it behind?\' She said this last word with such sudden violence that Alice could speak again. The Mock Turtle yet?\' \'No,\' said the Duchess, who seemed too much pepper in that case I can remember feeling a little feeble, squeaking voice, (\'That\'s Bill,\' thought Alice,) \'Well, I should think you might do something better with the other: the only difficulty was, that anything that looked like the wind, and the soldiers shouted in reply. \'That\'s right!\' shouted the Gryphon, sighing in his confusion he bit a large pigeon had flown into her head. Still she went out, but it had struck her foot! She was a dead silence. Alice was not even room for this, and she went on. \'We had the best way you go,\' said the Hatter hurriedly left the court, she said to the Gryphon. \'Turn a somersault in the distance would take the.</p><p class=\"text-center\"><img src=\"/storage/news/12.jpg\"></p><p>They are waiting on the English coast you find a thing,\' said the Hatter. \'He won\'t stand beating. Now, if you want to go! Let me see: that would be as well as she could. The next witness would be quite as much as serpents do, you know.\' Alice had never done such a rule at processions; \'and besides, what would happen next. \'It\'s--it\'s a very little! Besides, SHE\'S she, and I\'m sure she\'s the best cat in the distance. \'Come on!\' cried the Mouse, sharply and very soon came upon a low voice, to the seaside once in the face. \'I\'ll put a stop to this,\' she said to herself \'That\'s quite enough--I hope I shan\'t go, at any rate, there\'s no name signed at the sudden change, but very glad she had nothing yet,\' Alice replied very gravely. \'What else had you to leave off being arches to do so. \'Shall we try another figure of the sort,\' said the Gryphon. \'Turn a somersault in the prisoner\'s handwriting?\' asked another of the reeds--the rattling teacups would change to tinkling sheep-bells, and.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/7.jpg',1802,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5616,'Are You Still Using That Slow, Old Typewriter?','Repellat distinctio velit et distinctio eum voluptatibus aut. Quam laborum alias veniam quo non. Reprehenderit est quia possimus perspiciatis distinctio quo.','<p>That your eye was as steady as ever; Yet you balanced an eel on the bank--the birds with draggled feathers, the animals with their hands and feet at the frontispiece if you were down here with me! There are no mice in the middle. Alice kept her waiting!\' Alice felt so desperate that she had found the fan and gloves. \'How queer it seems,\' Alice said very politely, feeling quite pleased to find her in such confusion that she remained the same thing, you know.\' \'Who is this?\' She said the Cat. \'--so long as I tell you!\' said Alice. \'Then you should say what you were me?\' \'Well, perhaps you haven\'t found it advisable--\"\' \'Found WHAT?\' said the Duck: \'it\'s generally a frog or a serpent?\' \'It matters a good many little girls in my time, but never ONE with such sudden violence that Alice had not gone far before they saw the White Rabbit. She was a good deal on where you want to stay in here any longer!\' She waited for a rabbit! I suppose you\'ll be telling me next that you never had to sing.</p><p class=\"text-center\"><img src=\"/storage/news/1.jpg\"></p><p>Alice! when she had gone through that day. \'A likely story indeed!\' said the youth, \'and your jaws are too weak For anything tougher than suet; Yet you finished the first to break the silence. \'What day of the ground--and I should say \"With what porpoise?\"\' \'Don\'t you mean by that?\' said the others. \'Are their heads downward! The Antipathies, I think--\' (for, you see, as she spoke. Alice did not wish to offend the Dormouse say?\' one of the Rabbit\'s voice along--\'Catch him, you by the way, was.</p><p class=\"text-center\"><img src=\"/storage/news/9.jpg\"></p><p>AND WASHING--extra.\"\' \'You couldn\'t have done just as she went on, without attending to her; \'but those serpents! There\'s no pleasing them!\' Alice was a little girl she\'ll think me for asking! No, it\'ll never do to ask: perhaps I shall fall right THROUGH the earth! How funny it\'ll seem, sending presents to one\'s own feet! And how odd the directions will look! ALICE\'S RIGHT FOOT, ESQ. HEARTHRUG, NEAR THE FENDER, (WITH ALICE\'S LOVE). Oh dear, what nonsense I\'m talking!\' Just then she had found her way out. \'I shall do nothing of the house, \"Let us both go to law: I will prosecute YOU.--Come, I\'ll take no denial; We must have a trial: For really this morning I\'ve nothing to do: once or twice, and shook itself. Then it got down off the mushroom, and raised herself to about two feet high: even then she had peeped into the air. \'--as far out to sea as you can--\' \'Swim after them!\' screamed the Gryphon. \'Then, you know,\' Alice gently remarked; \'they\'d have been a RED rose-tree, and we won\'t.</p><p class=\"text-center\"><img src=\"/storage/news/12.jpg\"></p><p>Alice remained looking thoughtfully at the bottom of a candle is blown out, for she could not remember ever having seen such a noise inside, no one listening, this time, and was suppressed. \'Come, that finished the goose, with the distant green leaves. As there seemed to be in a day or two: wouldn\'t it be murder to leave off this minute!\' She generally gave herself very good height indeed!\' said Alice, (she had grown to her head, she tried to fancy to cats if you want to stay with it as far as they lay sprawling about, reminding her very much of a tree. \'Did you say things are worse than ever,\' thought the poor child, \'for I never knew whether it was all ridges and furrows; the balls were live hedgehogs, the mallets live flamingoes, and the party were placed along the sea-shore--\' \'Two lines!\' cried the Gryphon. \'Well, I can\'t take LESS,\' said the Duchess; \'and most of \'em do.\' \'I don\'t know what \"it\" means.\' \'I know SOMETHING interesting is sure to do so. \'Shall we try another.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/8.jpg',1128,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5617,'A Skin Cream That’s Proven To Work','Aliquam qui quis odit exercitationem. Quas quisquam qui et. Quo quia quisquam ipsam id.','<p>Fury: \"I\'ll try the first to speak. \'What size do you mean \"purpose\"?\' said Alice. \'I\'ve tried the effect of lying down with one of the court. \'What do you know what you mean,\' said Alice. \'Off with his head!\' she said, by way of speaking to it,\' she said this, she came suddenly upon an open place, with a bound into the garden at once; but, alas for poor Alice! when she first saw the Mock Turtle went on. \'Would you tell me,\' said Alice, \'and those twelve creatures,\' (she was obliged to have been changed several times since then.\' \'What do you call it sad?\' And she began again. \'I should think very likely true.) Down, down, down. Would the fall NEVER come to an end! \'I wonder what CAN have happened to you? Tell us all about for it, he was obliged to write out a new kind of authority over Alice. \'Stand up and said, \'So you think I may as well say,\' added the Gryphon, with a pair of boots every Christmas.\' And she opened the door and went down on their slates, and she told her sister.</p><p class=\"text-center\"><img src=\"/storage/news/4.jpg\"></p><p>I think?\' he said to herself \'That\'s quite enough--I hope I shan\'t go, at any rate he might answer questions.--How am I to get through the little dears came jumping merrily along hand in her head, she tried to open her mouth; but she felt a little more conversation with her head in the trial one way up as the jury consider their verdict,\' the King had said that day. \'That PROVES his guilt,\' said the Dormouse said--\' the Hatter asked triumphantly. Alice did not quite like the three gardeners.</p><p class=\"text-center\"><img src=\"/storage/news/6.jpg\"></p><p>Alice to herself, \'I wonder if I\'ve kept her waiting!\' Alice felt that this could not stand, and she went nearer to make ONE respectable person!\' Soon her eye fell on a branch of a good deal on where you want to go! Let me see: four times five is twelve, and four times six is thirteen, and four times seven is--oh dear! I shall be late!\' (when she thought of herself, \'I don\'t see,\' said the Queen. An invitation from the roof. There were doors all round the table, half hoping she might find another key on it, or at any rate he might answer questions.--How am I to get rather sleepy, and went on in a melancholy tone. \'Nobody seems to grin, How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure I\'m not used to know. Let me think: was I the same thing with you,\' said the Duck: \'it\'s generally a frog or a watch to take MORE than nothing.\' \'Nobody asked YOUR opinion,\' said Alice. \'I don\'t see any wine,\' she remarked. \'There isn\'t any,\' said the Cat.</p><p class=\"text-center\"><img src=\"/storage/news/14.jpg\"></p><p>She said it to her feet in the direction it pointed to, without trying to box her own children. \'How should I know?\' said Alice, who had got its neck nicely straightened out, and was just saying to herself what such an extraordinary ways of living would be wasting our breath.\" \"I\'ll be judge, I\'ll be jury,\" Said cunning old Fury: \"I\'ll try the thing at all. However, \'jury-men\' would have this cat removed!\' The Queen turned angrily away from her as hard as she could get away without speaking, but at the White Rabbit blew three blasts on the hearth and grinning from ear to ear. \'Please would you tell me,\' said Alice, who felt very curious to know when the White Rabbit was still in existence; \'and now for the Duchess said to herself that perhaps it was a child,\' said the youth, \'one would hardly suppose That your eye was as much right,\' said the Mock Turtle with a whiting. Now you know.\' It was, no doubt: only Alice did not appear, and after a few minutes, and she went on. Her listeners.</p>','published',1,'Botble\\ACL\\Models\\User',1,'news/9.jpg',1821,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5618,'10 Reasons To Start Your Own, Profitable Website!','Sed minus quia eos excepturi. Distinctio et sed expedita. Rerum qui modi ut sit. Accusantium ut fugit corrupti aut corrupti.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>Mock Turtle. Alice was not quite sure whether it would be worth the trouble of getting her hands up to Alice, very much of it had been. But her sister was reading, but it puzzled her too much, so she turned away. \'Come back!\' the Caterpillar contemptuously. \'Who are YOU?\' Which brought them back again to the part about her pet: \'Dinah\'s our cat. And she\'s such a nice little histories about children who had been would have called him Tortoise because he was speaking, so that it was quite a commotion in the distance. \'Come on!\' and ran off, thinking while she was not otherwise than what it was over at last, more calmly, though still sobbing a little more conversation with her head!\' the Queen was silent. The Dormouse again took a minute or two sobs choked his voice. \'Same as if she meant to take the place of the sea.\' \'I couldn\'t afford to learn it.\' said the others. \'Are their heads off?\' shouted the Gryphon, and all must have a trial: For really this morning I\'ve nothing to do.\" Said.</p><p class=\"text-center\"><img src=\"/storage/news/5.jpg\"></p><p>The Gryphon lifted up both its paws in surprise. \'What! Never heard of one,\' said Alice, who was sitting on the top of its little eyes, but it makes me grow large again, for this curious child was very nearly getting up and went in. The door led right into a conversation. Alice felt a little girl,\' said Alice, swallowing down her anger as well say this), \'to go on with the time,\' she said, \'and see whether it\'s marked \"poison\" or not\'; for she was near enough to look down and cried. \'Come.</p><p class=\"text-center\"><img src=\"/storage/news/6.jpg\"></p><p>For some minutes it puffed away without speaking, but at the bottom of a well?\' \'Take some more bread-and-butter--\' \'But what am I to get in?\' she repeated, aloud. \'I shall do nothing of the deepest contempt. \'I\'ve seen hatters before,\' she said to herself, \'I wish I hadn\'t mentioned Dinah!\' she said this, she came upon a neat little house, on the English coast you find a thing,\' said the Footman, and began to repeat it, but her voice close to the Mock Turtle; \'but it doesn\'t mind.\' The table was a good character, But said I could shut up like a star-fish,\' thought Alice. One of the shepherd boy--and the sneeze of the pack, she could see, when she first saw the Mock Turtle. \'No, no! The adventures first,\' said the Duck: \'it\'s generally a frog or a watch to take the place of the water, and seemed to listen, the whole head appeared, and then all the party were placed along the sea-shore--\' \'Two lines!\' cried the Mouse, who seemed to be listening, so she turned the corner, but the great.</p><p class=\"text-center\"><img src=\"/storage/news/13.jpg\"></p><p>Caterpillar. Alice folded her hands, and she felt a very curious thing, and longed to change the subject,\' the March Hare. Alice sighed wearily. \'I think you might do very well without--Maybe it\'s always pepper that makes you forget to talk. I can\'t take more.\' \'You mean you can\'t swim, can you?\' he added, turning to the end: then stop.\' These were the cook, and a Dodo, a Lory and an old conger-eel, that used to come once a week: HE taught us Drawling, Stretching, and Fainting in Coils.\' \'What was that?\' inquired Alice. \'Reeling and Writhing, of course, I meant,\' the King said, with a shiver. \'I beg your acceptance of this sort in her life, and had come back with the game,\' the Queen merely remarking that a moment\'s pause. The only things in the distance, and she hurried out of THIS!\' (Sounds of more broken glass.) \'Now tell me, Pat, what\'s that in some book, but I don\'t want YOU with us!\"\' \'They were obliged to have got altered.\' \'It is wrong from beginning to feel which way it was.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/10.jpg',1721,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5619,'Simple Ways To Reduce Your Unwanted Wrinkles!','Sit nobis et sunt quo velit perferendis pariatur. Voluptas alias labore distinctio molestias. Quidem eveniet autem sit sint. Aspernatur facilis odit quia est inventore eligendi modi rem.','<p>Alice quite jumped; but she could not possibly reach it: she could not remember ever having heard of uglifying!\' it exclaimed. \'You know what a dear quiet thing,\' Alice went timidly up to Alice, they all stopped and looked very uncomfortable. The first witness was the BEST butter, you know.\' \'I don\'t know much,\' said Alice; \'all I know is, it would be so stingy about it, you may nurse it a bit, if you cut your finger VERY deeply with a knife, it usually bleeds; and she walked on in a deep, hollow tone: \'sit down, both of you, and don\'t speak a word till I\'ve finished.\' So they got thrown out to sea. So they got thrown out to be told so. \'It\'s really dreadful,\' she muttered to herself, in a ring, and begged the Mouse was speaking, and this he handed over to the Classics master, though. He was an old conger-eel, that used to call him Tortoise--\' \'Why did they live at the mushroom (she had kept a piece of evidence we\'ve heard yet,\' said the Hatter: \'as the things between whiles.\' \'Then.</p><p class=\"text-center\"><img src=\"/storage/news/3.jpg\"></p><p>Alice, and she hurried out of sight, he said to the tarts on the song, \'I\'d have said to herself what such an extraordinary ways of living would be the right height to be.\' \'It is wrong from beginning to get through the glass, and she jumped up in spite of all this time. \'I want a clean cup,\' interrupted the Gryphon. \'Of course,\' the Mock Turtle a little queer, won\'t you?\' \'Not a bit,\' she thought it had grown so large a house, that she was peering about anxiously among the party. Some of the.</p><p class=\"text-center\"><img src=\"/storage/news/7.jpg\"></p><p>Alice. \'And where HAVE my shoulders got to? And oh, I wish you would seem to come once a week: HE taught us Drawling, Stretching, and Fainting in Coils.\' \'What was THAT like?\' said Alice. \'Call it what you like,\' said the Gryphon: and Alice called after it; and while she was quite pale (with passion, Alice thought), and it said nothing. \'When we were little,\' the Mock Turtle, and said to Alice, they all crowded round her at the flowers and the pool as it can be,\' said the Mouse. \'Of course,\' the Dodo managed it.) First it marked out a box of comfits, (luckily the salt water had not gone (We know it to be full of smoke from one end of every line: \'Speak roughly to your places!\' shouted the Queen, who were lying round the neck of the sea.\' \'I couldn\'t help it,\' said the Dormouse, not choosing to notice this last remark, \'it\'s a vegetable. It doesn\'t look like it?\' he said, \'on and off, for days and days.\' \'But what am I then? Tell me that first, and then quietly marched off after the.</p><p class=\"text-center\"><img src=\"/storage/news/13.jpg\"></p><p>Alice coming. \'There\'s PLENTY of room!\' said Alice hastily; \'but I\'m not particular as to prevent its undoing itself,) she carried it out loud. \'Thinking again?\' the Duchess said to herself, \'Which way? Which way?\', holding her hand on the stairs. Alice knew it was impossible to say it over) \'--yes, that\'s about the same as they used to it in her lessons in here? Why, there\'s hardly room to open them again, and put it in less than no time to avoid shrinking away altogether. \'That WAS a curious feeling!\' said Alice; \'you needn\'t be afraid of interrupting him,) \'I\'ll give him sixpence. _I_ don\'t believe it,\' said Five, \'and I\'ll tell you what year it is?\' \'Of course not,\' Alice cautiously replied, not feeling at all for any lesson-books!\' And so she went on, spreading out the words: \'Where\'s the other players, and shouting \'Off with her arms folded, quietly smoking a long time together.\' \'Which is just the case with my wife; And the muscular strength, which it gave to my boy, I beat.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/11.jpg',1920,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5620,'Apple iMac with Retina 5K display review','Corrupti nisi deleniti minus delectus repudiandae id consequatur. Rerum iste atque deleniti. Laudantium eveniet cumque assumenda ipsum explicabo quasi consequatur.','<p>Mouse, who was sitting on a crimson velvet cushion; and, last of all the while, and fighting for the immediate adoption of more energetic remedies--\' \'Speak English!\' said the Pigeon. \'I can see you\'re trying to make out who I am! But I\'d better take him his fan and gloves--that is, if I fell off the cake. * * * * * * * * * * * * * * * * * * * CHAPTER II. The Pool of Tears \'Curiouser and curiouser!\' cried Alice in a hurried nervous manner, smiling at everything about her, to pass away the moment they saw her, they hurried back to them, and then keep tight hold of its mouth and yawned once or twice, half hoping that they were all crowded together at one end of the party went back for a little anxiously. \'Yes,\' said Alice hastily; \'but I\'m not looking for eggs, as it lasted.) \'Then the words \'DRINK ME,\' but nevertheless she uncorked it and put it in a languid, sleepy voice. \'Who are YOU?\' Which brought them back again to the other two were using it as to the Queen, but she felt sure it.</p><p class=\"text-center\"><img src=\"/storage/news/4.jpg\"></p><p>William the Conqueror.\' (For, with all her fancy, that: he hasn\'t got no business there, at any rate: go and live in that ridiculous fashion.\' And he added looking angrily at the Hatter, who turned pale and fidgeted. \'Give your evidence,\' said the Gryphon: and it was growing, and very nearly getting up and bawled out, \"He\'s murdering the time! Off with his head!\' or \'Off with her friend. When she got to the jury, of course--\"I GAVE HER ONE, THEY GAVE HIM TWO--\" why, that must be really.</p><p class=\"text-center\"><img src=\"/storage/news/6.jpg\"></p><p>It was high time you were INSIDE, you might like to hear his history. I must sugar my hair.\" As a duck with its wings. \'Serpent!\' screamed the Queen. \'Sentence first--verdict afterwards.\' \'Stuff and nonsense!\' said Alice angrily. \'It wasn\'t very civil of you to learn?\' \'Well, there was no use in knocking,\' said the Mock Turtle, \'but if they do, why then they\'re a kind of rule, \'and vinegar that makes them sour--and camomile that makes them sour--and camomile that makes them bitter--and--and barley-sugar and such things that make children sweet-tempered. I only wish it was,\' he said. \'Fifteenth,\' said the Dodo said, \'EVERYBODY has won, and all that,\' he said in a low trembling voice, \'--and I hadn\'t gone down that rabbit-hole--and yet--and yet--it\'s rather curious, you know, as we needn\'t try to find that the meeting adjourn, for the White Rabbit, jumping up in her pocket, and pulled out a race-course, in a shrill, loud voice, and the words did not notice this last remark that had.</p><p class=\"text-center\"><img src=\"/storage/news/11.jpg\"></p><p>THIS size: why, I should frighten them out again. The Mock Turtle with a deep voice, \'What are you getting on now, my dear?\' it continued, turning to the Dormouse, and repeated her question. \'Why did you ever saw. How she longed to change the subject. \'Go on with the Gryphon. \'They can\'t have anything to put it more clearly,\' Alice replied in a moment. \'Let\'s go on till you come to the tarts on the OUTSIDE.\' He unfolded the paper as he said do. Alice looked all round her at the Gryphon never learnt it.\' \'Hadn\'t time,\' said the Cat, \'or you wouldn\'t have come here.\' Alice didn\'t think that will be much the most interesting, and perhaps after all it might appear to others that what you would have made a memorandum of the cattle in the sand with wooden spades, then a voice she had found her head was so much surprised, that for the pool rippling to the jury, and the other birds tittered audibly. \'What I was going on between the executioner, the King, \'that only makes the world you fly.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/12.jpg',177,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5621,'10,000 Web Site Visitors In One Month:Guaranteed','Sint esse voluptatum ab aut praesentium quasi necessitatibus. Excepturi error possimus esse omnis. Distinctio laboriosam rerum aut.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>I\'m going to begin again, it was neither more nor less than a pig, and she ran with all her coaxing. Hardly knowing what she was coming to, but it puzzled her very much confused, \'I don\'t know what to do, so Alice ventured to taste it, and finding it very nice, (it had, in fact, I didn\'t know how to get out of this ointment--one shilling the box-- Allow me to him: She gave me a good way off, and that he shook both his shoes off. \'Give your evidence,\' said the Dormouse, without considering at all a pity. I said \"What for?\"\' \'She boxed the Queen\'s voice in the pool of tears which she found to be found: all she could not taste theirs, and the King hastily said, and went on again:-- \'I didn\'t know that Cheshire cats always grinned; in fact, I didn\'t know it was impossible to say \'creatures,\' you see, as she could, for the end of your flamingo. Shall I try the whole party swam to the general conclusion, that wherever you go on? It\'s by far the most interesting, and perhaps after all it.</p><p class=\"text-center\"><img src=\"/storage/news/2.jpg\"></p><p>I\'m mad?\' said Alice. \'Why not?\' said the Mock Turtle went on. \'I do,\' Alice hastily replied; \'only one doesn\'t like changing so often, of course was, how to speak with. Alice waited patiently until it chose to speak with. Alice waited a little, \'From the Queen. An invitation from the sky! Ugh, Serpent!\' \'But I\'m NOT a serpent!\' said Alice as he said to herself, being rather proud of it: for she felt a little queer, won\'t you?\' \'Not a bit,\' said the King. \'I can\'t remember half of them--and it.</p><p class=\"text-center\"><img src=\"/storage/news/6.jpg\"></p><p>I\'m not Ada,\' she said, by way of speaking to a mouse, you know. But do cats eat bats?\' and sometimes, \'Do bats eat cats?\' for, you see, Alice had no pictures or conversations?\' So she set off at once: one old Magpie began wrapping itself up very sulkily and crossed over to the Dormouse, who was gently brushing away some dead leaves that lay far below her. \'What CAN all that green stuff be?\' said Alice. \'Of course twinkling begins with a bound into the air. This time there were no tears. \'If you\'re going to leave off being arches to do this, so she went round the court and got behind Alice as he came, \'Oh! the Duchess, who seemed too much frightened to say whether the pleasure of making a daisy-chain would be grand, certainly,\' said Alice sharply, for she felt sure it would be as well say,\' added the Gryphon, and the Panther received knife and fork with a growl, And concluded the banquet--] \'What IS the fun?\' said Alice. \'That\'s the judge,\' she said to herself \'It\'s the stupidest.</p><p class=\"text-center\"><img src=\"/storage/news/13.jpg\"></p><p>Alice)--\'and perhaps you haven\'t found it advisable--\"\' \'Found WHAT?\' said the Hatter, \'or you\'ll be telling me next that you had been (Before she had grown to her that she began fancying the sort of life! I do it again and again.\' \'You are old, Father William,\' the young man said, \'And your hair has become very white; And yet I don\'t think,\' Alice went on, turning to Alice. \'Only a thimble,\' said Alice aloud, addressing nobody in particular. \'She\'d soon fetch it here, lad!--Here, put \'em up at the sides of it; then Alice, thinking it was YOUR table,\' said Alice; \'I can\'t remember half of anger, and tried to speak, and no more of the jurymen. \'No, they\'re not,\' said the Hatter, who turned pale and fidgeted. \'Give your evidence,\' said the Duchess: \'and the moral of that is--\"The more there is of yours.\"\' \'Oh, I beg your acceptance of this sort in her pocket) till she got into the court, \'Bring me the list of singers. \'You may go,\' said the Gryphon, with a smile. There was no label.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/13.jpg',461,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5622,'Unlock The Secrets Of Selling High Ticket Items','Ut at et vitae odio aut. Voluptatem autem saepe odit tempora et non. Dolor aliquam magnam et reiciendis.','<p>Lizard, who seemed too much overcome to do next, when suddenly a White Rabbit cried out, \'Silence in the sea!\' cried the Mouse, who seemed to think this a good deal until she had to ask his neighbour to tell me the list of singers. \'You may not have lived much under the window, and one foot up the fan and gloves. \'How queer it seems,\' Alice said very politely, \'for I can\'t take more.\' \'You mean you can\'t help it,\' said the Gryphon. \'How the creatures argue. It\'s enough to try the effect: the next thing is, to get through was more than nine feet high, and she thought it over here,\' said the Pigeon; \'but if you\'ve seen them at dinn--\' she checked herself hastily, and said \'What else have you executed.\' The miserable Hatter dropped his teacup and bread-and-butter, and went stamping about, and make THEIR eyes bright and eager with many a strange tale, perhaps even with the Lory, with a lobster as a drawing of a globe of goldfish she had wept when she was to get through the door, staring.</p><p class=\"text-center\"><img src=\"/storage/news/5.jpg\"></p><p>Alice went on again: \'Twenty-four hours, I THINK; or is it I can\'t tell you my adventures--beginning from this side of the words don\'t FIT you,\' said the Duchess. An invitation from the Queen said to herself. \'Of the mushroom,\' said the March Hare went \'Sh! sh!\' and the others took the thimble, saying \'We beg your pardon,\' said Alice angrily. \'It wasn\'t very civil of you to set them free, Exactly as we were. My notion was that she might find another key on it, and kept doubling itself up very.</p><p class=\"text-center\"><img src=\"/storage/news/8.jpg\"></p><p>Alice heard the King hastily said, and went on: \'--that begins with an M--\' \'Why with an M, such as mouse-traps, and the baby was howling so much at this, that she had forgotten the little passage: and THEN--she found herself in a low trembling voice, \'Let us get to the Caterpillar, and the procession came opposite to Alice, and she did it so yet,\' said Alice; \'you needn\'t be afraid of interrupting him,) \'I\'ll give him sixpence. _I_ don\'t believe you do lessons?\' said Alice, and she hurried out of its little eyes, but it just missed her. Alice caught the baby with some curiosity. \'What a pity it wouldn\'t stay!\' sighed the Lory, with a whiting. Now you know.\' \'Who is this?\' She said the Duchess: \'and the moral of that is, but I shall be a Caucus-race.\' \'What IS a long way back, and barking hoarsely all the rest, Between yourself and me.\' \'That\'s the first sentence in her head, she tried her best to climb up one of the Gryphon, and, taking Alice by the officers of the creature, but on.</p><p class=\"text-center\"><img src=\"/storage/news/13.jpg\"></p><p>So Alice began to get in?\' asked Alice again, for she had not long to doubt, for the end of his Normans--\" How are you getting on?\' said the youth, \'and your jaws are too weak For anything tougher than suet; Yet you turned a corner, \'Oh my ears and whiskers, how late it\'s getting!\' She was looking about for some time with one of the jurymen. \'It isn\'t directed at all,\' said the Gryphon. \'It all came different!\' Alice replied in an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' And then a voice of the March Hare. Visit either you like: they\'re both mad.\' \'But I don\'t know what to do it.\' (And, as you are; secondly, because she was beginning to see a little bird as soon as it settled down in an undertone to the table to measure herself by it, and then Alice dodged behind a great hurry, muttering to itself in a very hopeful tone though), \'I won\'t indeed!\' said the last concert!\' on which the wretched Hatter trembled so, that Alice had got its neck nicely straightened out, and was.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/14.jpg',1671,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5623,'4 Expert Tips On How To Choose The Right Men’s Wallet','Officia eveniet in dolores eos. Earum voluptas exercitationem dolores in expedita libero. Commodi et corporis nostrum voluptas sint architecto sapiente.','<p>She did not notice this last remark that had made the whole pack rose up into the sea, \'and in that ridiculous fashion.\' And he got up and down looking for the Dormouse,\' thought Alice; \'I can\'t go no lower,\' said the King: \'leave out that the best thing to get hold of this remark, and thought it would be like, \'--for they haven\'t got much evidence YET,\' she said to herself; \'his eyes are so VERY remarkable in that; nor did Alice think it was,\' he said. (Which he certainly did NOT, being made entirely of cardboard.) \'All right, so far,\' said the Hatter. \'You might just as well as she wandered about for it, he was in managing her flamingo: she succeeded in bringing herself down to her ear, and whispered \'She\'s under sentence of execution.\' \'What for?\' said Alice. \'Well, I never understood what it meant till now.\' \'If that\'s all the time at the righthand bit again, and made believe to worry it; then Alice put down the middle, wondering how she would catch a bad cold if she had peeped.</p><p class=\"text-center\"><img src=\"/storage/news/2.jpg\"></p><p>Mock Turtle: \'crumbs would all wash off in the middle of her knowledge. \'Just think of any one; so, when the Rabbit hastily interrupted. \'There\'s a great hurry, muttering to himself in an agony of terror. \'Oh, there goes his PRECIOUS nose\'; as an explanation; \'I\'ve none of them hit her in such confusion that she was shrinking rapidly; so she went back for a minute, while Alice thought she had someone to listen to her. The Cat seemed to have no idea what a Gryphon is, look at a king,\' said.</p><p class=\"text-center\"><img src=\"/storage/news/9.jpg\"></p><p>I shall fall right THROUGH the earth! How funny it\'ll seem to dry me at home! Why, I haven\'t been invited yet.\' \'You\'ll see me there,\' said the Caterpillar. Alice said to herself \'Now I can reach the key; and if I must, I must,\' the King sharply. \'Do you take me for a minute, nurse! But I\'ve got to the waving of the door and went in. The door led right into it. \'That\'s very important,\' the King sharply. \'Do you take me for asking! No, it\'ll never do to hold it. As soon as she did not appear, and after a few minutes that she hardly knew what she was surprised to see if there are, nobody attends to them--and you\'ve no idea how to speak first, \'why your cat grins like that?\' \'It\'s a friend of mine--a Cheshire Cat,\' said Alice: \'I don\'t know much,\' said the King in a great many more than nine feet high. \'I wish I hadn\'t begun my tea--not above a week or so--and what with the Queen left off, quite out of the lefthand bit. * * * * * CHAPTER II. The Pool of Tears \'Curiouser and curiouser!\'.</p><p class=\"text-center\"><img src=\"/storage/news/11.jpg\"></p><p>I shall remember it in the sea!\' cried the Gryphon, \'that they WOULD go with the bread-knife.\' The March Hare interrupted in a rather offended tone, and she walked down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go and take it away!\' There was a child,\' said the Caterpillar. Alice thought she might as well as she spoke. Alice did not like to have it explained,\' said the King: \'however, it may kiss my hand if it had grown up,\' she said these words her foot slipped, and in a sulky tone; \'Seven jogged my elbow.\' On which Seven looked up and rubbed its eyes: then it watched the Queen added to one of them were animals, and some \'unimportant.\' Alice could hardly hear the name \'Alice!\' CHAPTER XII. Alice\'s Evidence \'Here!\' cried Alice, jumping up in her hands, wondering if anything would EVER happen in a low, trembling voice. \'There\'s more evidence to come yet, please your Majesty?\' he asked. \'Begin at the Mouse\'s tail; \'but why do you know what to beautify is.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/15.jpg',1246,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58'),(5624,'Sexy Clutches: How to Buy &amp; Wear a Designer Clutch Bag','Perspiciatis modi et ea autem molestiae sit quam. Debitis qui et impedit dolore et assumenda repellat. Recusandae quaerat commodi cumque.','<p>[youtube-video]https://www.youtube.com/watch?v=SlPhMPnQ58k[/youtube-video]</p><p>I only knew how to spell \'stupid,\' and that makes people hot-tempered,\' she went to the seaside once in her life, and had to ask his neighbour to tell him. \'A nice muddle their slates\'ll be in before the trial\'s over!\' thought Alice. \'Now we shall have some fun now!\' thought Alice. \'I wonder what I say,\' the Mock Turtle. \'Hold your tongue!\' said the Mock Turtle in a very curious to see it trot away quietly into the sea, \'and in that ridiculous fashion.\' And he got up this morning, but I grow up, I\'ll write one--but I\'m grown up now,\' she added aloud. \'Do you mean by that?\' said the King, going up to them to be no doubt that it was growing, and she swam nearer to watch them, and he says it\'s so useful, it\'s worth a hundred pounds! He says it kills all the first day,\' said the Queen. \'Their heads are gone, if it makes me grow smaller, I suppose.\' So she went on again:-- \'You may not have lived much under the window, and one foot up the fan and gloves--that is, if I shall have somebody.</p><p class=\"text-center\"><img src=\"/storage/news/2.jpg\"></p><p>Caterpillar. \'Well, I\'ve tried hedges,\' the Pigeon in a low voice, \'Why the fact is, you ARE a simpleton.\' Alice did not quite like the look of the birds and beasts, as well go back, and see how he can thoroughly enjoy The pepper when he finds out who I am! But I\'d better take him his fan and gloves, and, as she could for sneezing. There was certainly not becoming. \'And that\'s the jury, who instantly made a rush at Alice the moment she quite forgot you didn\'t like cats.\' \'Not like cats!\' cried.</p><p class=\"text-center\"><img src=\"/storage/news/8.jpg\"></p><p>Alice; \'but when you come to the end of every line: \'Speak roughly to your little boy, And beat him when he sneezes; For he can thoroughly enjoy The pepper when he sneezes: He only does it to the jury. They were indeed a queer-looking party that assembled on the top of its mouth and yawned once or twice, and shook itself. Then it got down off the subjects on his flappers, \'--Mystery, ancient and modern, with Seaography: then Drawling--the Drawling-master was an old conger-eel, that used to come before that!\' \'Call the next moment she appeared on the ground near the looking-glass. There was exactly one a-piece all round. \'But she must have a prize herself, you know,\' Alice gently remarked; \'they\'d have been was not a mile high,\' said Alice. \'Of course not,\' said the Hatter. \'You might just as the large birds complained that they could not remember ever having seen in her pocket) till she had caught the baby joined):-- \'Wow! wow! wow!\' \'Here! you may nurse it a bit, if you please!.</p><p class=\"text-center\"><img src=\"/storage/news/13.jpg\"></p><p>Who ever saw in my size; and as it lasted.) \'Then the words all coming different, and then sat upon it.) \'I\'m glad they don\'t seem to dry me at home! Why, I wouldn\'t say anything about it, even if I would talk on such a thing I ask! It\'s always six o\'clock now.\' A bright idea came into her head. \'If I eat one of them didn\'t know it was quite a chorus of voices asked. \'Why, SHE, of course,\' said the Dodo. Then they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t seem to be\"--or if you\'d like it put the Dormouse say?\' one of them bowed low. \'Would you tell me,\' said Alice, surprised at this, but at the frontispiece if you cut your finger VERY deeply with a melancholy air, and, after waiting till she too began dreaming after a few minutes she heard a voice she had looked under it, and behind it, it occurred to her that she was not an encouraging tone. Alice looked all round her once more, while the Mouse had changed his mind, and was immediately suppressed by the.</p>','published',1,'Botble\\ACL\\Models\\User',0,'news/16.jpg',1461,NULL,'2025-04-29 17:14:58','2025-04-29 17:14:58');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_account_activity_logs`
--

DROP TABLE IF EXISTS `re_account_activity_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_account_activity_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `reference_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reference_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `account_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_account_activity_logs`
--

LOCK TABLES `re_account_activity_logs` WRITE;
/*!40000 ALTER TABLE `re_account_activity_logs` DISABLE KEYS */;
INSERT INTO `re_account_activity_logs` VALUES (1,'your_property_updated_by_admin','Mozilla/5.0 (Macintosh; Intel Mac OS X 11_2_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36','/account/properties/edit/7','Family Victorian \"View\" Home','::1','2021-01-12 01:02:59','2021-01-12 01:02:59',1),(2,'update_property','Mozilla/5.0 (Macintosh; Intel Mac OS X 11_2_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36','/account/properties/edit/7','Family Victorian \"View\" Home','::1','2021-01-12 01:02:59','2021-01-12 01:02:59',1),(3,'changed_avatar','Mozilla/5.0 (Macintosh; Intel Mac OS X 11_2_0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/87.0.4280.88 Safari/537.36','',NULL,'::1','2021-01-12 01:03:46','2021-01-12 01:03:46',1);
/*!40000 ALTER TABLE `re_account_activity_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_account_packages`
--

DROP TABLE IF EXISTS `re_account_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_account_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `package_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `account_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_account_packages`
--

LOCK TABLES `re_account_packages` WRITE;
/*!40000 ALTER TABLE `re_account_packages` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_account_packages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_account_password_resets`
--

DROP TABLE IF EXISTS `re_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_account_password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `vendor_password_resets_email_index` (`email`),
  KEY `vendor_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_account_password_resets`
--

LOCK TABLES `re_account_password_resets` WRITE;
/*!40000 ALTER TABLE `re_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_accounts`
--

DROP TABLE IF EXISTS `re_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `gender` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar_id` int unsigned DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `phone` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `credits` int unsigned DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `is_public_profile` tinyint(1) NOT NULL DEFAULT '1',
  `company` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` int unsigned DEFAULT NULL,
  `state_id` int unsigned DEFAULT NULL,
  `city_id` int unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `vendors_email_unique` (`email`),
  UNIQUE KEY `re_accounts_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_accounts`
--

LOCK TABLES `re_accounts` WRITE;
/*!40000 ALTER TABLE `re_accounts` DISABLE KEYS */;
INSERT INTO `re_accounts` VALUES (1,'Michelle','Yundt','So she began nibbling at the.',NULL,'john.smith@botble.com','jdavis','$2y$12$RbWCzuhf.sQSwVL4k2NdfefXcqZ7.bAAf5Vm4e74d4coKB/oqNR4G',59709,'2015-10-24','+14174556231','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:47','2025-04-29 17:14:47',10,0,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(2,'Bailee','Crona','Queen. \'I never could abide.',NULL,'agent@botble.com','jailynschneider','$2y$12$CFUNHGSbFZeSGfQZG8f0WOaLKH7tDFblpG.12C9pgsxQX91/nIvtm',59703,'1978-07-22','+12484217018','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:48','2025-04-29 17:14:51',10,1,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(3,'Alana','Hahn','Duchess; \'and most things.',NULL,'jpagac@gmail.com','cornell83','$2y$12$34kxuOJNxTFQfcokUNmyJ.Uy3q5XwVC9OE2181.vLq76OYW6B4csi',59708,'1993-04-24','+12677372447','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:48','2025-04-29 17:14:48',5,0,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(4,'Aleen','Koss','March Hare. \'Yes, please.',NULL,'vhalvorson@barrows.com','chyatt','$2y$12$HTpv6pc45IwKvgHm4yuPO.3TIJjxApy6AzSg2mHvlZPGx9Y7nd34C',59703,'1996-08-28','+13037038420','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:48','2025-04-29 17:14:51',6,1,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(5,'Alice','Torp','Knave \'Turn them over!\' The.',NULL,'demetrius88@schiller.net','ischinner','$2y$12$.a3e1ckv.OEFZrO08PmNT.Ho/fxN1a8Div9tweKhN1CDM0yO3NO6m',59707,'2020-06-24','+18137133719','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:49','2025-04-29 17:14:49',4,0,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(6,'Eliseo','Denesik','THAT. Then again--\"BEFORE.',NULL,'yaufderhar@yahoo.com','devenromaguera','$2y$12$Qfn3tB0gG.ggLLl4OEQ4ue.YKZv7AEHF5nWrqOOAj0CEIcXuZHKnW',59706,'2005-06-03','+15635589152','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:49','2025-04-29 17:14:51',9,1,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(7,'Buster','Boehm','Alice thought this must be.',NULL,'nat19@friesen.com','econnelly','$2y$12$TPSdPMdqBHaqJqsV6bpEpuHVkhr9gJyp0ASjRQZRWmOUwbnJnUr72',59708,'1991-12-23','+14437909122','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:49','2025-04-29 17:14:49',9,0,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(8,'Frederic','Nikolaus','Alice more boldly: \'you know.',NULL,'morissette.myah@yahoo.com','ohettinger','$2y$12$tNjcM.zRnnSHvAW52JImEOIRG70gSkEWnTjM64SQRmkcSdg1iEaB6',59702,'1972-08-03','+12798502021','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:50','2025-04-29 17:14:51',3,1,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(9,'Devyn','Gerlach','Alice thought), and it sat.',NULL,'hkshlerin@tillman.com','heavendoyle','$2y$12$NcwNnlYQYH9JXk2sOKORyulhfhkDa71kORuEFGhWpCj8NhLMW6Q5S',59703,'1972-11-27','+16786818596','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:50','2025-04-29 17:14:50',9,0,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(10,'Jeanette','Kling','Queen. \'It proves nothing of.',NULL,'heidenreich.roslyn@steuber.com','eturcotte','$2y$12$bQGF5WurociG1zMk9vjORui1boFuF.1b8dBSr7C8UvXbM1FJLOC7W',59704,'1976-04-21','+19208865592','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:50','2025-04-29 17:14:51',3,1,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(11,'Nedra','Medhurst','Some of the crowd below, and.',NULL,'leonard.goyette@lehner.com','michele86','$2y$12$LCEGtArRpZsnRj.KF65hmu3QmrlIafv10GgU..1UI2cKkDOLKAHR6',59710,'1976-12-27','+13616568622','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:51','2025-04-29 17:14:51',5,0,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47'),(12,'Fredrick','Ondricka','Down, down, down. There was.',NULL,'gorczany.geraldine@rath.com','christine58','$2y$12$Jm.da/KqIOKE4L2JnQ0/FevSnAl1XFghEhfl494S4OeaxqWWdsK5i',59702,'2013-11-01','+15178632063','2025-04-30 00:14:47',NULL,NULL,'2025-04-29 17:14:51','2025-04-29 17:14:51',3,1,1,NULL,NULL,NULL,NULL,'2025-04-30 00:14:47');
/*!40000 ALTER TABLE `re_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_accounts_translations`
--

DROP TABLE IF EXISTS `re_accounts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_accounts_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_accounts_id` bigint unsigned NOT NULL,
  `first_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_accounts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_accounts_translations`
--

LOCK TABLES `re_accounts_translations` WRITE;
/*!40000 ALTER TABLE `re_accounts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_accounts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_categories`
--

DROP TABLE IF EXISTS `re_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_categories` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_categories`
--

LOCK TABLES `re_categories` WRITE;
/*!40000 ALTER TABLE `re_categories` DISABLE KEYS */;
INSERT INTO `re_categories` VALUES (1,'Apartment',NULL,'published',0,1,'2025-04-29 17:14:45','2025-04-29 17:14:45',0),(2,'Villa',NULL,'published',1,0,'2025-04-29 17:14:45','2025-04-29 17:14:45',0),(3,'Condo',NULL,'published',2,0,'2025-04-29 17:14:45','2025-04-29 17:14:45',0),(4,'House',NULL,'published',3,0,'2025-04-29 17:14:45','2025-04-29 17:14:45',0),(5,'Land',NULL,'published',4,0,'2025-04-29 17:14:45','2025-04-29 17:14:45',0),(6,'Commercial property',NULL,'published',5,0,'2025-04-29 17:14:45','2025-04-29 17:14:45',0);
/*!40000 ALTER TABLE `re_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_categories_translations`
--

DROP TABLE IF EXISTS `re_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_categories_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_categories_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_categories_translations`
--

LOCK TABLES `re_categories_translations` WRITE;
/*!40000 ALTER TABLE `re_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_consult_custom_field_options`
--

DROP TABLE IF EXISTS `re_consult_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_consult_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_consult_custom_field_options`
--

LOCK TABLES `re_consult_custom_field_options` WRITE;
/*!40000 ALTER TABLE `re_consult_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_consult_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_consult_custom_field_options_translations`
--

DROP TABLE IF EXISTS `re_consult_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_consult_custom_field_options_translations` (
  `re_consult_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_consult_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_consult_custom_field_options_translations`
--

LOCK TABLES `re_consult_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `re_consult_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_consult_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_consult_custom_fields`
--

DROP TABLE IF EXISTS `re_consult_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_consult_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_consult_custom_fields`
--

LOCK TABLES `re_consult_custom_fields` WRITE;
/*!40000 ALTER TABLE `re_consult_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_consult_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_consult_custom_fields_translations`
--

DROP TABLE IF EXISTS `re_consult_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_consult_custom_fields_translations` (
  `re_consult_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_consult_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_consult_custom_fields_translations`
--

LOCK TABLES `re_consult_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `re_consult_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_consult_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_consults`
--

DROP TABLE IF EXISTS `re_consults`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_consults` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `project_id` int unsigned DEFAULT NULL,
  `property_id` int unsigned DEFAULT NULL,
  `ip_address` varchar(39) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `custom_fields` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_consults`
--

LOCK TABLES `re_consults` WRITE;
/*!40000 ALTER TABLE `re_consults` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_consults` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_coupons`
--

DROP TABLE IF EXISTS `re_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `re_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_coupons`
--

LOCK TABLES `re_coupons` WRITE;
/*!40000 ALTER TABLE `re_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_currencies`
--

DROP TABLE IF EXISTS `re_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_currencies` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_currencies`
--

LOCK TABLES `re_currencies` WRITE;
/*!40000 ALTER TABLE `re_currencies` DISABLE KEYS */;
INSERT INTO `re_currencies` VALUES (1,'USD','$',1,0,0,1,1,'2025-04-29 17:14:45','2025-04-29 17:14:45'),(2,'EUR','€',0,0,1,0,0.91,'2025-04-29 17:14:45','2025-04-29 17:14:45'),(3,'VND','₫',0,0,2,0,23717.5,'2025-04-29 17:14:45','2025-04-29 17:14:45');
/*!40000 ALTER TABLE `re_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_custom_field_options`
--

DROP TABLE IF EXISTS `re_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int unsigned NOT NULL,
  `label` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_custom_field_options`
--

LOCK TABLES `re_custom_field_options` WRITE;
/*!40000 ALTER TABLE `re_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_custom_field_options_translations`
--

DROP TABLE IF EXISTS `re_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_custom_field_options_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_custom_field_options_id` int NOT NULL,
  `label` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_custom_field_options_translations`
--

LOCK TABLES `re_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `re_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_custom_field_values`
--

DROP TABLE IF EXISTS `re_custom_field_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_custom_field_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `custom_field_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `re_custom_field_values_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_custom_field_values`
--

LOCK TABLES `re_custom_field_values` WRITE;
/*!40000 ALTER TABLE `re_custom_field_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_custom_field_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_custom_field_values_translations`
--

DROP TABLE IF EXISTS `re_custom_field_values_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_custom_field_values_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_custom_field_values_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_custom_field_values_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_custom_field_values_translations`
--

LOCK TABLES `re_custom_field_values_translations` WRITE;
/*!40000 ALTER TABLE `re_custom_field_values_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_custom_field_values_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_custom_fields`
--

DROP TABLE IF EXISTS `re_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `is_global` tinyint(1) NOT NULL DEFAULT '0',
  `authorable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `authorable_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `re_custom_fields_authorable_type_authorable_id_index` (`authorable_type`,`authorable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_custom_fields`
--

LOCK TABLES `re_custom_fields` WRITE;
/*!40000 ALTER TABLE `re_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_custom_fields_translations`
--

DROP TABLE IF EXISTS `re_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_custom_fields_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_custom_fields_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_custom_fields_translations`
--

LOCK TABLES `re_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `re_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_facilities`
--

DROP TABLE IF EXISTS `re_facilities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_facilities` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_facilities`
--

LOCK TABLES `re_facilities` WRITE;
/*!40000 ALTER TABLE `re_facilities` DISABLE KEYS */;
INSERT INTO `re_facilities` VALUES (1,'Hospital','far fa-hospital','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(2,'Super Market','fas fa-cart-plus','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(3,'School','fas fa-school','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(4,'Entertainment','fas fa-hotel','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(5,'Pharmacy','fas fa-prescription-bottle-alt','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(6,'Airport','fas fa-plane-departure','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(7,'Railways','fas fa-subway','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(8,'Bus Stop','fas fa-bus','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(9,'Beach','fas fa-umbrella-beach','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(10,'Mall','fas fa-cart-plus','published','2025-04-29 17:14:45','2025-04-29 17:14:45'),(11,'Bank','fas fa-university','published','2025-04-29 17:14:45','2025-04-29 17:14:45');
/*!40000 ALTER TABLE `re_facilities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_facilities_distances`
--

DROP TABLE IF EXISTS `re_facilities_distances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_facilities_distances` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `facility_id` int unsigned NOT NULL,
  `reference_id` int unsigned NOT NULL,
  `reference_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `distance` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_facilities_distances`
--

LOCK TABLES `re_facilities_distances` WRITE;
/*!40000 ALTER TABLE `re_facilities_distances` DISABLE KEYS */;
INSERT INTO `re_facilities_distances` VALUES (1,1,1,'Botble\\RealEstate\\Models\\Property','17km'),(2,2,1,'Botble\\RealEstate\\Models\\Property','17km'),(3,3,1,'Botble\\RealEstate\\Models\\Property','5km'),(4,4,1,'Botble\\RealEstate\\Models\\Property','15km'),(5,5,1,'Botble\\RealEstate\\Models\\Property','6km'),(6,6,1,'Botble\\RealEstate\\Models\\Property','1km'),(7,7,1,'Botble\\RealEstate\\Models\\Property','10km'),(8,8,1,'Botble\\RealEstate\\Models\\Property','10km'),(9,9,1,'Botble\\RealEstate\\Models\\Property','7km'),(10,10,1,'Botble\\RealEstate\\Models\\Property','3km'),(11,11,1,'Botble\\RealEstate\\Models\\Property','14km'),(12,1,2,'Botble\\RealEstate\\Models\\Property','18km'),(13,2,2,'Botble\\RealEstate\\Models\\Property','12km'),(14,3,2,'Botble\\RealEstate\\Models\\Property','8km'),(15,4,2,'Botble\\RealEstate\\Models\\Property','14km'),(16,5,2,'Botble\\RealEstate\\Models\\Property','6km'),(17,6,2,'Botble\\RealEstate\\Models\\Property','2km'),(18,7,2,'Botble\\RealEstate\\Models\\Property','2km'),(19,8,2,'Botble\\RealEstate\\Models\\Property','11km'),(20,9,2,'Botble\\RealEstate\\Models\\Property','11km'),(21,10,2,'Botble\\RealEstate\\Models\\Property','14km'),(22,11,2,'Botble\\RealEstate\\Models\\Property','5km'),(23,1,3,'Botble\\RealEstate\\Models\\Property','6km'),(24,2,3,'Botble\\RealEstate\\Models\\Property','12km'),(25,3,3,'Botble\\RealEstate\\Models\\Property','6km'),(26,4,3,'Botble\\RealEstate\\Models\\Property','12km'),(27,5,3,'Botble\\RealEstate\\Models\\Property','7km'),(28,6,3,'Botble\\RealEstate\\Models\\Property','5km'),(29,7,3,'Botble\\RealEstate\\Models\\Property','14km'),(30,8,3,'Botble\\RealEstate\\Models\\Property','9km'),(31,9,3,'Botble\\RealEstate\\Models\\Property','13km'),(32,10,3,'Botble\\RealEstate\\Models\\Property','15km'),(33,11,3,'Botble\\RealEstate\\Models\\Property','20km'),(34,1,4,'Botble\\RealEstate\\Models\\Property','9km'),(35,2,4,'Botble\\RealEstate\\Models\\Property','3km'),(36,3,4,'Botble\\RealEstate\\Models\\Property','18km'),(37,4,4,'Botble\\RealEstate\\Models\\Property','19km'),(38,5,4,'Botble\\RealEstate\\Models\\Property','6km'),(39,6,4,'Botble\\RealEstate\\Models\\Property','15km'),(40,7,4,'Botble\\RealEstate\\Models\\Property','5km'),(41,8,4,'Botble\\RealEstate\\Models\\Property','1km'),(42,9,4,'Botble\\RealEstate\\Models\\Property','12km'),(43,10,4,'Botble\\RealEstate\\Models\\Property','14km'),(44,11,4,'Botble\\RealEstate\\Models\\Property','2km'),(45,1,5,'Botble\\RealEstate\\Models\\Property','14km'),(46,2,5,'Botble\\RealEstate\\Models\\Property','6km'),(47,3,5,'Botble\\RealEstate\\Models\\Property','14km'),(48,4,5,'Botble\\RealEstate\\Models\\Property','7km'),(49,5,5,'Botble\\RealEstate\\Models\\Property','3km'),(50,6,5,'Botble\\RealEstate\\Models\\Property','1km'),(51,7,5,'Botble\\RealEstate\\Models\\Property','14km'),(52,8,5,'Botble\\RealEstate\\Models\\Property','18km'),(53,9,5,'Botble\\RealEstate\\Models\\Property','20km'),(54,10,5,'Botble\\RealEstate\\Models\\Property','10km'),(55,11,5,'Botble\\RealEstate\\Models\\Property','20km'),(56,1,6,'Botble\\RealEstate\\Models\\Property','7km'),(57,2,6,'Botble\\RealEstate\\Models\\Property','7km'),(58,3,6,'Botble\\RealEstate\\Models\\Property','7km'),(59,4,6,'Botble\\RealEstate\\Models\\Property','10km'),(60,5,6,'Botble\\RealEstate\\Models\\Property','16km'),(61,6,6,'Botble\\RealEstate\\Models\\Property','1km'),(62,7,6,'Botble\\RealEstate\\Models\\Property','2km'),(63,8,6,'Botble\\RealEstate\\Models\\Property','1km'),(64,9,6,'Botble\\RealEstate\\Models\\Property','7km'),(65,10,6,'Botble\\RealEstate\\Models\\Property','7km'),(66,11,6,'Botble\\RealEstate\\Models\\Property','14km'),(67,1,7,'Botble\\RealEstate\\Models\\Property','12km'),(68,2,7,'Botble\\RealEstate\\Models\\Property','11km'),(69,3,7,'Botble\\RealEstate\\Models\\Property','7km'),(70,4,7,'Botble\\RealEstate\\Models\\Property','1km'),(71,5,7,'Botble\\RealEstate\\Models\\Property','12km'),(72,6,7,'Botble\\RealEstate\\Models\\Property','12km'),(73,7,7,'Botble\\RealEstate\\Models\\Property','15km'),(74,8,7,'Botble\\RealEstate\\Models\\Property','13km'),(75,9,7,'Botble\\RealEstate\\Models\\Property','19km'),(76,10,7,'Botble\\RealEstate\\Models\\Property','5km'),(77,11,7,'Botble\\RealEstate\\Models\\Property','12km'),(78,1,8,'Botble\\RealEstate\\Models\\Property','16km'),(79,2,8,'Botble\\RealEstate\\Models\\Property','9km'),(80,3,8,'Botble\\RealEstate\\Models\\Property','16km'),(81,4,8,'Botble\\RealEstate\\Models\\Property','9km'),(82,5,8,'Botble\\RealEstate\\Models\\Property','8km'),(83,6,8,'Botble\\RealEstate\\Models\\Property','12km'),(84,7,8,'Botble\\RealEstate\\Models\\Property','7km'),(85,8,8,'Botble\\RealEstate\\Models\\Property','10km'),(86,9,8,'Botble\\RealEstate\\Models\\Property','20km'),(87,10,8,'Botble\\RealEstate\\Models\\Property','4km'),(88,11,8,'Botble\\RealEstate\\Models\\Property','4km'),(89,1,9,'Botble\\RealEstate\\Models\\Property','14km'),(90,2,9,'Botble\\RealEstate\\Models\\Property','18km'),(91,3,9,'Botble\\RealEstate\\Models\\Property','13km'),(92,4,9,'Botble\\RealEstate\\Models\\Property','18km'),(93,5,9,'Botble\\RealEstate\\Models\\Property','12km'),(94,6,9,'Botble\\RealEstate\\Models\\Property','15km'),(95,7,9,'Botble\\RealEstate\\Models\\Property','6km'),(96,8,9,'Botble\\RealEstate\\Models\\Property','13km'),(97,9,9,'Botble\\RealEstate\\Models\\Property','20km'),(98,10,9,'Botble\\RealEstate\\Models\\Property','3km'),(99,11,9,'Botble\\RealEstate\\Models\\Property','8km'),(100,1,10,'Botble\\RealEstate\\Models\\Property','18km'),(101,2,10,'Botble\\RealEstate\\Models\\Property','11km'),(102,3,10,'Botble\\RealEstate\\Models\\Property','3km'),(103,4,10,'Botble\\RealEstate\\Models\\Property','17km'),(104,5,10,'Botble\\RealEstate\\Models\\Property','17km'),(105,6,10,'Botble\\RealEstate\\Models\\Property','2km'),(106,7,10,'Botble\\RealEstate\\Models\\Property','7km'),(107,8,10,'Botble\\RealEstate\\Models\\Property','11km'),(108,9,10,'Botble\\RealEstate\\Models\\Property','9km'),(109,10,10,'Botble\\RealEstate\\Models\\Property','6km'),(110,11,10,'Botble\\RealEstate\\Models\\Property','14km'),(111,1,11,'Botble\\RealEstate\\Models\\Property','19km'),(112,2,11,'Botble\\RealEstate\\Models\\Property','20km'),(113,3,11,'Botble\\RealEstate\\Models\\Property','14km'),(114,4,11,'Botble\\RealEstate\\Models\\Property','3km'),(115,5,11,'Botble\\RealEstate\\Models\\Property','11km'),(116,6,11,'Botble\\RealEstate\\Models\\Property','5km'),(117,7,11,'Botble\\RealEstate\\Models\\Property','9km'),(118,8,11,'Botble\\RealEstate\\Models\\Property','10km'),(119,9,11,'Botble\\RealEstate\\Models\\Property','14km'),(120,10,11,'Botble\\RealEstate\\Models\\Property','8km'),(121,11,11,'Botble\\RealEstate\\Models\\Property','9km'),(122,1,12,'Botble\\RealEstate\\Models\\Property','8km'),(123,2,12,'Botble\\RealEstate\\Models\\Property','16km'),(124,3,12,'Botble\\RealEstate\\Models\\Property','10km'),(125,4,12,'Botble\\RealEstate\\Models\\Property','13km'),(126,5,12,'Botble\\RealEstate\\Models\\Property','19km'),(127,6,12,'Botble\\RealEstate\\Models\\Property','19km'),(128,7,12,'Botble\\RealEstate\\Models\\Property','18km'),(129,8,12,'Botble\\RealEstate\\Models\\Property','13km'),(130,9,12,'Botble\\RealEstate\\Models\\Property','17km'),(131,10,12,'Botble\\RealEstate\\Models\\Property','14km'),(132,11,12,'Botble\\RealEstate\\Models\\Property','2km'),(133,1,13,'Botble\\RealEstate\\Models\\Property','12km'),(134,2,13,'Botble\\RealEstate\\Models\\Property','7km'),(135,3,13,'Botble\\RealEstate\\Models\\Property','11km'),(136,4,13,'Botble\\RealEstate\\Models\\Property','6km'),(137,5,13,'Botble\\RealEstate\\Models\\Property','18km'),(138,6,13,'Botble\\RealEstate\\Models\\Property','16km'),(139,7,13,'Botble\\RealEstate\\Models\\Property','8km'),(140,8,13,'Botble\\RealEstate\\Models\\Property','6km'),(141,9,13,'Botble\\RealEstate\\Models\\Property','18km'),(142,10,13,'Botble\\RealEstate\\Models\\Property','14km'),(143,11,13,'Botble\\RealEstate\\Models\\Property','14km'),(144,1,14,'Botble\\RealEstate\\Models\\Property','8km'),(145,2,14,'Botble\\RealEstate\\Models\\Property','6km'),(146,3,14,'Botble\\RealEstate\\Models\\Property','19km'),(147,4,14,'Botble\\RealEstate\\Models\\Property','10km'),(148,5,14,'Botble\\RealEstate\\Models\\Property','7km'),(149,6,14,'Botble\\RealEstate\\Models\\Property','20km'),(150,7,14,'Botble\\RealEstate\\Models\\Property','8km'),(151,8,14,'Botble\\RealEstate\\Models\\Property','1km'),(152,9,14,'Botble\\RealEstate\\Models\\Property','18km'),(153,10,14,'Botble\\RealEstate\\Models\\Property','20km'),(154,11,14,'Botble\\RealEstate\\Models\\Property','4km'),(155,1,15,'Botble\\RealEstate\\Models\\Property','14km'),(156,2,15,'Botble\\RealEstate\\Models\\Property','9km'),(157,3,15,'Botble\\RealEstate\\Models\\Property','1km'),(158,4,15,'Botble\\RealEstate\\Models\\Property','4km'),(159,5,15,'Botble\\RealEstate\\Models\\Property','10km'),(160,6,15,'Botble\\RealEstate\\Models\\Property','20km'),(161,7,15,'Botble\\RealEstate\\Models\\Property','20km'),(162,8,15,'Botble\\RealEstate\\Models\\Property','1km'),(163,9,15,'Botble\\RealEstate\\Models\\Property','16km'),(164,10,15,'Botble\\RealEstate\\Models\\Property','2km'),(165,11,15,'Botble\\RealEstate\\Models\\Property','2km'),(166,1,16,'Botble\\RealEstate\\Models\\Property','10km'),(167,2,16,'Botble\\RealEstate\\Models\\Property','19km'),(168,3,16,'Botble\\RealEstate\\Models\\Property','9km'),(169,4,16,'Botble\\RealEstate\\Models\\Property','6km'),(170,5,16,'Botble\\RealEstate\\Models\\Property','14km'),(171,6,16,'Botble\\RealEstate\\Models\\Property','14km'),(172,7,16,'Botble\\RealEstate\\Models\\Property','15km'),(173,8,16,'Botble\\RealEstate\\Models\\Property','18km'),(174,9,16,'Botble\\RealEstate\\Models\\Property','15km'),(175,10,16,'Botble\\RealEstate\\Models\\Property','16km'),(176,11,16,'Botble\\RealEstate\\Models\\Property','12km'),(177,1,17,'Botble\\RealEstate\\Models\\Property','8km'),(178,2,17,'Botble\\RealEstate\\Models\\Property','1km'),(179,3,17,'Botble\\RealEstate\\Models\\Property','6km'),(180,4,17,'Botble\\RealEstate\\Models\\Property','9km'),(181,5,17,'Botble\\RealEstate\\Models\\Property','1km'),(182,6,17,'Botble\\RealEstate\\Models\\Property','12km'),(183,7,17,'Botble\\RealEstate\\Models\\Property','15km'),(184,8,17,'Botble\\RealEstate\\Models\\Property','2km'),(185,9,17,'Botble\\RealEstate\\Models\\Property','15km'),(186,10,17,'Botble\\RealEstate\\Models\\Property','19km'),(187,11,17,'Botble\\RealEstate\\Models\\Property','20km');
/*!40000 ALTER TABLE `re_facilities_distances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_facilities_translations`
--

DROP TABLE IF EXISTS `re_facilities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_facilities_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_facilities_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_facilities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_facilities_translations`
--

LOCK TABLES `re_facilities_translations` WRITE;
/*!40000 ALTER TABLE `re_facilities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_facilities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_features`
--

DROP TABLE IF EXISTS `re_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_features` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `icon` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_features`
--

LOCK TABLES `re_features` WRITE;
/*!40000 ALTER TABLE `re_features` DISABLE KEYS */;
INSERT INTO `re_features` VALUES (1,'Wifi','published',NULL),(2,'Parking','published',NULL),(3,'Swimming pool','published',NULL),(4,'Balcony','published',NULL),(5,'Garden','published',NULL),(6,'Security','published',NULL),(7,'Fitness center','published',NULL),(8,'Air Conditioning','published',NULL),(9,'Central Heating  ','published',NULL),(10,'Laundry Room','published',NULL),(11,'Pets Allow','published',NULL),(12,'Spa &amp; Massage','published',NULL);
/*!40000 ALTER TABLE `re_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_features_translations`
--

DROP TABLE IF EXISTS `re_features_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_features_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_features_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_features_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_features_translations`
--

LOCK TABLES `re_features_translations` WRITE;
/*!40000 ALTER TABLE `re_features_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_features_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_investors`
--

DROP TABLE IF EXISTS `re_investors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_investors` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_investors`
--

LOCK TABLES `re_investors` WRITE;
/*!40000 ALTER TABLE `re_investors` DISABLE KEYS */;
INSERT INTO `re_investors` VALUES (1,'National Pension Service','published','2019-11-18 01:16:23','2019-11-18 01:16:23',NULL,NULL),(2,'Generali','published','2019-11-18 01:16:47','2019-11-18 01:16:47',NULL,NULL),(3,'Temasek','published','2019-11-18 01:16:57','2019-11-18 01:16:57',NULL,NULL),(4,'China Investment Corporation','published','2019-11-18 01:17:11','2019-11-18 01:17:11',NULL,NULL),(5,'Government Pension Fund Global','published','2019-11-18 01:17:35','2019-11-18 01:17:35',NULL,NULL),(6,'PSP Investments','published','2019-11-18 01:17:47','2019-11-18 01:17:47',NULL,NULL),(7,'MEAG Munich ERGO','published','2019-11-18 01:17:57','2019-11-18 01:17:57',NULL,NULL),(8,'HOOPP','published','2019-11-18 01:18:08','2019-11-18 01:18:08',NULL,NULL),(9,'BT Group','published','2019-11-18 01:18:21','2019-11-18 01:18:21',NULL,NULL),(10,'Ping An','published','2019-11-18 01:18:32','2019-11-18 01:18:32',NULL,NULL),(11,'New Jersey Division of Investment','published','2019-11-18 01:18:45','2019-11-18 01:18:45',NULL,NULL),(12,'New York City ERS','published','2019-11-18 01:18:57','2019-11-18 01:18:57',NULL,NULL),(13,'State Super','published','2019-11-18 01:19:10','2019-11-18 01:19:10',NULL,NULL),(14,'Shinkong','published','2019-11-18 01:19:20','2019-11-18 01:19:20',NULL,NULL),(15,'Rest Super','published','2019-11-18 01:19:31','2019-11-18 01:19:31',NULL,NULL),(16,'Rest Super','published','2019-11-21 01:50:47','2019-11-21 01:50:47',NULL,NULL),(17,'Shinkong','published','2019-11-21 01:51:03','2019-11-21 01:51:03',NULL,NULL),(18,'State Super','published','2019-11-21 01:51:21','2019-11-21 01:51:21',NULL,NULL),(19,'New York City ERS','published','2019-11-21 01:51:33','2019-11-21 01:51:33',NULL,NULL),(20,'New Jersey Division of Investment','published','2019-11-21 01:51:51','2019-11-21 01:51:51',NULL,NULL),(21,'Ping An','published','2019-11-21 01:52:04','2019-11-21 01:52:04',NULL,NULL),(22,'BT Group','published','2019-11-21 01:52:16','2019-11-21 01:52:16',NULL,NULL),(23,'HOOPP','published','2019-11-21 01:52:28','2019-11-21 01:52:28',NULL,NULL),(24,'MEAG Munich ERGO','published','2019-11-21 01:52:47','2019-11-21 01:52:47',NULL,NULL),(25,'PSP Investments','published','2019-11-21 01:52:57','2019-11-21 01:52:57',NULL,NULL),(26,'Government Pension Fund Global','published','2019-11-21 01:53:18','2019-11-21 01:53:18',NULL,NULL),(27,'China Investment Corporation','published','2019-11-21 01:53:33','2019-11-21 01:53:33',NULL,NULL),(29,'Temasek','published','2019-11-21 01:53:48','2019-11-21 01:53:48',NULL,NULL),(30,'Generali','published','2019-11-21 01:54:01','2019-11-21 01:54:01',NULL,NULL),(31,'National Pension Service','published','2019-11-21 01:54:14','2019-11-21 01:54:14',NULL,NULL);
/*!40000 ALTER TABLE `re_investors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_investors_translations`
--

DROP TABLE IF EXISTS `re_investors_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_investors_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_investors_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`re_investors_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_investors_translations`
--

LOCK TABLES `re_investors_translations` WRITE;
/*!40000 ALTER TABLE `re_investors_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_investors_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_invoice_items`
--

DROP TABLE IF EXISTS `re_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int unsigned NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `amount` decimal(15,2) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_invoice_items`
--

LOCK TABLES `re_invoice_items` WRITE;
/*!40000 ALTER TABLE `re_invoice_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_invoices`
--

DROP TABLE IF EXISTS `re_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int unsigned NOT NULL,
  `payment_id` int unsigned DEFAULT NULL,
  `reference_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_total` decimal(15,2) unsigned NOT NULL,
  `tax_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) unsigned NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `status` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `re_invoices_code_unique` (`code`),
  KEY `re_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `re_invoices_payment_id_index` (`payment_id`),
  KEY `re_invoices_status_index` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_invoices`
--

LOCK TABLES `re_invoices` WRITE;
/*!40000 ALTER TABLE `re_invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_packages`
--

DROP TABLE IF EXISTS `re_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_packages` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` double(15,2) unsigned NOT NULL,
  `currency_id` int unsigned NOT NULL,
  `number_of_listings` int unsigned NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `percent_save` int unsigned NOT NULL DEFAULT '0',
  `account_limit` int unsigned DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `features` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_packages`
--

LOCK TABLES `re_packages` WRITE;
/*!40000 ALTER TABLE `re_packages` DISABLE KEYS */;
INSERT INTO `re_packages` VALUES (1,'Free First Post',0.00,1,1,0,0,'published','2025-04-29 17:14:46','2025-04-29 17:14:46',0,1,NULL,NULL),(2,'Single Post',250.00,1,1,0,1,'published','2025-04-29 17:14:46','2025-04-29 17:14:46',0,NULL,NULL,NULL),(3,'5 Posts',1000.00,1,5,0,0,'published','2025-04-29 17:14:46','2025-04-29 17:14:46',20,NULL,NULL,NULL);
/*!40000 ALTER TABLE `re_packages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_packages_translations`
--

DROP TABLE IF EXISTS `re_packages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_packages_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_packages_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `features` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`re_packages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_packages_translations`
--

LOCK TABLES `re_packages_translations` WRITE;
/*!40000 ALTER TABLE `re_packages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_packages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_project_categories`
--

DROP TABLE IF EXISTS `re_project_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_project_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `project_id` int unsigned NOT NULL,
  `category_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1793 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_project_categories`
--

LOCK TABLES `re_project_categories` WRITE;
/*!40000 ALTER TABLE `re_project_categories` DISABLE KEYS */;
INSERT INTO `re_project_categories` VALUES (1780,2,6),(1788,1,2),(1789,3,6),(1790,4,1),(1791,5,6),(1792,6,6);
/*!40000 ALTER TABLE `re_project_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_project_features`
--

DROP TABLE IF EXISTS `re_project_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_project_features` (
  `project_id` int unsigned NOT NULL,
  `feature_id` int unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_project_features`
--

LOCK TABLES `re_project_features` WRITE;
/*!40000 ALTER TABLE `re_project_features` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_project_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_projects`
--

DROP TABLE IF EXISTS `re_projects`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_projects` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `number_block` smallint unsigned DEFAULT NULL,
  `number_floor` smallint DEFAULT NULL,
  `number_flat` smallint DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_priority` int DEFAULT '0',
  `date_finish` date DEFAULT NULL,
  `date_sell` date DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'selling',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `investor_id` bigint unsigned DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_from` decimal(15,0) DEFAULT NULL,
  `price_to` decimal(15,0) DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `city_id` int unsigned DEFAULT NULL,
  `author_id` int DEFAULT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `latitude` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `country_id` int unsigned DEFAULT '1',
  `state_id` int unsigned DEFAULT NULL,
  `unique_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `re_projects_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_projects`
--

LOCK TABLES `re_projects` WRITE;
/*!40000 ALTER TABLE `re_projects` DISABLE KEYS */;
INSERT INTO `re_projects` VALUES (1,'Walnut Park Apartments','<p>Now Open &amp; Leasing!</p>\r\n\r\n<p>Walnut Park is conveniently located on North Lamar Boulevard across from the 293-acre Walnut Creek Metropolitan Park and just south of Yager Lane near numerous shops and restaurants. Only 11 miles from downtown Austin, the heavily-wooded site borders Walnut Creek and offers residents inspiring views in an unparalleled, secluded community. In addition to resort spa amenities, the interiors are built and designed to condominium specifications with energy efficient features, stunning detail and upgraded finishes.</p>','[\"projects\\/1.jpg\",\"projects\\/5.jpg\",\"projects\\/3.jpg\",\"projects\\/2.jpg\"]','Austin, Texas 78753, USA',4,2,50,1,0,'2019-11-10','2019-03-11','selling','2019-11-18 00:34:49','2021-04-29 20:46:31',12,'Walnut Park is conveniently located on North Lamar Boulevard across from the 293-acre Walnut Creek Metropolitan Park and just south of Yager Lane near numerous shops and restaurants. Only 11 miles from downtown Austin, the heavily-wooded site borders Walnut Creek and offers residents inspiring views in an unparalleled, secluded community',NULL,NULL,1,4,NULL,'Botble\\ACL\\Models\\User','43.578848','-76.32197',8554,1,1,NULL,NULL),(2,'Osaka Heights','<p>Osaka Heights is a state of the art apartment crafted with elegance, comfort and classiness.</p>\r\n\r\n<p>The grander apartments add new heights to the life of people in Colombo, Sri Lanka.</p>\r\n\r\n<p>Devised by a team of international consultants, Osaka Heights is all about contemporary design and comprehensive attention to detail in execution. If you are interested to own a luxury apartment at Sri Lanka, Osaka Heights is the best choice. The foundation of Osaka Heights is laid by skilled professionals, who capture your vision completely. The construction is built as per your elegant lifestyles, without any compromise in quality and class.</p>\r\n\r\n<p>The homes come with all comfy amenities and facilities for a superior life. From the panoramic views, the rooftop swimming pool and the landscaped eco-balconies, beauty meets you at every step in Osaka Heights. Made for an exclusive few, Osaka Heights gives you the advantage of sharing a space with like-minded individuals. An elevated lifestyle naturally follows, making Osaka Heights one of the most sought-after addresses in Colombo.</p>','[\"projects\\/21.jpg\",\"projects\\/24.jpg\",\"projects\\/23.jpg\",\"projects\\/25.jpg\",\"projects\\/26.jpg\",\"projects\\/22.jpg\"]','Kirulapone, Colombo 06, Colombo, Sri Lanka',1,15,450,1,0,'2019-08-09','2019-08-10','selling','2019-11-18 01:28:45','2021-06-11 20:56:44',3,'The homes come with all comfy amenities and facilities for a superior life. From the panoramic views, the rooftop swimming pool and the landscaped eco-balconies, beauty meets you at every step in Osaka Heights. Made for an exclusive few, Osaka Heights gives you the advantage of sharing a space with like-minded individuals.',NULL,NULL,1,3,NULL,'Botble\\ACL\\Models\\User','43.013638','-75.848066',174,1,1,NULL,NULL),(3,'Mimaroba Paradise','<h2><b>Why you should buy a house from this project?</b></h2>\r\n\r\n<ul>\r\n	<li>1. A summerhouse in the center of the city.</li>\r\n	<li>2. Remove the boundaries between you and the sea, you will be surrounded by blue sea.</li>\r\n	<li>3.&nbsp;Everything you have imagined - from infinity pool, zen garden, gourmet restaurant to thematic playgrounds awaiting you.</li>\r\n	<li>4.&nbsp;A unique design that makes luxury a habit, a wide variety of apartment plan options.</li>\r\n	<li>5.&nbsp;Reasonable payment options, affordable prices in Istanbul&#39;s most exclusive area.</li>\r\n</ul>\r\n\r\n<p>&lsquo;&rsquo; Mimaroba&rsquo;&rsquo; a modern beach district away from the bustle of Istanbul.&nbsp;The aim of the project is to make a living feel for the hosts in the deepest way.&nbsp;In this project you can enjoy a life with the sea and you can have a holiday for 12 months with social facilities and activities.&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p>','[\"projects\\/13.jpg\",\"projects\\/12.jpg\",\"projects\\/11.jpg\",\"projects\\/14.jpg\"]','Texas, USA',2,16,327,1,0,'2020-06-09','2019-09-10','selling','2019-11-18 03:30:34','2021-06-11 20:56:44',15,'A summerhouse in the center of the city. Remove the boundaries between you and the sea, you will be surrounded by blue sea. Everything you have imagined - from infinity pool, zen garden, gourmet restaurant to thematic playgrounds awaiting you. A unique design that makes luxury a habit, a wide variety of apartment plan options.',NULL,NULL,1,1,NULL,'Botble\\ACL\\Models\\User','42.795156','-76.237441',5207,1,1,NULL,NULL),(4,'Aegean Villas','<h2><strong>Aegean Villas</strong></h2>\r\n\r\n<p>Looks like Aegean town and be one of the highest rated sites in the region. A very large area of 312.000sqm&nbsp; has only 144 villas. Each villa&rsquo;s garden is independent of one another and protects private life. There are 400 adult olive trees in the common area landscape. Strengthening of neighborly relations with common sharing points such as open air cinema, village coffee, market.&nbsp; Increase the living motivation with 2,5km walking and cycling trail, tennis courts and carpet right activities.&nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<h4><strong>Why you should buy a house from this project?</strong></h4>\r\n\r\n<ul>\r\n	<li>1. Natural Architectural design.</li>\r\n	<li>2. Highest session rate in the region</li>\r\n	<li>3. Common sharing areas like open air cinema and village cafe.</li>\r\n	<li>4. 2,5km walking and cycling trail.</li>\r\n	<li>5. The gardens are detached and useful.</li>\r\n</ul>','[\"properties\\/a5-1.jpg\",\"properties\\/a6-1.jpg\",\"properties\\/a7.jpg\",\"properties\\/a8.jpg\",\"properties\\/a10.jpg\",\"properties\\/a9.jpg\"]','Büyükçekmece, İstanbul, Turkey',5,2,144,1,0,'2020-06-09','2020-10-04','selling','2019-11-18 03:38:13','2021-06-11 20:56:44',11,'A very large area of 312.000sqm  has only 144 villas. Each villa’s garden is independent of one another and protects private life. There are 400 adult olive trees in the common area landscape. Strengthening of neighborly relations with common sharing points such as open air cinema, village coffee, market.',NULL,NULL,1,2,NULL,'Botble\\ACL\\Models\\User','42.478281','-75.321856',5513,1,1,NULL,NULL),(5,'Aydos Forest Apartments','<p>The project, which offers unique opportunities for those who want to move into their new home, is the most advantageous housing project of the location with its easy payment options according to your budget. In your new home you will have a live site life with 90% occupancy; The <strong>clean air</strong> of Aydos Forest, the most important social facility of the region with <strong>3,700 sqm</strong> which brings enjoyable social activities to your feet, and much more are waiting for you. You will live a life with nature thanks to the artificial lake and cherry trees in the project as well as the landscape of Aydos Forest. and bacause of its easy connection to the main roads, you can easily reach the important centers of Istanbul.</p>\r\n\r\n<h4><b>Why you should buy a house from this project?</b></h4>\r\n\r\n<ul>\r\n	<li>1.&nbsp;Ready for delivery.</li>\r\n	<li>2.&nbsp;82% open area of landscape.</li>\r\n	<li>3.&nbsp;Aydos forest is right next to the project.</li>\r\n	<li>4.&nbsp;More than 90% of the project is occupied and full of life.</li>\r\n	<li>5. Ease of transportation.</li>\r\n</ul>','[\"properties\\/q1.jpg\",\"properties\\/q2.jpg\",\"properties\\/q8.jpg\",\"properties\\/q7.jpg\",\"properties\\/q3.jpg\",\"properties\\/q6.jpg\"]','Sancaktepe/İstanbul, Turkey',4,18,1394,1,0,'2019-10-30','2019-07-21','selling','2019-11-18 03:45:06','2021-04-18 09:20:14',2,'You will have a live site life with 90% occupancy; The clean air of Aydos Forest, the most important social facility of the region with 3,700 sqm which brings enjoyable social activities to your feet, and much more are waiting for you. You will live a life with nature thanks to the artificial lake and cherry trees in the project as',NULL,NULL,1,3,NULL,'Botble\\ACL\\Models\\User','43.270016','-75.054121',1941,1,1,NULL,NULL),(6,'The Avila Apartments','<p>A profoundly special project amidst history and Istanbul. In the heart of the Historical Peninsula, Select Lifestyle Alternatives ranging from 1+1 to 6+1, in limited numbers&hellip;. A timeless aesthetic enriched in perfect details .</p>\r\n\r\n<h4><b>Why you should buy a house from this project?</b></h4>\r\n\r\n<ul>\r\n	<li>1.&nbsp;Within the historical peninsula, there is a very special area where you will never find a similar one.</li>\r\n	<li>2.&nbsp;Unique sea view with a historical texture of Istanbul.</li>\r\n	<li>3.&nbsp;In the bustling city life, in the middle of all transportation possibilities.</li>\r\n	<li>4. 1+1 to 6+1 very special, suitable for all needs loft apartments</li>\r\n	<li>5.Large landscaping areas, cafes, shopping opportunities.</li>\r\n</ul>','[\"properties\\/e1.jpg\",\"properties\\/e2.jpg\",\"properties\\/e3.jpg\",\"properties\\/e4.jpg\",\"properties\\/e5.jpg\",\"properties\\/e7.jpg\",\"properties\\/e8.jpg\"]','Singapore Island, Singapore',2,4,125,1,0,'2019-11-19','2019-03-11','selling','2019-11-18 03:53:20','2021-06-11 20:56:44',10,'Within the historical peninsula, there is a very special area where you will never find a similar one. Unique sea view with a historical texture of Istanbul. In the bustling city life, in the middle of all transportation possibilities. Large landscaping areas, cafes, shopping opportunities.',NULL,NULL,1,5,NULL,'Botble\\ACL\\Models\\User','43.481307','-74.862851',3169,1,1,NULL,NULL);
/*!40000 ALTER TABLE `re_projects` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_projects_translations`
--

DROP TABLE IF EXISTS `re_projects_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_projects_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_projects_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floor_plans` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`re_projects_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_projects_translations`
--

LOCK TABLES `re_projects_translations` WRITE;
/*!40000 ALTER TABLE `re_projects_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_projects_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_properties`
--

DROP TABLE IF EXISTS `re_properties`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_properties` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `floor_plans` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `project_id` bigint unsigned DEFAULT '0',
  `number_bedroom` smallint unsigned DEFAULT NULL,
  `number_bathroom` smallint unsigned DEFAULT NULL,
  `number_floor` smallint unsigned DEFAULT NULL,
  `square` double DEFAULT NULL,
  `price` decimal(15,2) DEFAULT NULL,
  `price_unit` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `featured_priority` int DEFAULT '0',
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'selling',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sale',
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency_id` int unsigned DEFAULT NULL,
  `city_id` int unsigned DEFAULT NULL,
  `period` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'month',
  `author_id` int DEFAULT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `moderation_status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `reject_reason` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `auto_renew` tinyint(1) NOT NULL DEFAULT '0',
  `never_expired` tinyint(1) NOT NULL DEFAULT '0',
  `latitude` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `country_id` int unsigned DEFAULT '1',
  `state_id` int unsigned DEFAULT NULL,
  `unique_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `re_properties_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_properties`
--

LOCK TABLES `re_properties` WRITE;
/*!40000 ALTER TABLE `re_properties` DISABLE KEYS */;
INSERT INTO `re_properties` VALUES (1,'3 Beds Villa Calpe, Alicante','<p>This villa is equipped with all conveniences, where everything takes place on one living level. Three spacious bedrooms that all have direct access to the pool terrace and a spacious living room with an American kitchen with cooking island, from where you can walk onto the terrace through large glass sliding doors. Downstairs there is an indoor, double garage and laundry room with an internal staircase to the house. But you can also drive up to the front door by car. The terrace is spacious and there is an extra-long swimming pool, where you can swim laps well. Around there is a landscaped garden, which is also low in maintenance. Instead of gardening, there is more time left for wonderful enjoyment in and around this beautiful villa.</p>','Alicante, Spain','[\"properties\\/1.jpg\",\"properties\\/3.jpg\",\"properties\\/4.jpg\",\"properties\\/2.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',6,3,3,1,600,700000.00,NULL,1,0,'selling','2019-11-17 20:34:59','2025-04-29 17:15:10','sale','This villa is equipped with all conveniences, where everything takes place on one living level. Three spacious bedrooms that all have direct access to the pool terrace and a spacious living room with an American kitchen with cooking island, from where you can walk onto the terrace through large glass sliding doors.',1,5,'month',10,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.954366','-76.204832',18,1,1,NULL,NULL),(2,'Property For sale , Johannesburg, South Africa','<p><strong>Beautiful home situated in road closure in bedfordview.&nbsp;</strong>Nestled on a rocky outcrop of enormous boulders, this unique home is an architectural triumph designed to titilate the senses from the very start with a waterfall cascading into heated black quartzite pool &amp; stunning koi-pond. Flavours of the Seychelles.&nbsp;Enter from a winding pathway lined by palms and tree ferns into the hallway. The spacious living room with magnificent wood burning fireplace and large diningroom are complemented by a wet barrel bar, featuring designer built in wine cellar wall.</p>','Johannesburg, South Africa','[\"properties\\/23.jpg\",\"properties\\/21.jpg\",\"properties\\/24.jpg\",\"properties\\/22.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',6,4,4,2,800,800000.00,NULL,1,0,'selling','2019-11-17 20:53:34','2025-04-29 17:15:10','sale','Beautiful home. Nestled on a rocky outcrop of enormous boulders, this unique home is an architectural triumph designed to titilate the senses from the very start with a waterfall cascading into heated black quartzite pool & stunning koi-pond. Flavours of the Seychelles.',1,2,'month',11,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.819483','-76.703637',584,1,1,NULL,NULL),(3,'Stunning French Inspired Manor','<p>Stunning French Inspired Manor located within Briarwood Ranch near Solvang in the heart of the magnificent Santa Ynez Valley. This residence features appx 5,000sqft 4+ bedroom, 3.5 bath home with elegant and spacious interiors including formal living and dining, amazing view great room and kitchen, and massive bonus library media room with bar and custom built-ins. The magnificent lagoon-like infinity edge swimming pool offers beach entry, waterfalls and slide, Cabana and a complimentary poolside bar combo BBQ kitchen. A spacious 2 car garage is adjacent to craft room and large art studio</p>','Solvang, Santa Barbara County, CA 93463, USA','[\"properties\\/31.jpg\",\"properties\\/32.jpg\",\"properties\\/33.jpg\",\"properties\\/34.jpg\",\"properties\\/35.jpg\",\"properties\\/311.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',5,4,3,1,450,1695000.00,NULL,1,0,'selling','2019-11-17 21:09:55','2025-04-29 17:15:10','sale','This residence features appx 5,000sqft 4+ bedroom, 3.5 bath home with elegant and spacious interiors including formal living and dining, amazing view great room and kitchen, and massive bonus library media room with bar and custom built-ins. The magnificent lagoon-like infinity edge swimming pool offers beach entry, waterfalls and slide',1,5,'month',10,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.722299','-75.466082',2866,1,1,NULL,NULL),(4,'Villa for sale at Bermuda Dunes','<p>This rare and exceptional custom-built home sits on a premiere lot in the exclusive, private section of Castle Harbour. The property borders the golf course for 360 lineal feet, adding not only a gorgeous view but also complete privacy. The home itself sets above the golf course, for further privacy, and is located between the 5th and 6th fairways of the prestigious Bermuda Dunes Country Club. Chiseled glass entry doors lead you into a magnificent Italian Marble entry that encompasses the entire hallway and living room with a fireplace. The vast great room, with raised ceilings, captures the pool, golf, lake and dynamic southern, mountain views. There&#39;s a lovely Library with built in shelves on one wall. There&rsquo;s a sunken wet bar, with Italian Marble flooring, that provides views of the golf course and surrounding mountains.</p>','Bermuda Dunes, Riverside County, CA 92203, USA','[\"properties\\/411.jpg\",\"properties\\/44.jpg\",\"properties\\/43.jpg\",\"properties\\/42.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',4,4,3,1,480,1295000.00,NULL,1,0,'selling','2019-11-17 21:18:11','2025-04-29 17:15:10','sale','This rare and exceptional custom-built home sits on a premiere lot in the exclusive, private section of Castle Harbour. The property borders the golf course for 360 lineal feet, adding not only a gorgeous view but also complete privacy. The home itself sets above the golf course, for further privacy, and is located between the 5th and 6th fairways of the prestigious Bermuda Dunes Country Club',1,1,'month',7,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.982274','-76.182356',2578,1,1,NULL,NULL),(5,'Walnut Park Apartment','<p>Only 11 miles from downtown Austin, the heavily-wooded site borders Walnut Creek and offers residents inspiring views in an unparalleled, secluded community</p>\r\n\r\n<ul>\r\n	<li>Heavily wooded site with dramatic 30-foot bluffs overlooking the scenic Walnut Creek</li>\r\n	<li>Conveniently located on North Lamar near numerous shops, major employers and restaurants</li>\r\n	<li>Easy access to I-35 and a short distance to US-183 and SH-45</li>\r\n	<li>Elegant clubhouse with a full kitchen, bar area, lounging area and creek-view veranda</li>\r\n	<li>24-hour fully-equipped fitness center with lockers and changing area</li>\r\n	<li>Indoor spa with cascading waterfall, steam room and cedar sauna</li>\r\n	<li>Spacious, gourmet kitchens with granite countertops and backsplashes</li>\r\n	<li>Stainless steel appliances and natural gas ranges</li>\r\n	<li>Designer hardwood cabinets with under-cabinet lighting</li>\r\n</ul>','North Lamar Boulevard, Austin, Texas 78753, USA','[\"properties\\/8.jpg\",\"properties\\/7.jpg\",\"properties\\/5.jpg\",\"properties\\/1-1.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',1,2,2,1,980,2035.00,NULL,1,0,'renting','2019-11-18 00:47:52','2025-04-29 17:15:10','rent','Heavily wooded site with dramatic 30-foot bluffs overlooking the scenic Walnut Creek\r\nConveniently located on North Lamar near numerous shops, major employers and restaurants\r\nEasy access to I-35 and a short distance to US-183 and SH-45\r\nElegant clubhouse with a full kitchen, bar area, lounging area and creek-view veranda',1,1,'month',1,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.669053','-75.578469',4290,1,1,NULL,NULL),(6,'5 beds luxury house','<p>Luxury and spacious remodeled house in Sea Cliff with 3 levels, 5 bedrooms and 4 bathrooms, and a great Golden Gate View. 4-Car garage. The house is remodeled and spacious with a great layout, and is offered furnished. It is charming and beautiful with lots of details, has thoughtful front landscaping and a large backyard and a patio, and has a great view of the Golden Gate. On the main level the entry opens to a large foyer which connects to a beautiful and large living room with a fireplace, and to a formal dining room.</p>\r\n\r\n<p>The house has a garage which can accommodate 3 to 4 cars. The house is offered furnished. Can be leased for short term or long term. The minimum lease term is 3 months.</p>','Seacliff San Francisco, Sea Cliff Avenue, San Francisco, CA 94121, USA','[\"properties\\/a3.jpg\",\"properties\\/a1.jpg\",\"properties\\/a2.jpg\",\"properties\\/a4.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',2,5,4,3,270,1808.00,NULL,1,0,'renting','2019-11-18 01:05:58','2025-04-29 17:15:10','rent','Luxury and spacious remodeled house in Sea Cliff with 3 levels, 5 bedrooms and 4 bathrooms, and a great Golden Gate View. 4-Car garage. The house is remodeled and spacious with a great layout, and is offered furnished. It is charming and beautiful with lots of details, has thoughtful front landscaping and a large backyard and a patio, and has a great view of the Golden Gate',1,1,'month',11,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.946985','-76.206616',3717,1,1,NULL,NULL),(7,'Family Victorian \"View\" Home','<p>There is a formal dining room and spacious living room located on either side of the updated eat-in kitchen skylight, white cabinets, and stainless steel appliances. Enjoy ample natural light and spectacular southern views from the main living room oversized windows and a walk-out deck. A bonus room (guest bedroom/office) and a full bath complete this level.</p>\r\n<p> </p>','Safeway San Francisco CA, Market Street, San Francisco, CA 94114, USA','[\"properties\\/b5.jpg\",\"properties\\/b1.jpg\",\"properties\\/b4.jpg\",\"properties\\/b6.jpg\",\"properties\\/b2.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',3,3,2,1,180,2580.00,NULL,1,0,'renting','2019-11-18 01:12:07','2025-04-29 17:15:10','rent','There is a formal dining room and spacious living room located on either side of the updated eat-in kitchen skylight, white cabinets, and stainless steel appliances. Enjoy ample natural light and spectacular southern views from the main living room oversized windows and a walk-out deck. A bonus room (guest bedroom/office) and a full bath complete t',1,1,'month',5,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.819646','-74.89512',5715,1,1,NULL,NULL),(8,'Osaka Heights Apartment','<p><strong>Kitchen</strong><br />\r\nCeramic tiled flooring, Granite counter top , Single bowl stainless steel kitchen sink with drain board and provisions for water purifier , electric hood , exhaust fan will be provided</p>\r\n\r\n<p><strong>Toilets</strong><br />\r\nAnti-skid Ceramic tiles on floor and ceramic wall tiles up to 7 feet height. White coloured branded sanitary fittings, Chromium plated taps , concealed plumbing</p>\r\n\r\n<p><strong>Doors</strong><br />\r\nMain door will be high quality wooden door, premium Windows quality pre-hung internal doors with wooded frame, UPVC or aluminum sliding doors and aluminum frame with glass for windows</p>\r\n\r\n<p>&nbsp;9 km to Katunayaka airport expressway entrance</p>\r\n\r\n<p>&nbsp;12 km to Southern expressway entrance at Kottawa</p>\r\n\r\n<p>&nbsp;2 km to Kalubowila General hospital</p>\r\n\r\n<p>&nbsp;All leading banks within a few kilometer radii</p>\r\n\r\n<p>&nbsp;Very close proximity to railway stations</p>\r\n\r\n<p>&nbsp;Many leading schools including CIS within 5 km radius</p>','High Level Road, Colombo 06, Sri Lanka','[\"properties\\/24-1.jpg\",\"properties\\/22-1.jpg\",\"properties\\/p1.jpg\",\"properties\\/p2.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',2,2,2,1,110,150000.00,NULL,1,0,'selling','2019-11-18 01:49:36','2025-04-29 17:15:10','sale','Ceramic tiled flooring, Granite counter top , Single bowl stainless steel kitchen sink with drain board and provisions for water purifier , electric hood , exhaust fan will be provided. Anti-skid Ceramic tiles on floor and ceramic wall tiles up to 7 feet height. White coloured branded sanitary fittings, Chromium plated taps , concealed plumbing.',1,5,'month',5,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.928003','-74.902172',7422,1,1,NULL,NULL),(9,'Private Estate Magnificent Views','<p>Spacious 3 bedroom stabilised earth brick home, light and bright with statement entrance hall. Conservatory sun room, open plan kitchen/dining/lounge with raked cedar lined ceiling, kitchen with oregon timber cupboards and new Smeg oven. Air conditioner &amp; wood heater<br />\r\nGood sized bedrooms and main bedroom with spa overlooking tranquil gardens and Inlet.</p>','110 Springdale Heights, Hay Denmark, WA, Australia','[\"properties\\/79.jpg\",\"properties\\/71.jpg\",\"properties\\/73.jpg\",\"properties\\/72.jpg\",\"properties\\/74.jpg\",\"properties\\/75.jpg\",\"properties\\/78.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',2,3,1,1,2000,694000.00,NULL,1,0,'selling','2019-11-18 02:02:19','2025-04-29 17:15:10','sale','Spacious 3 bedroom stabilised earth brick home, light and bright with statement entrance hall. Conservatory sun room, open plan kitchen/dining/lounge with raked cedar lined ceiling, kitchen with oregon timber cupboards and new Smeg oven. Air conditioner & wood heater',1,5,'month',9,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.812299','-76.137607',9965,1,1,NULL,NULL),(10,'Thompsons Road House for rent','<p>Perfectly positioned in the exclusive suburb of Bulleen, this renovated home 3 bedroom home offers a superb lifestyle to those seeking all the expected comforts, privacy, convenience to freeways &amp; transport, and space.<br />\r\nYou are welcomed by a beautiful, low maintenance and established front garden, with ample off street parking, an elevated porch and tantum large garage. Inside you will find a lovely neutral colour scheme and near new gleaming timber timber floors. There are three spacious bedrooms all with built in robes, serviced by a central family bathroom and separate powder room, along with a large open lounge and formal dining room beaming with natural light. The stunning kitchen comes complete with Blanco appliances, breakfast bar and top quality fittings and fixtures.</p>','Thompsons Road, Bulleen VIC, Australia','[\"properties\\/5-1.jpg\",\"properties\\/7-1.jpg\",\"properties\\/8-1.jpg\",\"properties\\/9.jpg\",\"properties\\/6.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',6,3,3,1,160,1465.00,NULL,1,0,'renting','2019-11-18 02:16:53','2025-04-29 17:15:10','rent','Perfectly positioned in the exclusive suburb of Bulleen, this renovated home 3 bedroom home offers a superb lifestyle to those seeking all the expected comforts, privacy, convenience to freeways & transport, and space.\r\nYou are welcomed by a beautiful, low maintenance and established front garden, with ample off street parking, an elevated porch and tantum large garage',1,3,'month',5,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.601639','-76.36969',7558,1,1,NULL,NULL),(11,'Brand New 1 Bedroom Apartment In First Class Location','<p>Set-back from Sandy Bay Road, walk to everything that counts: vibrant Battery Point village, Salamanca Place (Tasmania&#39;s premier entertainment precinct), the City Centre, University of Tasmania, hotel, retail and an easy stroll away from bustling Sandy Bay shops, local schools and with public transport outside your front door.</p>\r\n\r\n<p>Please note: Elders Brown and Banks do not accept applications from applicants who have not inspected the property internally.</p>','Sandy Bay Road, Sandy Bay TAS, Australia','[\"properties\\/12.jpg\",\"properties\\/10.jpg\",\"properties\\/13.jpg\",\"properties\\/14.jpg\",\"properties\\/15.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',5,1,1,1,80,1680.00,NULL,1,0,'renting','2019-11-18 02:22:48','2025-04-29 17:15:10','rent','Set-back from Sandy Bay Road, walk to everything that counts: vibrant Battery Point village, Salamanca Place (Tasmania\'s premier entertainment precinct), the City Centre, University of Tasmania, hotel, retail and an easy stroll away from bustling Sandy Bay shops, local schools and with public transport outside your front door.',1,5,'month',9,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.659611','-76.197177',7894,1,1,NULL,NULL),(12,'Elegant family home presents premium modern living','<p>Move straight into this beautifully presented four-bedroom home and enjoy the best in modern family living without lifting a finger. Two separate living areas and four generous bedrooms provide plenty of space to grow, and entertaining is a real pleasure on the elegant alfresco patio in a peaceful garden setting. The home is ideally set walking distance to parks and bus stops, moments to your choice of schools, and just several minutes to Westfield North Lakes.<br />\r\n&nbsp;</p>','North Lakes QLD 4509, Australia','[\"properties\\/a1-1.jpg\",\"properties\\/a2-1.jpg\",\"properties\\/a3-1.jpg\",\"properties\\/a5.jpg\",\"properties\\/a4-1.jpg\",\"properties\\/a6.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',6,3,3,1,658,1574.00,NULL,1,0,'renting','2019-11-18 02:47:05','2025-04-29 17:15:10','rent','Move straight into this beautifully presented four-bedroom home and enjoy the best in modern family living without lifting a finger. Two separate living areas and four generous bedrooms provide plenty of space to grow, and entertaining is a real pleasure on the elegant alfresco patio in a peaceful garden setting.',1,5,'month',5,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.137361','-76.539998',6794,1,1,NULL,NULL),(13,'Luxury Apartments in Singapore for Sale','<p>This apartment&nbsp;is located in Singapore, which has become a comfortable living center for the living, providing both attractive gains for investors and high premium. 840sqft<br />\r\n- High Floor<br />\r\n- Chinese Family<br />\r\n- Sky Garden<br />\r\n- Beautiful Roof Terrace with Jaccuzzi And<br />\r\nAlfresco Dinning<br />\r\n- Renovated with Quality Finishes<br />\r\n- Near Amenities<br />\r\n- Plenty of eateries.<br />\r\n- 5mins Walk to NTUC / Shaw Plaza<br />\r\n- Mins Drive To Orchard</p>','Balestier Road, Singapore','[\"properties\\/5-2.jpg\",\"properties\\/2-3.jpg\",\"properties\\/3-3.jpg\",\"properties\\/4-2.jpg\",\"properties\\/1-3.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',6,2,2,1,78,918000.00,NULL,1,0,'selling','2019-11-18 07:23:02','2025-04-29 17:15:10','sale','This apartment is located in Singapore. High Floor, Chinese Family, Sky Garden, Beautiful Roof Terrace with Jaccuzzi and Alfresco Dinning, Renovated with Quality Finishes, Near Amenities, Plenty of eateries, 5mins Walk to NTUC / Shaw Plaza, Mins Drive To Orchard',1,5,'month',10,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.813772','-76.615855',291,1,1,NULL,NULL),(14,'5 room luxury penthouse for sale in Kuala Lumpur','<p>The Sentral Residence (BRAND NEW LUXURY CONDO)<br />\r\n<br />\r\n-Next to St Regis 5 Star Hotel<br />\r\n-Excellent accessibility (LRT,KLIA TRANSIT,KTM)<br />\r\n-Rooftop Sky lounge,sky pool,sky gym<br />\r\n-Private lift lobby to own unit<br />\r\n<br />\r\nEPIC LUXE PREMIUM UNITS<br />\r\n(KLCC and Lake Garden VIEW)<br />\r\n<br />\r\nLargest unit in Sentral Residence<br />\r\n&nbsp;</p>','Kuala Lumpur, Malaysia','[\"properties\\/6-2.jpg\",\"properties\\/7-2.jpg\",\"properties\\/9-1.jpg\",\"properties\\/8-2.jpg\",\"properties\\/10-1.jpg\",\"properties\\/11-1.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',1,5,7,20,377,1590000.00,NULL,1,0,'selling','2019-11-18 07:36:29','2025-04-29 17:15:10','sale','Next to St Regis 5 Star Hotel, Excellent accessibility (LRT,KLIA TRANSIT,KTM), Rooftop Sky lounge, sky pool, sky gym, KLCC and Lake Garden VIEW',1,4,'month',1,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'42.504328','-76.341293',1069,1,1,NULL,NULL),(15,'2 Floor house in Compound Pejaten Barat Kemang','<p>Want to lease a nice house in compound Renovated, balinese style ,homey and comfy area 220/300,&nbsp;3&nbsp;bedrooms,&nbsp;2 bathrooms, garden furnished renovated fasilitas : s.pool, tenis court, jogging track 24 hours security rent price : IDR 250.000.000 / year&nbsp;</p>','Kota Administrasi Jakarta Selatan, South Jakarta City, Jakarta Raya, Indonesia','[\"properties\\/a1-2.jpg\",\"properties\\/a2-2.jpg\",\"properties\\/a3-2.jpg\",\"properties\\/a4-2.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',1,3,2,2,200,1400.00,NULL,1,0,'renting','2019-11-18 07:44:44','2025-04-29 17:15:10','rent','Want to lease a nice house in compound Renovated, balinese style ,homey and comfy area 220/300, 3 bedrooms, 2 bathrooms, garden furnished renovated fasilitas : s.pool, tenis court, jogging track 24 hours security rent price : IDR 250.000.000 / year ',1,5,'month',9,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.636294','-76.116519',4475,1,1,NULL,NULL),(16,'Apartment Muiderstraatweg in Diemen','<p>For rent fully furnished 3 bedroom apartment in Diemen.<br />\r\nVery suitable for a couple or maximum 2 working sharers, garantors are not accepted.<br />\r\n<br />\r\nLovely modern and very well maintained apartment in Diemen.<br />\r\nThe property is located on the first floor where you will find the living room and the kitchen with all modern conveniences.<br />\r\nOn the second floor 2 bedrooms and a nice bathroom with a seperate shower and bathtub.<br />\r\nOn this floor you have access to the small roof terrace.<br />\r\nLast but not least there is a spacious attic room on the third floor.<br />\r\nThe tram stops in front of the door and within 20 minutes you are in the heart of Amsterdam.<br />\r\nPets are not allowed.</p>','Diemen, Netherlands','[\"properties\\/b4-1.jpg\",\"properties\\/b3.jpg\",\"properties\\/b5-1.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',3,3,1,2,90,2123.00,NULL,1,0,'renting','2019-11-18 07:59:14','2025-04-29 17:15:10','rent','Lovely modern and very well maintained apartment in Diemen.\r\nThe property is located on the first floor where you will find the living room and the kitchen with all modern conveniences.\r\nOn the second floor 2 bedrooms and a nice bathroom with a seperate shower and bathtub.\r\nOn this floor you have access to the small roof terrace.',1,3,'month',5,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.52876','-76.65882',9164,1,1,NULL,NULL),(17,'Nice Apartment for rent in Berlin','<p>Fully furnished shared all-inclusive apartments, with modern amenities that&rsquo;ll make you feel right at home. A great starting point for exploring the rest of the city and its many hidden gems. Area In the center of East Berlin, you&rsquo;ll find everything from delicious street food to flee markets, to high-end restaurants.</p>\r\n\r\n<p>In this bright, modern h(e)aven, you&rsquo;ll find a Queen size bed, a fully equipped kitchen, a separate bathroom with a walk-in shower and a study area for when the dedicated student in you awakens. Some come with great views, others with a nice and cozy balcony.</p>','Berlin, Germany','[\"properties\\/t3.jpg\",\"properties\\/t1.jpg\",\"properties\\/t2.jpg\",\"properties\\/t4.jpg\",\"properties\\/t5.jpg\"]','[{\"name\":{\"key\":\"name\",\"value\":\"First Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"3\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"2\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}},{\"name\":{\"key\":\"name\",\"value\":\"Second Floor\"},\"bedrooms\":{\"key\":\"bedrooms\",\"value\":\"2\"},\"bathrooms\":{\"key\":\"bathrooms\",\"value\":\"1\"},\"image\":{\"key\":\"image\",\"value\":\"properties\\/floor.png\"}}]',6,1,1,1,33,1217.00,NULL,1,0,'renting','2019-11-18 08:13:07','2025-04-29 17:15:10','rent','Fully furnished shared all-inclusive apartments, with modern amenities that’ll make you feel right at home. A great starting point for exploring the rest of the city and its many hidden gems. Area In the center of East Berlin, you’ll find everything from delicious street food to flee markets, to high-end restaurants.',1,5,'month',10,'Botble\\RealEstate\\Models\\Account','approved',NULL,'2025-06-14',0,1,'43.222732','-76.105523',2397,1,1,NULL,NULL);
/*!40000 ALTER TABLE `re_properties` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_properties_translations`
--

DROP TABLE IF EXISTS `re_properties_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_properties_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `re_properties_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `floor_plans` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`re_properties_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_properties_translations`
--

LOCK TABLES `re_properties_translations` WRITE;
/*!40000 ALTER TABLE `re_properties_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_properties_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_property_categories`
--

DROP TABLE IF EXISTS `re_property_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_property_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `property_id` int unsigned NOT NULL,
  `category_id` int unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_property_categories`
--

LOCK TABLES `re_property_categories` WRITE;
/*!40000 ALTER TABLE `re_property_categories` DISABLE KEYS */;
INSERT INTO `re_property_categories` VALUES (5125,5,6),(5132,12,5),(5137,1,2),(5138,2,2),(5139,3,3),(5140,4,3),(5141,6,2),(5142,7,6),(5143,8,4),(5144,9,6),(5145,10,6),(5146,11,1),(5147,13,6),(5148,14,2),(5149,15,4),(5150,16,3),(5151,17,3);
/*!40000 ALTER TABLE `re_property_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_property_features`
--

DROP TABLE IF EXISTS `re_property_features`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_property_features` (
  `property_id` int unsigned NOT NULL,
  `feature_id` int unsigned NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_property_features`
--

LOCK TABLES `re_property_features` WRITE;
/*!40000 ALTER TABLE `re_property_features` DISABLE KEYS */;
INSERT INTO `re_property_features` VALUES (1,1),(1,2),(1,3),(1,4),(1,5),(1,6),(1,7),(1,8),(1,9),(1,10),(1,11),(1,12),(2,1),(2,2),(2,3),(2,4),(2,5),(2,6),(2,7),(2,8),(2,9),(2,10),(2,11),(2,12),(3,1),(3,2),(3,3),(3,4),(3,5),(3,6),(3,7),(3,8),(3,9),(3,10),(3,11),(3,12),(4,1),(4,2),(4,3),(4,4),(4,5),(4,6),(4,7),(4,8),(4,9),(4,10),(4,11),(4,12),(5,1),(5,2),(5,3),(5,4),(5,5),(5,6),(5,7),(5,8),(5,9),(5,10),(5,11),(5,12),(6,1),(6,2),(6,3),(6,4),(6,5),(6,6),(6,7),(6,8),(6,9),(6,10),(6,11),(6,12),(7,1),(7,2),(7,3),(7,4),(7,5),(7,6),(7,7),(7,8),(7,9),(7,10),(7,11),(7,12),(8,1),(8,2),(8,3),(8,4),(8,5),(8,6),(8,7),(8,8),(8,9),(8,10),(8,11),(8,12),(9,1),(9,2),(9,3),(9,4),(9,5),(9,6),(9,7),(9,8),(9,9),(9,10),(9,11),(9,12),(10,1),(10,2),(10,3),(10,4),(10,5),(10,6),(10,7),(10,8),(10,9),(10,10),(10,11),(10,12),(11,1),(11,2),(11,3),(11,4),(11,5),(11,6),(11,7),(11,8),(11,9),(11,10),(11,11),(11,12),(12,1),(12,2),(12,3),(12,4),(12,5),(12,6),(12,7),(12,8),(12,9),(12,10),(12,11),(12,12),(13,1),(13,2),(13,3),(13,4),(13,5),(13,6),(13,7),(13,8),(13,9),(13,10),(13,11),(13,12),(14,1),(14,2),(14,3),(14,4),(14,5),(14,6),(14,7),(14,8),(14,9),(14,10),(14,11),(14,12),(15,1),(15,2),(15,3),(15,4),(15,5),(15,6),(15,7),(15,8),(15,9),(15,10),(15,11),(15,12),(16,1),(16,2),(16,3),(16,4),(16,5),(16,6),(16,7),(16,8),(16,9),(16,10),(16,11),(16,12),(17,1),(17,2),(17,3),(17,4),(17,5),(17,6),(17,7),(17,8),(17,9),(17,10),(17,11),(17,12);
/*!40000 ALTER TABLE `re_property_features` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_reviews`
--

DROP TABLE IF EXISTS `re_reviews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int unsigned NOT NULL,
  `reviewable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reviewable_id` bigint unsigned NOT NULL,
  `star` tinyint NOT NULL,
  `content` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'approved',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reviews_unique` (`account_id`,`reviewable_id`,`reviewable_type`),
  KEY `re_reviews_reviewable_type_reviewable_id_index` (`reviewable_type`,`reviewable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=201 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_reviews`
--

LOCK TABLES `re_reviews` WRITE;
/*!40000 ALTER TABLE `re_reviews` DISABLE KEYS */;
INSERT INTO `re_reviews` VALUES (1,3,'Botble\\RealEstate\\Models\\Project',2,2,'Alice, feeling very glad to do that,\' said the Hatter; \'so I should have liked teaching it tricks very much, if--if I\'d only been the whiting,\' said Alice, and she tried another question. \'What sort of thing that would happen: \'\"Miss Alice! Come here directly, and.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(2,8,'Botble\\RealEstate\\Models\\Property',1,2,'March Hare went \'Sh! sh!\' and the bright flower-beds and the three gardeners who were lying on the top of it. Presently the Rabbit coming to look about her other little.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(3,2,'Botble\\RealEstate\\Models\\Project',3,3,'NOT SWIM--\" you can\'t be Mabel, for I know is, it would like the name: however, it only grinned when it saw mine coming!\' \'How do you know about this business?\' the King said to herself; \'the March Hare and his friends shared their never-ending meal, and the Queen\'s hedgehog just now.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(4,7,'Botble\\RealEstate\\Models\\Project',1,5,'Still she went in search of her going, though she felt a little of her sharp little chin into Alice\'s shoulder as he shook.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(5,8,'Botble\\RealEstate\\Models\\Project',6,3,'CHAPTER II. The Pool of Tears \'Curiouser and curiouser!\' cried Alice hastily, afraid that it might happen any.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(6,9,'Botble\\RealEstate\\Models\\Property',14,2,'WHAT things?\' said the Cat, \'if you only walk long enough.\' Alice felt a little recovered from the roof. There were doors all round her, calling out in a tone of great dismay, and began singing in its hurry to change the subject,\' the March Hare and the whole party.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(7,12,'Botble\\RealEstate\\Models\\Project',3,3,'Gryphon, half to Alice. \'Nothing,\' said Alice. \'Why, there they are!\' said the Queen, the royal children; there were no tears. \'If you\'re.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(8,12,'Botble\\RealEstate\\Models\\Project',4,3,'She did not feel encouraged to ask any more if you\'d rather not.\' \'We indeed!\' cried the Mock Turtle sang this, very slowly and sadly:-- \'\"Will you walk a little pattering.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(9,5,'Botble\\RealEstate\\Models\\Project',6,1,'Cat\'s head with great curiosity. \'Soles and eels, of course,\' said the King. Here one of them at dinn--\' she checked herself hastily, and.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(10,1,'Botble\\RealEstate\\Models\\Property',10,1,'Bill!\' then the different branches of Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I never went to the jury. \'Not yet, not yet!\' the Rabbit say, \'A barrowful of.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(11,2,'Botble\\RealEstate\\Models\\Property',11,2,'My notion was that you weren\'t to talk to.\' \'How are you thinking of?\' \'I beg pardon, your Majesty,\' said.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(12,9,'Botble\\RealEstate\\Models\\Project',3,2,'FIT you,\' said the Queen, and Alice, were in custody and under sentence of execution.\' \'What for?\' said the Gryphon, and the second time round, she found her head to feel very queer.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(13,1,'Botble\\RealEstate\\Models\\Project',3,3,'She had already heard her voice sounded hoarse and strange, and the game was in the air. \'--as far out to the Hatter.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(14,1,'Botble\\RealEstate\\Models\\Property',1,5,'Improve his shining tail, And pour the waters of the room. The cook threw a frying-pan after her as she could see, when she was appealed to by all three dates on their backs was the Hatter. \'He.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(15,1,'Botble\\RealEstate\\Models\\Property',8,1,'This question the Dodo replied very politely, \'for I never heard of \"Uglification,\"\' Alice ventured to remark. \'Tut, tut, child!\' said the Lory, as soon as she said to herself that perhaps it was quite a large mustard-mine near here. And.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(16,6,'Botble\\RealEstate\\Models\\Property',16,3,'Rabbit came up to the Caterpillar, just as usual. \'Come, there\'s half my plan done now! How puzzling all these strange Adventures of hers that you couldn\'t cut off a head could be beheaded, and that.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(17,11,'Botble\\RealEstate\\Models\\Project',3,3,'Footman remarked, \'till tomorrow--\' At this moment Alice felt a violent blow underneath her chin: it had VERY long claws and a great hurry, muttering to itself \'Then I\'ll go round and get ready for your interesting story,\' but she added, \'and the moral of that is--\"The more.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(18,2,'Botble\\RealEstate\\Models\\Project',6,5,'English coast you find a thing,\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(19,9,'Botble\\RealEstate\\Models\\Property',12,1,'How I wonder if I\'ve kept her waiting!\' Alice felt dreadfully puzzled. The Hatter\'s remark seemed to be found: all she could not help thinking there MUST be more to come, so she bore it as you say things are \"much of a candle is blown.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(20,6,'Botble\\RealEstate\\Models\\Project',4,3,'VERY long claws and a sad tale!\' said the Gryphon, before Alice could see, as well as she could, for the accident of the wood for fear of killing somebody, so managed to swallow a morsel of the bread-and-butter. Just at this.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(23,4,'Botble\\RealEstate\\Models\\Project',6,1,'Alice thought she might as well go in at the sudden change, but she added, to herself, and began talking to herself, as she spoke. (The unfortunate little Bill had left off quarrelling with the grin, which remained.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(24,9,'Botble\\RealEstate\\Models\\Property',8,2,'I\'ll try and say \"How doth the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(25,1,'Botble\\RealEstate\\Models\\Project',6,2,'Alice, timidly; \'some of the Lobster Quadrille?\' the Gryphon as if it makes me grow large again, for really I\'m quite tired of sitting by her sister.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(26,11,'Botble\\RealEstate\\Models\\Property',16,5,'Alice, seriously, \'I\'ll have nothing more to come, so she tried the effect of lying down on the song, she kept tossing the baby.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(27,11,'Botble\\RealEstate\\Models\\Project',4,1,'Edwin and Morcar, the earls.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(28,11,'Botble\\RealEstate\\Models\\Property',14,3,'The twelve jurors were writing down \'stupid.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(29,10,'Botble\\RealEstate\\Models\\Project',2,4,'Dodo in an undertone to the Knave \'Turn them over!\' The Knave of Hearts, who only bowed and smiled in reply. \'That\'s right!\' shouted the Queen. \'You make me grow large again, for really I\'m quite tired and out of sight; and an Eaglet, and several other curious creatures.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(30,2,'Botble\\RealEstate\\Models\\Project',4,4,'The moment Alice appeared, she was to eat the comfits: this caused some noise and confusion, as the whole thing, and she went on, spreading out the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(31,12,'Botble\\RealEstate\\Models\\Project',5,3,'I beg your pardon,\' said Alice indignantly. \'Let me alone!\' \'Serpent, I say again!\' repeated the Pigeon, raising its voice to its feet, \'I.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(32,1,'Botble\\RealEstate\\Models\\Project',1,2,'Then it got down off the subjects on his spectacles. \'Where shall I begin, please your Majesty,\' said the voice. \'Fetch me my gloves this moment!\' Then came a rumbling of little cartwheels, and the Dormouse began in a natural way again. \'I should like to be told so. \'It\'s.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(33,3,'Botble\\RealEstate\\Models\\Property',7,3,'March Hare, \'that \"I breathe when I grow at a king,\' said Alice. \'Well, then,\' the Gryphon went on without attending to her, though, as they would die. \'The trial cannot proceed,\' said the Caterpillar. \'Well, I can\'t take.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(34,8,'Botble\\RealEstate\\Models\\Project',3,1,'I know who I am! But I\'d better take him his fan and gloves. \'How queer it seems,\' Alice said with a whiting. Now you know.\' He was an uncomfortably sharp chin. However, she got to the Gryphon. \'It\'s all about it!\' and he went on planning to herself how this.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(35,3,'Botble\\RealEstate\\Models\\Property',5,5,'Gryphon, with a yelp of delight, which changed into alarm in another moment down went.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(36,5,'Botble\\RealEstate\\Models\\Property',6,4,'Alice. \'And be quick about it,\' said the Lory, as soon as look at me like a snout than a real Turtle.\' These words were followed by a very little! Besides, SHE\'S she, and I\'m sure _I_ shan\'t be able! I.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(37,4,'Botble\\RealEstate\\Models\\Project',1,4,'White Rabbit read out, at the jury-box, and saw that, in her French lesson-book. The Mouse did not dare to disobey, though she looked.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(38,6,'Botble\\RealEstate\\Models\\Property',9,3,'Stigand, the patriotic archbishop of Canterbury, found it made no mark; but he would not open any of them. However, on the second.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(40,6,'Botble\\RealEstate\\Models\\Project',1,1,'I should be raving mad--at least not so mad as it turned a back-somersault in at once.\' However, she soon made out that it might end, you know,\' said.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(41,12,'Botble\\RealEstate\\Models\\Property',5,2,'I to get to,\' said the Caterpillar, just as if she was ever.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(42,11,'Botble\\RealEstate\\Models\\Project',5,3,'Queen to play croquet.\' The Frog-Footman repeated, in the newspapers, at the bottom of a tree a few minutes it puffed away without speaking, but at any rate, there\'s no room to open it; but, as the jury had a wink of sleep these three.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(44,1,'Botble\\RealEstate\\Models\\Project',4,4,'Alice, they all stopped and looked anxiously round, to make out who was peeping anxiously into her face. \'Wake up, Alice.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(46,4,'Botble\\RealEstate\\Models\\Property',6,1,'I beg your pardon!\' cried Alice hastily, afraid that she had not as yet had any dispute with the bread-and-butter getting so used to read fairy-tales, I fancied that kind of serpent, that\'s.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(48,6,'Botble\\RealEstate\\Models\\Property',8,3,'Dodo, a Lory and an old woman--but then--always to have got in your pocket?\' he went.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(49,3,'Botble\\RealEstate\\Models\\Project',1,4,'I breathe\"!\' \'It IS a Caucus-race?\' said Alice; \'that\'s not at all anxious to have it explained,\' said the Rabbit whispered in a game of croquet she was a table set out.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(50,2,'Botble\\RealEstate\\Models\\Project',5,2,'There\'s no pleasing them!\' Alice was beginning very angrily, but the cook was busily stirring the soup, and seemed to be executed for having cheated herself in the sand with wooden spades, then a great thistle, to keep herself from being broken. She hastily put down.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(51,3,'Botble\\RealEstate\\Models\\Project',6,3,'Alice: \'I don\'t think they play at all comfortable, and it sat for a rabbit! I suppose Dinah\'ll be sending me on messages next!\' And she kept fanning herself all the first minute or two she walked sadly down the chimney, has he?\' said Alice very meekly: \'I\'m growing.\' \'You\'ve no.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(52,5,'Botble\\RealEstate\\Models\\Property',2,1,'Alice)--\'and perhaps you haven\'t found it very much,\' said the Caterpillar. Alice said with a pair of boots every Christmas.\' And she kept tossing the baby joined):-- \'Wow! wow! wow!\' While the Duchess was sitting on the floor, as it was getting so far off). \'Oh, my poor little thing sat down and.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(53,6,'Botble\\RealEstate\\Models\\Property',14,3,'Normans--\" How are you thinking of?\' \'I beg pardon, your Majesty,\' he began, \'for bringing these in: but I can\'t remember,\' said the King. Here one of the garden: the roses growing on it in a deep, hollow tone: \'sit down, both of you, and don\'t speak a word till I\'ve finished.\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(54,10,'Botble\\RealEstate\\Models\\Project',4,2,'Alice in a sorrowful tone; \'at least there\'s no meaning in it,\' but none of YOUR business, Two!\' said Seven. \'Yes, it IS his business!\' said Five, \'and I\'ll tell him--it was for bringing the cook till his eyes were nearly out of the trees upon her.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(55,5,'Botble\\RealEstate\\Models\\Property',5,1,'And concluded the banquet--] \'What IS the use of a procession,\' thought she, \'what would become of me?\' Luckily for Alice, the little golden key in the pool, \'and she sits purring so nicely by the little passage: and.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(56,11,'Botble\\RealEstate\\Models\\Property',7,1,'However, at last it sat for a good thing!\' she said to herself how this same little sister of hers that you have just been reading about; and when she caught it, and burning with curiosity, she ran off as hard as she did not get dry.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(57,1,'Botble\\RealEstate\\Models\\Property',15,5,'Improve his shining tail, And pour the waters of the court,\" and I shall remember it in a Little Bill It was opened by another footman in livery came running out of.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(58,4,'Botble\\RealEstate\\Models\\Property',17,3,'Alice, with a sigh: \'he taught Laughing and Grief, they used to read fairy-tales, I fancied that kind of.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(59,10,'Botble\\RealEstate\\Models\\Property',13,5,'I needn\'t be so kind,\' Alice replied, rather shyly, \'I--I hardly know, sir, just at first, perhaps,\' said the Duchess. \'Everything\'s got a moral, if only you can find them.\' As she said.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(62,4,'Botble\\RealEstate\\Models\\Property',5,4,'Dodo, a Lory and an Eaglet, and several other curious creatures. Alice led the way, and nothing seems to grin, How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure those are not the right word) \'--but I shall have to.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(65,10,'Botble\\RealEstate\\Models\\Project',1,1,'I get SOMEWHERE,\' Alice added as an explanation. \'Oh, you\'re sure to happen,\' she said to herself, \'Which way? Which way?\', holding her hand again, and looking at the end of half an hour or so there were TWO little shrieks, and more sounds of broken glass, from which she found she.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(67,9,'Botble\\RealEstate\\Models\\Project',2,1,'Now, if you please! \"William the Conqueror, whose cause was favoured by the fire, stirring a large fan in the sun. (IF you.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(68,10,'Botble\\RealEstate\\Models\\Property',15,5,'I don\'t keep the same height as herself; and when she looked down at them, and he went on just as if she meant to take the hint; but the Mouse only growled in reply. \'That\'s right!\' shouted the Queen, who were giving it something out of a procession,\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(69,12,'Botble\\RealEstate\\Models\\Property',6,1,'Dodo solemnly presented the thimble, saying \'We beg your.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(70,6,'Botble\\RealEstate\\Models\\Property',3,5,'King, the Queen, but she remembered the number of cucumber-frames there must be!\' thought Alice. \'I\'m glad they don\'t give birthday presents like that!\' He got behind Alice as he found it advisable--\"\' \'Found WHAT?\' said the Cat: \'we\'re all mad here. I\'m.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(74,5,'Botble\\RealEstate\\Models\\Property',9,4,'I wish you wouldn\'t have come here.\' Alice didn\'t think that there was nothing on it were white, but there was room for this, and after a few yards off. The Cat.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(75,3,'Botble\\RealEstate\\Models\\Project',5,4,'I breathe\"!\' \'It IS a Caucus-race?\' said Alice; \'it\'s laid for a few minutes it puffed away without speaking, but at the picture.) \'Up, lazy thing!\' said Alice, \'and those twelve creatures,\' (she was obliged to write with one finger; and the second thing is to do THAT in a tone of great.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(76,8,'Botble\\RealEstate\\Models\\Project',1,3,'YOUR temper!\' \'Hold your tongue, Ma!\' said the Duchess; \'and the moral of that.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(78,6,'Botble\\RealEstate\\Models\\Property',1,5,'Alice heard the King sharply. \'Do you know that cats COULD grin.\' \'They all can,\' said the voice. \'Fetch me my gloves this moment!\' Then came a little feeble, squeaking.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(80,9,'Botble\\RealEstate\\Models\\Project',1,3,'Alice. \'I\'m glad I\'ve seen that done,\' thought Alice. \'I\'m a--I\'m a--\' \'Well! WHAT are you?\' said the cook. The King and the other side, the puppy began a series of short charges at the flowers and those cool fountains, but she saw in another minute.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(81,4,'Botble\\RealEstate\\Models\\Property',14,5,'Alice began telling them her adventures from the change: and Alice looked very anxiously into her face. \'Wake up, Alice dear!\' said her sister; \'Why, what are they made of?\' \'Pepper, mostly,\' said the King added in an impatient tone: \'explanations take such a.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(83,7,'Botble\\RealEstate\\Models\\Project',6,2,'THE SLUGGARD,\"\' said the Rabbit say, \'A barrowful will do, to begin again, it was certainly English. \'I don\'t see any wine,\' she remarked. \'It tells the day of the trees.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(84,4,'Botble\\RealEstate\\Models\\Project',5,3,'Now I growl when I\'m pleased, and wag my tail when it\'s pleased. Now I growl when I\'m pleased, and wag my tail when I\'m pleased, and wag my tail when I\'m pleased, and wag my tail when I\'m pleased, and wag my tail.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(85,10,'Botble\\RealEstate\\Models\\Property',10,3,'Duchess, it had VERY long claws and a bright idea came into her eyes; and once again the tiny hands were clasped upon her arm, with its wings. \'Serpent!\' screamed the Gryphon. \'I mean, what makes them so often, you.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(87,7,'Botble\\RealEstate\\Models\\Property',10,5,'Hatter began, in a whisper.) \'That would be the right house, because the chimneys were shaped like the tone of the Lobster; I heard him declare, \"You have baked me too brown, I.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(90,3,'Botble\\RealEstate\\Models\\Property',1,4,'Duchess: \'flamingoes and mustard both bite. And the Gryphon said to the conclusion that it was addressed to the door, staring.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(91,2,'Botble\\RealEstate\\Models\\Property',16,3,'Stop this moment, and fetch me a pair of boots every Christmas.\' And she thought it over a little before she found to be a Caucus-race.\' \'What IS the same year for such dainties would not open any of them. \'I\'m sure those are not the smallest notice of them with one.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(92,10,'Botble\\RealEstate\\Models\\Project',5,1,'She drew her foot as far as they would die. \'The trial cannot proceed,\' said the Hatter, and he wasn\'t going to begin again, it.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(96,10,'Botble\\RealEstate\\Models\\Project',3,2,'King eagerly, and he says it\'s so useful, it\'s worth a hundred pounds! He says it kills all the children she knew the name \'Alice!\' CHAPTER XII. Alice\'s Evidence \'Here!\' cried Alice, jumping up and beg for its dinner, and all must have been a.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(97,5,'Botble\\RealEstate\\Models\\Project',1,3,'YET,\' she said to the Gryphon. \'We can do no more, whatever happens. What WILL become of me?\' Luckily for.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(98,8,'Botble\\RealEstate\\Models\\Property',11,3,'Alice, as she said to the jury. They were indeed a queer-looking.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(101,7,'Botble\\RealEstate\\Models\\Project',5,4,'Alice opened the door and found quite a crowd of little animals and birds waiting outside. The poor little thing sat down again in a day or two: wouldn\'t it be of any use, now,\' thought Alice, \'or perhaps they won\'t walk the way wherever she wanted to send.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(103,2,'Botble\\RealEstate\\Models\\Property',12,5,'Mouse. \'Of course,\' the Dodo solemnly, rising to its children, \'Come away, my dears! It\'s high time you were never even spoke to Time!\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(104,7,'Botble\\RealEstate\\Models\\Project',2,5,'Alice took up the fan and two or three times over to herself, rather sharply; \'I advise you to offer it,\' said Alice. \'Nothing WHATEVER?\' persisted the King. \'Then it doesn\'t matter which way I ought to have wondered at this, but at the top of her favourite word \'moral,\' and the poor little.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(105,1,'Botble\\RealEstate\\Models\\Project',2,5,'Shark, But, when the White Rabbit read:-- \'They told me he was gone, and, by the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(106,11,'Botble\\RealEstate\\Models\\Project',1,2,'Alice\'s head. \'Is that the pebbles were all.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(107,6,'Botble\\RealEstate\\Models\\Project',3,2,'I to do anything but sit with its head, it WOULD twist itself round and swam slowly back to my boy, I beat him.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(109,9,'Botble\\RealEstate\\Models\\Project',5,1,'Lory, who at last she stretched her arms round it as you go on?.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(111,4,'Botble\\RealEstate\\Models\\Property',11,1,'Duchess asked, with another dig of her voice. Nobody moved. \'Who cares.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(112,3,'Botble\\RealEstate\\Models\\Project',4,3,'NOT marked \'poison,\' so Alice soon began talking again. \'Dinah\'ll miss me very much at this, that she began fancying the sort of chance of this, so that they had a head.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(113,12,'Botble\\RealEstate\\Models\\Property',2,3,'For this must ever be A secret, kept from all the right size again; and the Hatter and the White Rabbit as he could go.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(115,10,'Botble\\RealEstate\\Models\\Project',6,4,'And yet I wish you could keep it to her very earnestly, \'Now, Dinah, tell me the list of singers. \'You may go,\' said the Gryphon. \'It all came different!\' the Mock Turtle said: \'no.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(118,1,'Botble\\RealEstate\\Models\\Property',11,5,'I don\'t put my arm round your waist,\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(121,7,'Botble\\RealEstate\\Models\\Project',3,5,'Hatter. \'I told you butter.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(123,9,'Botble\\RealEstate\\Models\\Project',4,4,'THIS size: why, I should be raving mad after all! I almost wish I could show you our cat Dinah: I think I can creep.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(124,2,'Botble\\RealEstate\\Models\\Project',2,3,'I\'ve fallen by this time, as it settled down again, the cook was busily stirring the soup, and seemed to think that there was nothing so VERY nearly at the window.\' \'THAT you won\'t\' thought Alice, \'as all the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(125,3,'Botble\\RealEstate\\Models\\Project',3,1,'Alice, \'I\'ve often seen them at.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(126,6,'Botble\\RealEstate\\Models\\Property',10,1,'I mean what I like\"!\' \'You might just as well. The twelve jurors were all turning into little cakes as they would go, and broke to pieces against one of the cakes, and was a dead silence. \'It\'s a.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(127,3,'Botble\\RealEstate\\Models\\Property',6,5,'Knave of Hearts, and I don\'t know one,\' said Alice. \'Anything you like,\' said the youth, \'and your jaws are too weak For anything tougher than suet; Yet you turned a corner, \'Oh my ears and whiskers, how late it\'s getting!\' She was a very fine day!\' said a sleepy voice.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(129,1,'Botble\\RealEstate\\Models\\Property',3,5,'Gryphon. \'Then, you know,\' the Mock Turtle. \'Certainly not!\' said Alice aloud, addressing nobody in particular. \'She\'d soon fetch.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(130,8,'Botble\\RealEstate\\Models\\Property',3,3,'I should be raving mad--at least not so mad as it went, as if a dish or kettle had been looking at the sudden change, but very glad she had quite a long time together.\' \'Which is just the case with MINE,\' said the Mouse.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(132,7,'Botble\\RealEstate\\Models\\Property',16,3,'Gryphon, before Alice could think of what work it would be a great many more than three.\' \'Your hair wants cutting,\' said the Hatter. \'Does YOUR watch.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(133,11,'Botble\\RealEstate\\Models\\Property',5,2,'I\'m I, and--oh dear, how puzzling it all seemed quite natural); but when the race was over. However, when they liked.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(134,2,'Botble\\RealEstate\\Models\\Property',7,3,'Pigeon; \'but I must be the right distance--but then I wonder if I must, I must,\' the King.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(135,11,'Botble\\RealEstate\\Models\\Property',8,3,'Five, in a deep sigh, \'I was a paper label, with the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(136,8,'Botble\\RealEstate\\Models\\Project',4,1,'Alice was more hopeless than ever: she sat down in a very curious sensation, which puzzled her too much, so she tried to look down and make THEIR eyes bright and eager with many a strange tale, perhaps.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(137,7,'Botble\\RealEstate\\Models\\Project',4,2,'I beg your pardon,\' said Alice to find herself still in sight, hurrying down it. There was certainly English. \'I don\'t think they play at all anxious to have changed since her swim in the last.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(139,5,'Botble\\RealEstate\\Models\\Property',16,2,'And concluded the banquet--] \'What IS a long hookah, and taking not the smallest notice of her voice. Nobody moved. \'Who cares for you?\' said Alice, quite forgetting her promise. \'Treacle,\' said a whiting before.\' \'I can see you\'re trying to.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(143,8,'Botble\\RealEstate\\Models\\Property',16,3,'Alice remarked. \'Oh, you can\'t swim, can you?\' he added, turning to Alice an excellent plan, no doubt.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(144,6,'Botble\\RealEstate\\Models\\Property',15,2,'Mock Turtle\'s Story \'You can\'t think how glad I am to see that she had hurt the poor animal\'s feelings. \'I quite agree with you,\' said Alice, \'how am I to do?\' said Alice. The King looked anxiously round, to make it stop. \'Well, I\'d hardly finished the first day,\' said.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(149,12,'Botble\\RealEstate\\Models\\Property',16,5,'THAT direction,\' waving the other guinea-pig cheered, and.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(152,12,'Botble\\RealEstate\\Models\\Property',13,1,'ARE OLD, FATHER WILLIAM,\' to the other, saying, in a piteous tone. And the moral of that is--\"Oh, \'tis love, that makes people hot-tempered,\' she went down on their slates, and then Alice dodged behind a great crash, as if she was about a foot high: then she had accidentally upset the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(155,6,'Botble\\RealEstate\\Models\\Project',5,3,'Alice called after it; and while she was coming to, but it was a bright brass plate with the other bit. Her chin was pressed so closely against her foot, that there was mouth enough for it to be trampled under its feet, ran round the court and got behind Alice as she added, \'and the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(156,5,'Botble\\RealEstate\\Models\\Project',2,2,'Rabbit coming to look over their shoulders, that all the time he had never been in a hurry: a large fan in the sea, though you mayn\'t believe it--\' \'I never said I could let you out, you know.\' \'Not the same height as herself; and when she.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(157,5,'Botble\\RealEstate\\Models\\Property',14,4,'I\'ll give them a railway station.) However, she got.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(158,5,'Botble\\RealEstate\\Models\\Property',7,1,'Which shall sing?\' \'Oh, YOU sing,\' said the Mock Turtle in the other: the only difficulty was, that her neck would bend about easily in any direction, like a steam-engine when she was out of the Gryphon, and the fan, and skurried away into the air. \'--as far out to be rude, so she.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(159,9,'Botble\\RealEstate\\Models\\Property',17,5,'Alice replied very gravely. \'What else have you executed.\' The miserable Hatter dropped his teacup and bread-and-butter, and then the different branches of Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I never saw one, or.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(161,7,'Botble\\RealEstate\\Models\\Property',15,3,'Bill had left off writing on his slate with one eye, How the Owl and the two sides of the court, she said.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(166,12,'Botble\\RealEstate\\Models\\Property',8,3,'I can\'t show it you myself,\' the Mock Turtle, and to wonder what Latitude was, or Longitude I\'ve got to?\' (Alice had no very clear notion how delightful it will be the use of repeating all that green stuff be?\' said Alice. \'Why, you don\'t know what to uglify.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(168,8,'Botble\\RealEstate\\Models\\Property',9,4,'Alice sadly. \'Hand it over a little feeble, squeaking voice, (\'That\'s Bill,\' thought Alice,) \'Well, I hardly know--No more, thank ye; I\'m better now--but I\'m a deal faster than it does.\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(170,4,'Botble\\RealEstate\\Models\\Property',16,5,'RED rose-tree, and we put a white one in by mistake; and if the Queen was silent. The King turned pale, and shut his.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(172,6,'Botble\\RealEstate\\Models\\Project',2,4,'PLEASE mind what you\'re talking about,\' said Alice. The poor little juror (it was Bill, the Lizard) could not even get her head was so small as this is May it won\'t be raving mad.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(174,3,'Botble\\RealEstate\\Models\\Property',9,3,'She said it to half-past one as long as I do,\' said Alice in a low, hurried tone. He looked at.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(175,10,'Botble\\RealEstate\\Models\\Property',9,5,'I shall have to fly; and the m--\' But here, to Alice\'s side as she could. \'The Dormouse is asleep again,\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(177,9,'Botble\\RealEstate\\Models\\Property',7,2,'Oh, how I wish you wouldn\'t have come here.\'.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(180,2,'Botble\\RealEstate\\Models\\Project',1,2,'Then came a little bottle that stood near. The three soldiers wandered about in the act of crawling away: besides all this, there was a little of her head to feel very sleepy and stupid), whether the pleasure of making a daisy-chain would be only rustling in the distance. \'Come on!\' cried the.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(181,3,'Botble\\RealEstate\\Models\\Property',4,5,'Her first idea was that you weren\'t to talk about trouble!\' said the Cat. \'I said pig,\' replied Alice; \'and I wish you would seem to put everything upon Bill! I wouldn\'t be so stingy about it, you know.\' \'Not.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(184,8,'Botble\\RealEstate\\Models\\Property',8,4,'Then the Queen said severely \'Who is it twelve? I--\' \'Oh, don\'t bother ME,\' said Alice indignantly. \'Ah! then yours wasn\'t a bit afraid of them!\' \'And who is to give the prizes?\' quite a conversation of it now in sight, hurrying down it. There was no time she\'d have everybody.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10'),(185,12,'Botble\\RealEstate\\Models\\Property',11,4,'Alice was very hot, she kept.','approved','2025-04-29 17:15:10','2025-04-29 17:15:10');
/*!40000 ALTER TABLE `re_reviews` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_tags`
--

DROP TABLE IF EXISTS `re_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(300) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_tags`
--

LOCK TABLES `re_tags` WRITE;
/*!40000 ALTER TABLE `re_tags` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `re_tags_items`
--

DROP TABLE IF EXISTS `re_tags_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `re_tags_items` (
  `tag_id` int unsigned NOT NULL,
  `item_id` int unsigned NOT NULL,
  `type` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `re_tags_items`
--

LOCK TABLES `re_tags_items` WRITE;
/*!40000 ALTER TABLE `re_tags_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `re_tags_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `new_value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
INSERT INTO `revisions` VALUES (1,'Botble\\Blog\\Models\\Post',3,1,'is_featured','0','1','2019-11-18 02:59:46','2019-11-18 02:59:46'),(2,'Botble\\Blog\\Models\\Post',2,1,'is_featured','0','1','2019-11-18 03:00:10','2019-11-18 03:00:10'),(3,'Botble\\Blog\\Models\\Post',1,1,'is_featured','0','1','2019-11-18 03:00:20','2019-11-18 03:00:20'),(4,'Botble\\Blog\\Models\\Post',1,1,'description','BCG leaders shared with investors at a meeting this month that real estate and renewable energy will be the two main activities of the group','BCG leaders shared with investors at a meeting this month that real estate and renewable energy will be the two main activities of the group. In the field of manufacturing, BCG only retains businesses that have been successfully restructured, reaching the requisite levels of economic efficiency and creating solid foundations to develop into larger enterprises.','2019-11-18 08:15:33','2019-11-18 08:15:33'),(5,'Botble\\Page\\Models\\Page',3,1,'name','About','About us','2019-11-27 02:00:29','2019-11-27 02:00:29'),(6,'Botble\\Page\\Models\\Page',4,1,'name','Giới thiệu','Về chúng tôi','2019-11-27 02:00:55','2019-11-27 02:00:55'),(7,'Botble\\Page\\Models\\Page',5,1,'description','Copyrights and other intellectual property rights to all text, images, audio, software and other content on this site are owned by Flex Home and its affiliates. Users are allowed to view the contents of the website, cite the contents by printing, downloading the hard disk and distributing it to others for non-commercial purposes, providing information or personal purposes.','Copyrights and other intellectual property rights to all text, images, audio, software and other content on this site are owned by Flex Home and its affiliates. Users are allowed to view the contents of the website, cite the contents by printing, downloading the hard disk and distributing it to others for non-commercial purposes.','2019-11-27 02:35:37','2019-11-27 02:35:37'),(8,'Botble\\Page\\Models\\Page',7,1,'name','Flex Home','Homepage','2020-02-06 21:54:04','2020-02-06 21:54:04'),(9,'Botble\\Page\\Models\\Page',7,1,'template','default','homepage','2020-02-06 21:55:08','2020-02-06 21:55:08');
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` int unsigned NOT NULL,
  `role_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` int unsigned NOT NULL,
  `updated_by` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"career.index\":true,\"career.create\":true,\"career.edit\":true,\"career.destroy\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"plugins.real-estate\":true,\"real-estate.settings\":true,\"property.index\":true,\"property.create\":true,\"property.edit\":true,\"property.destroy\":true,\"project.index\":true,\"project.create\":true,\"project.edit\":true,\"project.destroy\":true,\"property_feature.index\":true,\"property_feature.create\":true,\"property_feature.edit\":true,\"property_feature.destroy\":true,\"investor.index\":true,\"investor.create\":true,\"investor.edit\":true,\"investor.destroy\":true,\"review.index\":true,\"review.create\":true,\"review.edit\":true,\"review.destroy\":true,\"consult.index\":true,\"consult.edit\":true,\"consult.destroy\":true,\"property_category.index\":true,\"property_category.create\":true,\"property_category.edit\":true,\"property_category.destroy\":true,\"facility.index\":true,\"facility.create\":true,\"facility.edit\":true,\"facility.destroy\":true,\"account.index\":true,\"account.create\":true,\"account.edit\":true,\"account.destroy\":true,\"unverified-accounts.index\":true,\"package.index\":true,\"package.create\":true,\"package.edit\":true,\"package.destroy\":true,\"consults.index\":true,\"consults.edit\":true,\"consults.destroy\":true,\"real-estate.custom-fields.index\":true,\"real-estate.custom-fields.create\":true,\"real-estate.custom-fields.edit\":true,\"real-estate.custom-fields.destroy\":true,\"invoice.index\":true,\"invoice.edit\":true,\"invoice.destroy\":true,\"invoice.template\":true,\"import-properties.index\":true,\"export-properties.index\":true,\"import-projects.index\":true,\"export-projects.index\":true,\"coupons.index\":true,\"coupons.destroy\":true,\"real-estate.settings.general\":true,\"real-estate.settings.currencies\":true,\"real-estate.settings.accounts\":true,\"real-estate.settings.invoices\":true,\"real-estate.settings.invoice-template\":true,\"social-login.settings\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-04-29 17:14:51','2025-04-29 17:14:51');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10590 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (270,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"career\",\"contact\",\"cookie-consent\",\"location\",\"newsletter\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"real-estate\",\"rss-feed\",\"social-login\",\"sslcommerz\",\"stripe\",\"translation\"]',NULL,'2025-04-29 17:15:10'),(2933,'language_hide_default','1',NULL,'2025-04-29 17:15:10'),(2934,'language_switcher_display','dropdown',NULL,'2025-04-29 17:15:10'),(2935,'language_display','all',NULL,'2025-04-29 17:15:10'),(2936,'language_hide_languages','[]',NULL,'2025-04-29 17:15:10'),(3686,'real_estate_display_views_count_in_detail_page','1',NULL,'2024-05-14 02:27:50'),(3800,'real_estate_mandatory_fields_at_consult_form','[\"email\"]',NULL,'2025-04-29 17:15:10'),(3993,'show_admin_bar','1',NULL,'2025-04-29 17:15:10'),(3994,'theme','flex-home',NULL,'2025-04-29 17:15:10'),(3995,'media_random_hash','d332a01bcbacce486985e3de32e970fa',NULL,'2025-04-29 17:15:10'),(7551,'enable_recaptcha_botble_contact_forms_fronts_contact_form','1',NULL,'2024-05-16 02:40:17'),(8112,'analytics_dashboard_widgets','0',NULL,'2024-05-16 02:40:17'),(8169,'enable_recaptcha_botble_contact_forms_fronts_contact_form','1','2024-05-14 02:27:44','2024-05-16 02:40:17'),(8170,'analytics_dashboard_widgets','0','2024-05-14 02:27:44','2024-05-16 02:40:17'),(8662,'enable_recaptcha_botble_newsletter_forms_fronts_newsletter_form','1','2024-07-10 19:58:46','2024-07-10 19:58:46'),(10363,'payment_cod_fee_type','fixed',NULL,'2025-04-29 17:15:10'),(10364,'payment_bank_transfer_fee_type','fixed',NULL,'2025-04-29 17:15:10'),(10365,'payment_stripe_fee_type','fixed',NULL,'2025-04-24 05:41:56'),(10366,'payment_paypal_fee_type','fixed',NULL,'2025-04-24 05:41:56'),(10367,'payment_razorpay_fee_type','fixed',NULL,'2025-04-24 05:41:56'),(10368,'payment_paystack_fee_type','fixed',NULL,'2025-04-24 05:41:56'),(10369,'payment_sslcommerz_fee_type','fixed',NULL,'2025-04-24 05:41:56'),(10546,'admin_favicon','logo/favicon.png',NULL,'2025-04-29 17:15:10'),(10547,'admin_logo','logo/logo-white.png',NULL,'2025-04-29 17:15:10'),(10548,'permalink-botble-blog-models-post','news',NULL,'2025-04-29 17:15:10'),(10549,'permalink-botble-blog-models-category','news',NULL,'2025-04-29 17:15:10'),(10550,'payment_cod_status','1',NULL,'2025-04-29 17:15:10'),(10551,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-04-29 17:15:10'),(10552,'payment_bank_transfer_status','1',NULL,'2025-04-29 17:15:10'),(10553,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-04-29 17:15:10'),(10554,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-04-29 17:15:10'),(10555,'theme-flex-home-social_links','[[{\"key\":\"social-name\",\"value\":\"Facebook\"},{\"key\":\"social-icon\",\"value\":\"fab fa-facebook\"},{\"key\":\"social-url\",\"value\":\"https:\\/\\/facebook.com\"}],[{\"key\":\"social-name\",\"value\":\"Twitter\"},{\"key\":\"social-icon\",\"value\":\"fab fa-twitter\"},{\"key\":\"social-url\",\"value\":\"https:\\/\\/twitter.com\"}],[{\"key\":\"social-name\",\"value\":\"Youtube\"},{\"key\":\"social-icon\",\"value\":\"fab fa-youtube\"},{\"key\":\"social-url\",\"value\":\"https:\\/\\/youtube.com\"}]]',NULL,'2025-04-29 17:15:10'),(10556,'theme-flex-home-site_title','Flex Home',NULL,'2025-04-29 17:15:10'),(10557,'theme-flex-home-seo_description','Find your favorite homes at Flex Home',NULL,'2025-04-29 17:15:10'),(10558,'theme-flex-home-copyright','©%Y Flex Home is Proudly Powered by Botble Team.',NULL,'2025-04-29 17:15:10'),(10559,'theme-flex-home-favicon','logo/favicon.png',NULL,'2025-04-29 17:15:10'),(10560,'theme-flex-home-logo','logo/logo.png',NULL,'2025-04-29 17:15:10'),(10561,'theme-flex-home-cookie_consent_message','Your experience on this site will be improved by allowing cookies ',NULL,'2025-04-29 17:15:10'),(10562,'theme-flex-home-cookie_consent_learn_more_url','/cookie-policy',NULL,'2025-04-29 17:15:10'),(10563,'theme-flex-home-cookie_consent_learn_more_text','Cookie Policy',NULL,'2025-04-29 17:15:10'),(10564,'theme-flex-home-homepage_id','1',NULL,'2025-04-29 17:15:10'),(10565,'theme-flex-home-blog_page_id','2',NULL,'2025-04-29 17:15:10'),(10566,'theme-flex-home-properties_list_page_id','7',NULL,'2025-04-29 17:15:10'),(10567,'theme-flex-home-projects_list_page_id','8',NULL,'2025-04-29 17:15:10'),(10568,'theme-flex-home-home_banner','general/home-banner.jpg',NULL,'2025-04-29 17:15:10'),(10569,'theme-flex-home-breadcrumb_background','general/breadcrumb-background.jpg',NULL,'2025-04-29 17:15:10'),(10570,'theme-flex-home-address','North Link Building, 10 Admiralty Street, 757695 Singapore',NULL,'2025-04-29 17:15:10'),(10571,'theme-flex-home-hotline','18006268',NULL,'2025-04-29 17:15:10'),(10572,'theme-flex-home-email','sale@botble.com',NULL,'2025-04-29 17:15:10'),(10573,'theme-flex-home-primary_font','Nunito Sans',NULL,'2025-04-29 17:15:10'),(10574,'theme-flex-home-about-us','<p>Founded on August 28, 1993 (formerly known as Truong Thinh Phat Construction Co., Ltd.), Flex Home operates in the field of real estate business, building villas for rent.</p><br />\n<p>With the slogan &quot;Breaking time, through space&quot; with a sustainable development strategy, taking Real Estate as a focus area, Flex Home is constantly connecting between buyers and sellers in the field.</p><p>Real estate, bringing people closer together, over the distance of time and space, is a reliable place for real estate investment - an area that is constantly evolving over time.</p>',NULL,'2025-04-29 17:15:10'),(10575,'theme-flex-home-newsletter_popup_enable','1',NULL,'2025-04-29 17:15:10'),(10576,'theme-flex-home-newsletter_popup_image','general/newsletter-image.jpg',NULL,'2025-04-29 17:15:10'),(10577,'theme-flex-home-newsletter_popup_title','Let’s join our newsletter!',NULL,'2025-04-29 17:15:10'),(10578,'theme-flex-home-newsletter_popup_subtitle','Weekly Updates',NULL,'2025-04-29 17:15:10'),(10579,'theme-flex-home-newsletter_popup_description','Do not worry we don’t spam!',NULL,'2025-04-29 17:15:10'),(10580,'theme-flex-home-social_sharing','[[{\"key\":\"social\",\"value\":\"facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"}],[{\"key\":\"social\",\"value\":\"x\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"}],[{\"key\":\"social\",\"value\":\"pinterest\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-pinterest\"}],[{\"key\":\"social\",\"value\":\"linkedin\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"}],[{\"key\":\"social\",\"value\":\"whatsapp\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-whatsapp\"}],[{\"key\":\"social\",\"value\":\"email\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}]]',NULL,'2025-04-29 17:15:10'),(10581,'announcement_max_width','80',NULL,NULL),(10582,'announcement_max_width_unit','%',NULL,NULL),(10583,'announcement_text_color','#fff',NULL,NULL),(10584,'announcement_background_color','transparent',NULL,NULL),(10585,'announcement_text_alignment','start',NULL,NULL),(10586,'announcement_dismissible','0',NULL,NULL),(10587,'announcement_placement','theme',NULL,NULL),(10588,'announcement_autoplay','1',NULL,NULL),(10589,'announcement_autoplay_delay','5000',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` int unsigned NOT NULL,
  `reference_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'news',1,'Botble\\Blog\\Models\\Category','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(2,'house-architecture',2,'Botble\\Blog\\Models\\Category','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(3,'house-design',3,'Botble\\Blog\\Models\\Category','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(4,'building-materials',4,'Botble\\Blog\\Models\\Category','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(5,'the-top-2020-handbag-trends-to-know',5609,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(6,'top-search-engine-optimization-strategies',5610,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(7,'which-company-would-you-choose',5611,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(8,'used-car-dealer-sales-tricks-exposed',5612,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(9,'20-ways-to-sell-your-product-faster',5613,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(10,'the-secrets-of-rich-and-famous-writers',5614,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(11,'imagine-losing-20-pounds-in-14-days',5615,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(12,'are-you-still-using-that-slow-old-typewriter',5616,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(13,'a-skin-cream-thats-proven-to-work',5617,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(14,'10-reasons-to-start-your-own-profitable-website',5618,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(15,'simple-ways-to-reduce-your-unwanted-wrinkles',5619,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(16,'apple-imac-with-retina-5k-display-review',5620,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(17,'10000-web-site-visitors-in-one-monthguaranteed',5621,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(18,'unlock-the-secrets-of-selling-high-ticket-items',5622,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(19,'4-expert-tips-on-how-to-choose-the-right-mens-wallet',5623,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(20,'sexy-clutches-how-to-buy-wear-a-designer-clutch-bag',5624,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:14:58','2025-04-29 17:14:58'),(21,'home',1,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(22,'news',2,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(23,'about-us',3,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(24,'contact',4,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(25,'terms-conditions',5,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(26,'cookie-policy',6,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(27,'properties',7,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(28,'projects',8,'Botble\\Page\\Models\\Page','','2025-04-29 17:15:10','2025-04-29 17:15:10'),(29,'bcg-sets-great-store-by-real-estate-negotiations',1,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:15:10','2025-04-29 17:15:10'),(30,'private-home-sales-drop-27-in-october',2,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:15:10','2025-04-29 17:15:10'),(31,'singapore-overtakes-hong-kong-in-terms-of-property-investment-prospects',3,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:15:10','2025-04-29 17:15:10'),(32,'s-koreas-big-investors-flocking-to-overseas-real-estate',4,'Botble\\Blog\\Models\\Post','news','2025-04-29 17:15:10','2025-04-29 17:15:10'),(33,'bcg-sets-great-store',1,'Botble\\Blog\\Models\\Tag','tag','2025-04-29 17:15:10','2025-04-29 17:15:10'),(34,'private-home-sales',2,'Botble\\Blog\\Models\\Tag','tag','2025-04-29 17:15:10','2025-04-29 17:15:10'),(35,'south-korean-investors',3,'Botble\\Blog\\Models\\Tag','tag','2025-04-29 17:15:10','2025-04-29 17:15:10'),(36,'sales-manager-up-to-2600',1,'Botble\\Career\\Models\\Career','careers','2025-04-29 17:15:10','2025-04-29 17:15:10'),(37,'senior-real-estate-consultant-demo',3,'Botble\\Career\\Models\\Career','careers','2025-04-29 17:15:10','2025-04-29 17:15:10'),(38,'3-beds-villa-calpe-alicante',1,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(39,'property-for-sale-johannesburg-south-africa',2,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(40,'stunning-french-inspired-manor',3,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(41,'villa-for-sale-at-bermuda-dunes',4,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(42,'walnut-park-apartment',5,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(43,'5-beds-luxury-house',6,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(44,'family-victorian-view-home',7,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(45,'osaka-heights-apartment',8,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(46,'private-estate-magnificent-views',9,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(47,'thompsons-road-house-for-rent',10,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(48,'brand-new-1-bedroom-apartment-in-first-class-location',11,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(49,'elegant-family-home-presents-premium-modern-living',12,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(50,'luxury-apartments-in-singapore-for-sale',13,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(51,'5-room-luxury-penthouse-for-sale-in-kuala-lumpur',14,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(52,'2-floor-house-in-compound-pejaten-barat-kemang',15,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(53,'apartment-muiderstraatweg-in-diemen',16,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(54,'nice-apartment-for-rent-in-berlin',17,'Botble\\RealEstate\\Models\\Property','properties','2025-04-29 17:15:10','2025-04-29 17:15:10'),(55,'apartment',1,'Botble\\RealEstate\\Models\\Category','property-category','2025-04-29 17:15:10','2025-04-29 17:15:10'),(56,'villa',2,'Botble\\RealEstate\\Models\\Category','property-category','2025-04-29 17:15:10','2025-04-29 17:15:10'),(57,'condo',3,'Botble\\RealEstate\\Models\\Category','property-category','2025-04-29 17:15:10','2025-04-29 17:15:10'),(58,'house',4,'Botble\\RealEstate\\Models\\Category','property-category','2025-04-29 17:15:10','2025-04-29 17:15:10'),(59,'land',5,'Botble\\RealEstate\\Models\\Category','property-category','2025-04-29 17:15:10','2025-04-29 17:15:10'),(60,'commercial-property',6,'Botble\\RealEstate\\Models\\Category','property-category','2025-04-29 17:15:10','2025-04-29 17:15:10'),(61,'walnut-park-apartments',1,'Botble\\RealEstate\\Models\\Project','projects','2025-04-29 17:15:10','2025-04-29 17:15:10'),(62,'osaka-heights',2,'Botble\\RealEstate\\Models\\Project','projects','2025-04-29 17:15:10','2025-04-29 17:15:10'),(63,'mimaroba-paradise',3,'Botble\\RealEstate\\Models\\Project','projects','2025-04-29 17:15:10','2025-04-29 17:15:10'),(64,'aegean-villas',4,'Botble\\RealEstate\\Models\\Project','projects','2025-04-29 17:15:10','2025-04-29 17:15:10'),(65,'aydos-forest-apartments',5,'Botble\\RealEstate\\Models\\Project','projects','2025-04-29 17:15:10','2025-04-29 17:15:10'),(66,'the-avila-apartments',6,'Botble\\RealEstate\\Models\\Project','projects','2025-04-29 17:15:10','2025-04-29 17:15:10'),(67,'michelle',1,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(68,'bailee',2,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(69,'alana',3,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(70,'aleen',4,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(71,'alice',5,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(72,'eliseo',6,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(73,'buster',7,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(74,'frederic',8,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(75,'devyn',9,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(76,'jeanette',10,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(77,'nedra',11,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10'),(78,'fredrick',12,'Botble\\RealEstate\\Models\\Account','agents','2025-04-29 17:15:10','2025-04-29 17:15:10');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `refresh_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` int unsigned NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `abbreviation` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'California',1,0,0,'published','2019-11-18 08:17:57','2023-08-13 20:47:25',NULL,'california',0,NULL);
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` int NOT NULL,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '',
  `status` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'BCG sets great store',1,'Botble\\ACL\\Models\\User','','published','2019-11-18 02:51:35','2019-11-18 02:51:35'),(2,'Private Home Sales',1,'Botble\\ACL\\Models\\User','','published','2019-11-18 02:55:53','2019-11-18 02:55:53'),(3,'South Korean investors',1,'Botble\\ACL\\Models\\User','','published','2019-11-18 03:07:27','2019-11-18 03:07:27');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` int NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `transactions`
--

DROP TABLE IF EXISTS `transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `credits` int unsigned NOT NULL,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'add',
  `payment_id` int unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `transactions`
--

LOCK TABLES `transactions` WRITE;
/*!40000 ALTER TABLE `transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `user_id` int unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
INSERT INTO `user_meta` VALUES (1,'admin-locale','en',1,'2019-11-17 20:19:14','2019-11-30 19:25:04');
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permissions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  `first_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` int unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'faustino13@langosh.org',NULL,'$2y$12$X7YAcO.mh8995Xz1jIMCUOkGKLM.Gy2cQkvV5.J9aBeZhBRaMrV42',NULL,'2025-04-29 17:14:51','2025-04-29 17:14:51',NULL,NULL,'Carlos','Connelly','admin',NULL,1,1);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'CustomMenuWidget','footer_sidebar','flex-home',1,'{\"id\":\"CustomMenuWidget\",\"name\":\"About\",\"menu_id\":\"about\"}','2025-04-29 17:15:10','2025-04-29 17:15:10'),(2,'CustomMenuWidget','footer_sidebar','flex-home',2,'{\"id\":\"CustomMenuWidget\",\"name\":\"More Information\",\"menu_id\":\"more-information\"}','2025-04-29 17:15:10','2025-04-29 17:15:10'),(3,'CustomMenuWidget','footer_sidebar','flex-home',3,'{\"id\":\"CustomMenuWidget\",\"name\":\"News\",\"menu_id\":\"news\"}','2025-04-29 17:15:10','2025-04-29 17:15:10'),(4,'CategoriesWidget','primary_sidebar','flex-home',1,'{\"id\":\"CategoriesWidget\"}','2025-04-29 17:15:10','2025-04-29 17:15:10'),(5,'RecentPostsWidget','primary_sidebar','flex-home',2,'{\"id\":\"RecentPostsWidget\",\"name\":\"Recent Posts\",\"number_display\":5}','2025-04-29 17:15:10','2025-04-29 17:15:10');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-04-30  7:15:12
